/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins;

import com.gtnewhorizon.gtnhlib.mixin.IMixins;
import com.gtnewhorizon.gtnhlib.mixin.ITargetedMod;
import com.gtnewhorizon.gtnhlib.mixin.MixinBuilder;
import com.gtnewhorizon.gtnhlib.mixin.Phase;
import com.gtnewhorizon.gtnhlib.mixin.Side;
import com.mitchej123.hodgepodge.config.ASMConfig;
import com.mitchej123.hodgepodge.config.DebugConfig;
import com.mitchej123.hodgepodge.config.FixesConfig;
import com.mitchej123.hodgepodge.config.SpeedupsConfig;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.mixins.TargetedMod;
import java.util.List;
import java.util.function.Supplier;

public enum Mixins implements IMixins
{
    ONLY_LOAD_LANGUAGES_ONCE_PER_FILE(new MixinBuilder("Only load languages once per file").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinLanguageRegistry"}).setApplyIf(() -> FixesConfig.onlyLoadLanguagesOnce).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    CHANGE_CATEGORY_SPRINT_KEY(new MixinBuilder("Moves the sprint keybind to the movement category").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.CLIENT).setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGameSettings_SprintKey"}).setApplyIf(() -> TweaksConfig.changeSprintCategory)),
    FIX_TOO_MANY_ALLOCATIONS_CHUNK_POSITION_INT_PAIR(new MixinBuilder("Stops MC from allocating too many ChunkPositionIntPair objects").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinChunkCoordIntPair_FixAllocations", "minecraft.MixinWorld_FixAllocations", "minecraft.MixinWorldClient_FixAllocations", "minecraft.MixinAnvilChunkLoader_FixAllocations"}).setApplyIf(() -> FixesConfig.fixTooManyAllocationsChunkPositionIntPair)),
    FIX_TOO_MANY_ALLOCATIONS_CHUNK_POSITION_INT_PAIR_OPTIFINE_INCOMPAT(new MixinBuilder("Stops MC from allocating too many ChunkPositionIntPair objects").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.OPTIFINE).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinWorldServer_FixAllocations"}).setApplyIf(() -> FixesConfig.fixTooManyAllocationsChunkPositionIntPair)),
    ADD_SIMULATION_DISTANCE_OPTION(new MixinBuilder("Add option to separate simulation distance from render distance").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setPhase(Phase.EARLY).addExcludedMod((ITargetedMod)TargetedMod.OPTIFINE).addMixinClasses(new String[]{"minecraft.MixinWorld_SimulationDistance", "minecraft.MixinWorldServer_SimulationDistance", "minecraft.MixinChunk_SimulationDistance"}).setApplyIf(() -> FixesConfig.addSimulationDistance)),
    FIX_RESOURCEPACK_FOLDER_OPENING(new MixinBuilder("Fix resource pack folder sometimes not opening on windows").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiScreenResourcePacks"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixResourcePackOpening).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_ENCHANTMENT_LEVEL_NUMERALS(new MixinBuilder("Fix enchantment levels not displaying properly above a certain value").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinEnchantment_FixRomanNumerals"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixEnchantmentNumerals || TweaksConfig.arabicNumbersForEnchantsPotions).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_CONTAINER_PUT_STACKS_IN_SLOTS(new MixinBuilder("Prevents crash if server sends container with wrong itemStack size").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinContainer"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixContainerPutStacksInSlots).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_NETHANDLERPLAYCLIENT_HANDLE_SET_SLOT(new MixinBuilder("Prevents crash if server sends itemStack with index larger than client's container").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinNetHandlerPlayClient_FixHandleSetSlot"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixNetHandlerPlayClientHandleSetSlot).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_NETHANDLERLOGINSERVER_OFFLINEMODE(new MixinBuilder("Allows the server to assign the logged in UUID to the same username when online_mode is false").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinNetHandlerLoginServer_OfflineMode"}).setSide(Side.SERVER).setApplyIf(() -> FixesConfig.fixNetHandlerLoginServerOfflineMode).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_INVENTORY_POTION_EFFECT_NUMERALS(new MixinBuilder("Fix potion effects level not displaying properly above a certain value").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinInventoryEffectRenderer_FixPotionEffectNumerals", "minecraft.MixinItemPotion_FixRomanNumerals"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixPotionEffectNumerals || TweaksConfig.arabicNumbersForEnchantsPotions).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_HASTE_ARM_SWING_ANIMATION(new MixinBuilder("Fix arm not swinging when having too much haste").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinEntityLivingBase_FixHasteArmSwing"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixHasteArmSwing).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    DISABLE_REALMS_BUTTON(new MixinBuilder("Disable Realms button in main menu").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiMainMenu_DisableRealmsButton"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.disableRealmsButton).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    ADD_TIME_GET(new MixinBuilder("Add /time get command").addMixinClasses(new String[]{"minecraft.MixinCommandTime"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.addTimeGet).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    OPTIMIZE_WORLD_UPDATE_LIGHT(new MixinBuilder("Optimize world updateLightByType method").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinWorld_FixLightUpdateLag"}).setSide(Side.BOTH).addExcludedMod((ITargetedMod)TargetedMod.ARCHAICFIX).addExcludedMod((ITargetedMod)TargetedMod.ANGELICA).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.optimizeWorldUpdateLight)),
    FIX_FRIENDLY_CREATURE_SOUNDS(new MixinBuilder("Fix Friendly Creature Sounds").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinSoundHandler"}).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.fixFriendlyCreatureSounds)),
    LOGARITHMIC_VOLUME_CONTROL(new MixinBuilder("Logarithmic Volume Control").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinSoundManager", "minecraft.MixinSoundManagerLibraryLoader"}).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.logarithmicVolumeControl)),
    THROTTLE_ITEMPICKUPEVENT(new MixinBuilder("Throttle Item Pickup Event").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinEntityPlayer"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.throttleItemPickupEvent).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_PERSPECTIVE_CAMERA(new MixinBuilder("Camera Perspective Fix").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinEntityRenderer"}).setSide(Side.CLIENT).addExcludedMod((ITargetedMod)TargetedMod.ARCHAICFIX).addExcludedMod((ITargetedMod)TargetedMod.ANGELICA).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.fixPerspectiveCamera)),
    FIX_DEBUG_BOUNDING_BOX(new MixinBuilder("Fix Bounding Box").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinRenderManager"}).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.fixDebugBoundingBox)),
    FENCE_CONNECTIONS_FIX(new MixinBuilder("Fix Fence Connections").addMixinClasses(new String[]{"minecraft.MixinBlockFence"}).setSide(Side.BOTH).setPhase(Phase.EARLY).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.fixFenceConnections)),
    FIX_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder("Fix Inventory Offset with Potions").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinInventoryEffectRenderer_PotionOffset"}).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset)),
    FIX_POTION_EFFECT_RENDERING(new MixinBuilder("Fix Potion Effect Rendering").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinInventoryEffectRenderer_PotionEffectRendering"}).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.fixPotionEffectRender)),
    FIX_IMMOBILE_FIREBALLS(new MixinBuilder("Fix Immobile Fireballs").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinEntityFireball"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.fixImmobileFireballs).setSide(Side.BOTH)),
    FIX_REED_PLACING(new MixinBuilder("Fix placement of Sugar Canes").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinItemReed"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixSugarCanePlacement)),
    LONGER_CHAT(new MixinBuilder("Longer Chat").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiNewChat_LongerChat"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.longerChat).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    TRANSPARENT_CHAT(new MixinBuilder("Transparent Chat").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiNewChat_TransparentChat"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.transparentChat).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_ENTITY_ATTRIBUTES_RANGE(new MixinBuilder("Fix Entity Attributes Range").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinNetHandlerPlayClient_FixEntityAttributesRange"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixEntityAttributesRange).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    LONGER_MESSAGES_CLIENT(new MixinBuilder("Longer Messages Client Side").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiChat_LongerMessages"}).setApplyIf(() -> true).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.CLIENT)),
    LONGER_MESSAGES_SERVER(new MixinBuilder("Longer Messages Server Side").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinC01PacketChatMessage_LongerMessages"}).setApplyIf(() -> true).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH)),
    SPEEDUP_GRASS_BLOCK_RANDOM_TICKING(new MixinBuilder("Speed up grass block random ticking").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinBlockGrass"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setApplyIf(() -> SpeedupsConfig.speedupGrassBlockRandomTicking)),
    SPEEDUP_CHUNK_PROVIDER_CLIENT(new MixinBuilder("Speed up ChunkProviderClient").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"minecraft.MixinChunkProviderClient_RemoveChunkListing"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.FASTCRAFT).setApplyIf(() -> SpeedupsConfig.speedupChunkProviderClient && ASMConfig.speedupLongIntHashMap)),
    BETTER_HASHCODES(new MixinBuilder("Optimize various Hashcode").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinChunkCoordinates_BetterHash", "minecraft.MixinChunkCoordIntPair_BetterHash"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> SpeedupsConfig.speedupChunkCoordinatesHashCode)),
    TCP_NODELAY(new MixinBuilder("Set TCP NODELAY").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinTcpNoDelay"}).setApplyIf(() -> SpeedupsConfig.tcpNoDelay).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    WORLD_UNPROTECTED_GET_BLOCK(new MixinBuilder("Fix world unprotected getBlock").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinWorldGetBlock"}).setApplyIf(() -> FixesConfig.fixVanillaUnprotectedGetBlock).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    WORLD_UNPROTECTED_LIGHT_VALUE(new MixinBuilder("Fix world unprotected light value").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinWorldLightValue"}).setApplyIf(() -> FixesConfig.fixGetBlockLightValue).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    VILLAGE_UNCHECKED_GET_BLOCK(new MixinBuilder("Fix Village unchecked getBlock").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinVillage", "minecraft.MixinVillageCollection"}).setApplyIf(() -> FixesConfig.fixVillageUncheckedGetBlock).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FORGE_HOOKS_URL_FIX(new MixinBuilder("Fix forge URL hooks").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinForgeHooks"}).setApplyIf(() -> FixesConfig.fixUrlDetection).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FORGE_UPDATE_CHECK_FIX(new MixinBuilder("Fix the forge update checker").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"forge.MixinForgeVersion_FixUpdateCheck"}).setApplyIf(() -> FixesConfig.fixForgeUpdateChecker).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FORGE_FIX_CLASS_TYPO(new MixinBuilder("Fix a class name typo in MinecraftForge's initialize method").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"forge.MixinMinecraftForge"}).setApplyIf(() -> FixesConfig.fixEffectRendererClassTypo).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    NORTHWEST_BIAS_FIX(new MixinBuilder("Fix Northwest Bias").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinRandomPositionGenerator"}).setApplyIf(() -> FixesConfig.fixNorthWestBias).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    SPEEDUP_VANILLA_FURNACE(new MixinBuilder("Speedup Vanilla Furnace").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinFurnaceRecipes"}).setApplyIf(() -> SpeedupsConfig.speedupVanillaFurnace).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addTargetedMod((ITargetedMod)TargetedMod.GTNHLIB)),
    GAMEOVER_GUI_LOCKED_DISABLED(new MixinBuilder("Fix Gameover GUI").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"minecraft.MixinGuiGameOver"}).setApplyIf(() -> FixesConfig.fixGuiGameOver).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    PREVENT_PICKUP_LOOT(new MixinBuilder("Prevent monsters from picking up loot").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinEntityLivingPickup"}).setApplyIf(() -> TweaksConfig.preventPickupLoot).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    DROP_PICKED_LOOT_ON_DESPAWN(new MixinBuilder("Drop picked up loot on despawn").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinEntityLivingDrop"}).setApplyIf(() -> TweaksConfig.dropPickedLootOnDespawn).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_HOPPER_HIT_BOX(new MixinBuilder("Fix Vanilla Hopper hit box").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinBlockHopper"}).setApplyIf(() -> FixesConfig.fixHopperHitBox).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    TILE_RENDERER_PROFILER_DISPATCHER(new MixinBuilder("TileEntity Render Dispatcher Fix").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.profiler.TileEntityRendererDispatcherMixin"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.enableTileRendererProfiler).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    TILE_RENDERER_PROFILER_MINECRAFT(new MixinBuilder("Tile Entity Render Profiler").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.profiler.MinecraftMixin"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.enableTileRendererProfiler).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    DIMENSION_CHANGE_FIX(new MixinBuilder("Dimension Change Heart Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinServerConfigurationManager", "minecraft.MixinEntityPlayerMP"}).setApplyIf(() -> FixesConfig.fixDimensionChangeAttributes).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_EATING_STACKED_STEW(new MixinBuilder("Stacked Mushroom Stew Eating Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinItemSoup"}).setApplyIf(() -> FixesConfig.fixEatingStackedStew).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    INCREASE_PARTICLE_LIMIT(new MixinBuilder("Increase Particle Limit").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinEffectRenderer"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.increaseParticleLimit).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    ENLARGE_POTION_ARRAY(new MixinBuilder("Make the Potion array larger").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinPotion"}).setApplyIf(() -> FixesConfig.enlargePotionArray).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_POTION_LIMIT(new MixinBuilder("Fix Potion Limit").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinPotionEffect"}).setApplyIf(() -> FixesConfig.fixPotionLimit).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_HOPPER_VOIDING_ITEMS(new MixinBuilder("Fix Hopper Voiding Items").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinTileEntityHopper"}).setApplyIf(() -> FixesConfig.fixHopperVoidingItems).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_HUGE_CHAT_KICK(new MixinBuilder("Fix huge chat kick").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinS02PacketChat"}).setApplyIf(() -> FixesConfig.fixHugeChatKick).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_BOGUS_INTEGRATED_SERVER_NPE(new MixinBuilder("Fix bogus FMLProxyPacket NPEs on integrated server crashes").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"fml.MixinFMLProxyPacket", "fml.MixinNetworkDispatcher", "minecraft.NetworkManagerAccessor"}).setApplyIf(() -> FixesConfig.fixBogusIntegratedServerNPEs).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_LAG_ON_INVENTORY_SYNC(new MixinBuilder("Fix inventory sync lag").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinInventoryCrafting"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixInventorySyncLag).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_LOGIN_DIMENSION_ID_OVERFLOW(new MixinBuilder("Fix dimension id overflowing when a player first logins on a server").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.packets.MixinS01PacketJoinGame_FixDimensionID"}).setApplyIf(() -> FixesConfig.fixLoginDimensionIDOverflow).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_WORLD_SERVER_LEAKING_UNLOADED_ENTITIES(new MixinBuilder("Fix world server leaking unloaded entities").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinWorldServerUpdateEntities"}).setApplyIf(() -> FixesConfig.fixWorldServerLeakingUnloadedEntities).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_SKIN_MANAGER_CLIENT_WORLD_LEAK(new MixinBuilder("Fix skin manager client world leak").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"minecraft.MixinSkinManager$2"}).setApplyIf(() -> FixesConfig.fixSkinManagerLeakingClientWorld).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_REDSTONE_TORCH_WORLD_LEAK(new MixinBuilder("Fix world leak in redstone torch").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinBlockRedstoneTorch"}).setApplyIf(() -> FixesConfig.fixRedstoneTorchWorldLeak).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.BUGTORCH)),
    FIX_ARROW_WRONG_LIGHTING(new MixinBuilder("Fix arrow wrong lighting").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinRendererLivingEntity"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixGlStateBugs).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_RESIZABLE_FULLSCREEN(new MixinBuilder("Fix Resizable Fullscreen").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinMinecraft_ResizableFullscreen"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixResizableFullscreen).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_UNFOCUSED_FULLSCREEN(new MixinBuilder("Fix Unfocused Fullscreen").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinMinecraft_UnfocusedFullscreen"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixUnfocusedFullscreen).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)com.gtnewhorizon.gtnhlib.mixin.TargetedMod.ARCHAICFIX)),
    FIX_RENDERERS_WORLD_LEAK(new MixinBuilder("Fix Renderers World Leak").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinMinecraft_ClearRenderersWorldLeak", "minecraft.MixinRenderGlobal_FixWordLeak"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixRenderersWorldLeak).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_OPTIFINE_CHUNKLOADING_CRASH(new MixinBuilder("Fix Optifine Chunkloading Crash").setPhase(Phase.EARLY).setApplyIf(() -> FixesConfig.fixOptifineChunkLoadingCrash).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addTargetedMod((ITargetedMod)TargetedMod.OPTIFINE).addMixinClasses(new String[]{"minecraft.MixinGameSettings_FixOFChunkLoading"})),
    ADD_TOGGLE_DEBUG_MESSAGE(new MixinBuilder("Toggle Debug Message").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinMinecraft_ToggleDebugMessage"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.addToggleDebugMessage).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    OPTIMIZE_TEXTURE_LOADING(new MixinBuilder("Optimize Texture Loading").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.textures.client.MixinTextureUtil"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.ANGELICA).setApplyIf(() -> SpeedupsConfig.optimizeTextureLoading).setSide(Side.CLIENT)),
    HIDE_POTION_PARTICLES(new MixinBuilder("Hide Potion Particles").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinEntityLivingBase_HidePotionParticles"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.hidePotionParticlesFromSelf).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    DIMENSION_MANAGER_DEBUG(new MixinBuilder("Dimension Manager Debug").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinDimensionManager"}).setApplyIf(() -> DebugConfig.dimensionManagerDebug).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    OPTIMIZE_TILEENTITY_REMOVAL(new MixinBuilder("Optimize TileEntity Removal").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinWorldUpdateEntities"}).setApplyIf(() -> SpeedupsConfig.optimizeTileentityRemoval).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.FASTCRAFT).addExcludedMod((ITargetedMod)TargetedMod.BUKKIT)),
    FIX_POTION_ITERATING(new MixinBuilder("Fix Potion Iterating").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinEntityLivingBase_FixPotionException"}).setApplyIf(() -> FixesConfig.fixPotionIterating).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    ENHANCE_NIGHT_VISION(new MixinBuilder("Remove the blueish sky tint from night vision").setSide(Side.CLIENT).setPhase(Phase.EARLY).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.enhanceNightVision).addMixinClasses(new String[]{"minecraft.MixinEntityRenderer_EnhanceNightVision"})),
    OPTIMIZE_ASMDATATABLE_INDEX(new MixinBuilder("Optimize ASM DataTable Index").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"fml.MixinASMDataTable"}).setApplyIf(() -> SpeedupsConfig.optimizeASMDataTable).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    SQUASH_BED_ERROR_MESSAGE(new MixinBuilder("Stop \"You can only sleep at night\" message filling the chat").addMixinClasses(new String[]{"minecraft.MixinNetHandlerPlayClient"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.squashBedErrorMessage).setPhase(Phase.EARLY).setSide(Side.CLIENT)),
    CHUNK_SAVE_CME_DEBUG(new MixinBuilder("Add debugging code to Chunk Save CME").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinNBTTagCompound"}).setApplyIf(() -> DebugConfig.chunkSaveCMEDebug).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    SPEEDUP_NBT_COPY(new MixinBuilder("Speed up NBT copy").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinNBTTagCompound_speedup", "minecraft.MixinNBTTagList_speedup"}).setApplyIf(() -> ASMConfig.speedupNBTTagCompoundCopy).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.BUKKIT)),
    STRING_POOLER_NBT_TAG(new MixinBuilder("Pool NBT Strings").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinNBTTagCompound_stringPooler"}).setApplyIf(() -> TweaksConfig.enableTagCompoundStringPooling).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    STRING_POOLER_NBT_STRING(new MixinBuilder("Pool NBT Strings").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinNBTTagString_stringPooler"}).setApplyIf(() -> TweaksConfig.enableNBTStringPooling).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    THREADED_WORLDDATA_SAVING(new MixinBuilder("Threaded WorldData Saving").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinMapStorage_threadedIO", "minecraft.MixinSaveHandler_threadedIO", "minecraft.MixinScoreboardSaveData_threadedIO", "minecraft.MixinVillageCollection_threadedIO", "minecraft.MixinMapData_threadedIO", "forge.MixinForgeChunkManager_threadedIO"}).setApplyIf(() -> TweaksConfig.threadedWorldDataSaving).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    DONT_SLEEP_ON_THREADED_IO(new MixinBuilder("Don't sleep on threaded IO").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinThreadedFileIOBase_noSleep"}).setApplyIf(() -> TweaksConfig.dontSleepOnThreadedIO).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    OPTIMIZE_MOB_SPAWNING(new MixinBuilder("Optimize Mob Spawning").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinSpawnerAnimals_optimizeSpawning", "minecraft.MixinSpawnListEntry_optimizeSpawning"}).setApplyIf(() -> SpeedupsConfig.optimizeMobSpawning).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.BUKKIT)),
    RENDER_DEBUG(new MixinBuilder("Render Debug").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinRenderGlobal"}).setSide(Side.CLIENT).setApplyIf(() -> DebugConfig.renderDebug).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.BUKKIT)),
    STATIC_LAN_PORT(new MixinBuilder("Static Lan Port").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.server.MixinHttpUtil"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.enableDefaultLanPort).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    CROSSHAIR_THIRDPERSON(new MixinBuilder("Crosshairs thirdperson").setPhase(Phase.EARLY).addMixinClasses(new String[]{"forge.MixinGuiIngameForge_CrosshairThirdPerson"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.hideCrosshairInThirdPerson).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    DONT_INVERT_CROSSHAIR_COLORS(new MixinBuilder("Don't invert crosshair colors").setPhase(Phase.EARLY).addMixinClasses(new String[]{"forge.MixinGuiIngameForge_CrosshairInvertColors"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.dontInvertCrosshairColor).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_OPENGUIHANDLER_WINDOWID(new MixinBuilder("Fix OpenGuiHandler").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"fml.MixinOpenGuiHandler"}).setApplyIf(() -> FixesConfig.fixForgeOpenGuiHandlerWindowId).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_KEYBIND_CONFLICTS(new MixinBuilder("Trigger all conflicting keybinds").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"minecraft.MixinKeyBinding", "minecraft.MixinMinecraft_UpdateKeys"}).setApplyIf(() -> FixesConfig.triggerAllConflictingKeybindings).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    REMOVE_SPAWN_MINECART_SOUND(new MixinBuilder("Remove sound when spawning a minecart").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"minecraft.MixinWorldClient"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.removeSpawningMinecartSound)),
    MACOS_KEYS_TEXTFIELD_SHORTCUTS(new MixinBuilder("Macos use CMD to copy/select/delete text").addMixinClasses(new String[]{"minecraft.MixinGuiTextField"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> System.getProperty("os.name").toLowerCase().contains("mac") && TweaksConfig.enableMacosCmdShortcuts).setPhase(Phase.EARLY).setSide(Side.CLIENT)),
    FIX_FONT_RENDERER_LINEWRAP_RECURSION(new MixinBuilder("Replace recursion with iteration in FontRenderer line wrapping code").addMixinClasses(new String[]{"minecraft.MixinFontRenderer"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> FixesConfig.fixFontRendererLinewrapRecursion).setPhase(Phase.EARLY).setSide(Side.CLIENT)),
    BED_MESSAGE_ABOVE_HOTBAR(new MixinBuilder("Bed Message Above Hotbar").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinBlockBed"}).setSide(Side.BOTH).setApplyIf(() -> TweaksConfig.bedMessageAboveHotbar).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    BED_ALWAYS_SETS_SPAWN(new MixinBuilder("Clicking a bed in a valid dim will always set your spawn immediately").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.bedAlwaysSetsSpawn).addMixinClasses(new String[]{"minecraft.MixinBlockBed_AlwaysSetsSpawn"})),
    FIX_PLAYER_SKIN_FETCHING(new MixinBuilder("Fix player skin fetching").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinAbstractClientPlayer", "minecraft.MixinThreadDownloadImageData"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixPlayerSkinFetching).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    VALIDATE_PACKET_ENCODING_BEFORE_SENDING(new MixinBuilder("Validate packet encoding before sending").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.packets.MixinDataWatcher", "minecraft.packets.MixinS3FPacketCustomPayload_Validation"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.validatePacketEncodingBeforeSending).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_FLUID_CONTAINER_REGISTRY_KEY(new MixinBuilder("Fix Forge fluid container registry key").setPhase(Phase.EARLY).addMixinClasses(new String[]{"forge.FluidContainerRegistryAccessor", "forge.MixinFluidRegistry"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixFluidContainerRegistryKey).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    CHANGE_MAX_NETWORK_NBT_SIZE_LIMIT(new MixinBuilder("Modify the maximum NBT size limit as received from network packets").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinPacketBuffer"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.changeMaxNetworkNbtSizeLimit).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    INCREASE_PACKET_SIZE_LIMIT(new MixinBuilder("Increase the packet size limit from 2MiB to a theoretical maximum of 4GiB").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinMessageSerializer2", "minecraft.MixinMessageDeserializer2", "minecraft.packets.MixinS3FPacketCustomPayload_LengthLimit"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.increasePacketSizeLimit).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_XRAY_BLOCK_WITHOUT_COLLISION_AABB(new MixinBuilder("Fix Xray through block without collision boundingBox").addMixinClasses(new String[]{"minecraft.MixinBlock_FixXray", "minecraft.MixinWorld_FixXray"}).setApplyIf(() -> FixesConfig.fixPerspectiveCamera).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    DISABLE_CREATIVE_TAB_ALL_SEARCH(new MixinBuilder("Disable the creative tab with search bar").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiContainerCreative"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.removeCreativeSearchTab).addTargetedMod((ITargetedMod)TargetedMod.NOTENOUGHITEMS)),
    FIX_CHAT_COLOR_WRAPPING(new MixinBuilder("Fix wrapped chat lines missing colors").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiNewChat_FixColorWrapping"}).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixChatWrappedColors).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    COMPACT_CHAT(new MixinBuilder("Compact chat").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinGuiNewChat_CompactChat"}).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.compactChat).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    NETTY_PATCH(new MixinBuilder("Fix NPE in Netty's Bootstrap class").addMixinClasses(new String[]{"netty.MixinBootstrap"}).setPhase(Phase.EARLY).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixNettyNPE).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    MODERN_PICK_BLOCK(new MixinBuilder("Allows pick block to pull items from your inventory").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.CLIENT).setPhase(Phase.EARLY).addMixinClasses(new String[]{"forge.MixinForgeHooks_ModernPickBlock"}).setApplyIf(() -> TweaksConfig.modernPickBlock)),
    TESSELATOR_PRESERVE_QUAD_ORDER(new MixinBuilder("Preserve the rendering order of layered quads on terrain pass 1").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.CLIENT).setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinTessellator"}).setApplyIf(() -> FixesConfig.fixPreserveQuadOrder)),
    FAST_BLOCK_PLACING(new MixinBuilder("Allows blocks to be placed faster").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.CLIENT).setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinMinecraft_FastBlockPlacing"}).setApplyIf(() -> true)),
    FIX_NEGATIVE_KELVIN(new MixinBuilder("Fix the local temperature can go below absolute zero").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinBiomeGenBase"}).setApplyIf(() -> FixesConfig.fixNegativeKelvin)),
    SPIGOT_EXTENDED_CHUNKS(new MixinBuilder("Spigot-style extended chunk format to remove the 2MB chunk size limit").addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addExcludedMod((ITargetedMod)TargetedMod.BUKKIT).setSide(Side.BOTH).setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinRegionFile"}).setApplyIf(() -> FixesConfig.remove2MBChunkLimit)),
    AUTOSAVE_INTERVAL(new MixinBuilder("Sets the auto save interval in ticks").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.server.MixinMinecraftServer_AutoSaveInterval"}).setApplyIf(() -> TweaksConfig.autoSaveInterval != 900)),
    LIGHTER_WATER(new MixinBuilder("Decreases water opacity from 3 to 1, like in modern").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinBlock_LighterWater"}).setApplyIf(() -> TweaksConfig.useLighterWater)),
    EARLY_CHUNK_TILE_COORDINATE_CHECK(new MixinBuilder("Checks saved TileEntity coordinates earlier to provide a more descriptive error message").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinChunk"}).setApplyIf(() -> FixesConfig.earlyChunkTileCoordinateCheck)),
    FIX_DUPLICATE_SOUNDS(new MixinBuilder("Fix duplicate sounds being played when you close a gui while one is playing").setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinMinecraft_FixDuplicateSounds"}).setApplyIf(() -> FixesConfig.fixDuplicateSounds)),
    ADD_MOD_ITEM_STATS(new MixinBuilder("Add stats for modded items").addMixinClasses(new String[]{"fml.MixinGameRegistry", "minecraft.MixinStats"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.addModItemStats).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    ADD_MOD_ENTITY_STATS(new MixinBuilder("Add stats for modded entities").addMixinClasses(new String[]{"minecraft.MixinStatList"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.addModEntityStats).setPhase(Phase.EARLY).setSide(Side.BOTH)),
    ADD_MOD_ENTITY_STATS_CLIENT(new MixinBuilder("Add stats for modded entities (client side)").addMixinClasses(new String[]{"minecraft.MixinStatsMobsList", "minecraft.MixinStatsBlock", "minecraft.MixinStatsItem"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> TweaksConfig.addModEntityStats).setPhase(Phase.EARLY).setSide(Side.CLIENT)),
    FIX_SLASH_COMMAND(new MixinBuilder("Fix forge command handler not checking for a / and also not running commands with any case").setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinClientCommandHandler_CommandFix"}).setApplyIf(() -> FixesConfig.fixSlashCommands)),
    FIX_CASE_COMMAND(new MixinBuilder("Fix the command handler not allowing you to run commands typed in any case").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinCommandHandler_CommandFix"}).setApplyIf(() -> FixesConfig.fixCaseCommands)),
    FIX_GAMESETTINGS_OUTOFBOUNDS(new MixinBuilder("Fix array out of bound error in GameSettings menu").setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinGameSettings_FixArrayOutOfBounds"}).setApplyIf(() -> FixesConfig.fixGameSettingsArrayOutOfBounds).addExcludedMod((ITargetedMod)TargetedMod.LWJGL3IFY)),
    LIMIT_RECURSIVE_BLOCK_UPDATE_DEPTH(new MixinBuilder("Limit the number of recursive cascading block updates during world generation to prevent stack overflow crashes").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinWorldServer_LimitUpdateRecursion"}).setApplyIf(() -> FixesConfig.limitRecursiveBlockUpdateDepth >= 0)),
    ADD_MOD_CONFIG_SEARCHBAR(new MixinBuilder("Adds a search bar to the mod config GUI").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"fml.MixinGuiConfig"}).setApplyIf(() -> TweaksConfig.addModConfigSearchBar).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_BUTTON_POS_GUIOPENLINK(new MixinBuilder("Fix the buttons not being centered in the GuiConfirmOpenLink").setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinGuiConfirmOpenLink"}).setApplyIf(() -> FixesConfig.fixButtonsGuiConfirmOpenLink)),
    FIX_CHAT_OPEN_LINK(new MixinBuilder("Fix the vanilla method to open chat links not working for every OS").setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.MixinGuiChat_OpenLinks"}).setApplyIf(() -> FixesConfig.fixChatOpenLink)),
    FIX_NAMETAG_BRIGHTNESS(new MixinBuilder("Fix nametag brightness").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"minecraft.MixinRendererLivingEntity_NametagBrightness"}).setApplyIf(() -> FixesConfig.fixNametagBrightness).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_HIT_EFFECT_BRIGHTNESS(new MixinBuilder("Fix hit effect brightness").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"minecraft.MixinRendererLivingEntity_HitEffectBrightness"}).setApplyIf(() -> FixesConfig.fixHitEffectBrightness).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_BUKKIT_PLAYER_CONTAINER(new MixinBuilder("Fix Bukkit BetterQuesting crash").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.BUKKIT).addMixinClasses(new String[]{"minecraft.MixinContainerPlayer"}).setApplyIf(() -> FixesConfig.fixBukkitBetterQuestingCrash)),
    MEMORY_FIXES_CLIENT(new MixinBuilder("Memory fixes").setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"memory.MixinFMLClientHandler"}).setApplyIf(() -> FixesConfig.enableMemoryFixes)),
    FAST_RANDOM(new MixinBuilder("Replaces uses of stdlib Random with a faster one").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.fastload.rand.MixinChunkProviderGenerate", "minecraft.fastload.rand.MixinMapGenBase", "minecraft.fastload.rand.MixinMapGenCaves"}).setApplyIf(() -> SpeedupsConfig.fastRandom)),
    FAST_INT_CACHE(new MixinBuilder("Rewrite internal caching methods to be safer and faster").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.fastload.intcache.MixinCollectOneCache", "minecraft.fastload.intcache.MixinCollectTwoCaches", "minecraft.fastload.intcache.MixinGenLayerEdge", "minecraft.fastload.intcache.MixinIntCache", "minecraft.fastload.intcache.MixinWorldChunkManager"}).setApplyIf(() -> SpeedupsConfig.fastIntCache)),
    NUKE_LONG_BOXING(new MixinBuilder("Remove Long boxing in MapGenStructure").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.fastload.MixinMapGenStructure"}).setApplyIf(() -> SpeedupsConfig.unboxMapGen)),
    EMBED_BLOCKIDS(new MixinBuilder("Embed block IDs directly in the block objects, to speed up lookups").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.fastload.flatid.MixinBlock", "minecraft.fastload.flatid.MixinFMLControlledNamespacedRegistry"}).setApplyIf(() -> SpeedupsConfig.embedID)),
    FAST_CHUNK_LOADING(new MixinBuilder("Invasively accelerates chunk handling").setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addMixinClasses(new String[]{"minecraft.fastload.MixinEntityPlayerMP", "minecraft.fastload.MixinChunkProviderServer"}).setApplyIf(() -> SpeedupsConfig.fastChunkHandling)),
    MEMORY_FIXES_IC2(new MixinBuilder("Removes allocation spam from the Direction.applyTo method").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinDirection_Memory"}).setApplyIf(() -> FixesConfig.enableMemoryFixes).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    FIX_PLAYER_BLOCK_PLACEMENT_DISTANCE_CHECK(new MixinBuilder("Fix wrong block placement distance check").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinNetHandlePlayServer_FixWrongBlockPlacementCheck"}).setApplyIf(() -> FixesConfig.fixWrongBlockPlacementDistanceCheck).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    PREVENT_LAVA_CHUNK_LOADING(new MixinBuilder("Prevent lava blocks from loading chunks").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinBlockStaticLiquid"}).setApplyIf(() -> SpeedupsConfig.lavaChunkLoading).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_GLASS_BOTTLE_NON_WATER_BLOCKS(new MixinBuilder("Fix Glass Bottles filling with Water from some other Fluid blocks").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"minecraft.MixinItemGlassBottle"}).setApplyIf(() -> FixesConfig.fixGlassBottleWaterFilling).addTargetedMod((ITargetedMod)TargetedMod.VANILLA)),
    FIX_IOOBE_RENDER_DISTANCE(new MixinBuilder("Fix out of bounds render distance when Optifine/Angelica is uninstalled").setPhase(Phase.EARLY).setSide(Side.CLIENT).addExcludedMod((ITargetedMod)com.gtnewhorizon.gtnhlib.mixin.TargetedMod.OPTIFINE).addExcludedMod((ITargetedMod)TargetedMod.ANGELICA).addExcludedMod((ITargetedMod)TargetedMod.FALSETWEAKS).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setApplyIf(() -> true).addMixinClasses(new String[]{"minecraft.MixinGameSettings_ReduceRenderDistance"})),
    IC2_UNPROTECTED_GET_BLOCK_FIX(new MixinBuilder("IC2 Kinetic Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinIc2WaterKinetic"}).setApplyIf(() -> FixesConfig.fixIc2UnprotectedGetBlock).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_DIRECT_INV_ACCESS(new MixinBuilder("IC2 Direct Inventory Access Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinItemCropSeed", "ic2.MixinTileEntityCrop"}).setApplyIf(() -> FixesConfig.fixIc2DirectInventoryAccess).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_NIGHT_VISION_NANO(new MixinBuilder("IC2 Nightvision Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinIc2NanoSuitNightVision", "ic2.MixinIc2QuantumSuitNightVision", "ic2.MixinIc2NightVisionGoggles"}).setApplyIf(() -> FixesConfig.fixIc2Nightvision).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_REACTOR_DUPE(new MixinBuilder("IC2 Reactor Dupe Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinTileEntityReactorChamberElectricNoDupe"}).setApplyIf(() -> FixesConfig.fixIc2ReactorDupe).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_REACTOR_INVENTORY_SPEEDUP(new MixinBuilder("IC2 Reactor Inventory Speedup Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinTileEntityReactorChamberElectricInvSpeedup"}).setApplyIf(() -> FixesConfig.optimizeIc2ReactorInventoryAccess).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    HIDE_IC2_REACTOR_COOLANT_SLOTS(new MixinBuilder("IC2 Reactory Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinTileEntityNuclearReactorElectric"}).setApplyIf(() -> TweaksConfig.hideIc2ReactorSlots).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_FLUID_CONTAINER_TOOLTIP(new MixinBuilder("IC2 Fluid Container Tooltip Fix").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinItemIC2FluidContainer"}).setApplyIf(() -> TweaksConfig.displayIc2FluidLocalizedName).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_HOVER_MODE_FIX(new MixinBuilder("IC2 Hover Mode Fix").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinIc2QuantumSuitHoverMode"}).setApplyIf(() -> FixesConfig.fixIc2HoverMode).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_ARMOR_LAG_FIX(new MixinBuilder("IC2 Armor Lag Fix").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinElectricItemManager", "ic2.MixinIC2ArmorHazmat", "ic2.MixinIC2ArmorJetpack", "ic2.MixinIC2ArmorNanoSuit", "ic2.MixinIC2ArmorNightvisionGoggles", "ic2.MixinIC2ArmorQuantumSuit", "ic2.MixinIC2ArmorSolarHelmet", "ic2.MixinIC2ArmorStaticBoots"}).setApplyIf(() -> FixesConfig.fixIc2ArmorLag).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_RESOURCE_PACK_TRANSLATION_FIX(new MixinBuilder("IC2 Resource Pack Translation Fix").setPhase(Phase.EARLY).setSide(Side.CLIENT).addMixinClasses(new String[]{"fml.MixinLanguageRegistry", "fml.MixinFMLClientHandler", "ic2.MixinLocalization"}).setApplyIf(() -> FixesConfig.fixIc2ResourcePackTranslation).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_CROP_TRAMPLING_FIX(new MixinBuilder("IC2 Crop Trampling Fix").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.MixinIC2TileEntityCrop"}).setApplyIf(() -> FixesConfig.fixIc2CropTrampling).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    IC2_SYNC_REACTORS(new MixinBuilder("Synchronize IC2 reactors for more consistent operation").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"ic2.sync.MixinTEReactorChamber", "ic2.sync.MixinTEReactor"}).setApplyIf(() -> TweaksConfig.synchronizeIC2Reactors).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    BIBLIOCRAFT_UPDATE_CHECK(new MixinBuilder("Yeet Bibliocraft Update Check").setPhase(Phase.LATE).setSide(Side.CLIENT).addMixinClasses(new String[]{"bibliocraft.MixinVersionCheck"}).setApplyIf(() -> FixesConfig.removeUpdateChecks).addTargetedMod((ITargetedMod)TargetedMod.BIBLIOCRAFT)),
    COFH_CORE_UPDATE_CHECK(new MixinBuilder("Yeet COFH Core Update Check").setPhase(Phase.EARLY).setSide(Side.BOTH).addMixinClasses(new String[]{"cofhcore.MixinCoFHCoreUpdateCheck"}).setApplyIf(() -> FixesConfig.removeUpdateChecks).addTargetedMod((ITargetedMod)TargetedMod.COFH_CORE)),
    DAMAGE_INDICATORS_UPDATE_CHECK(new MixinBuilder("Yeet Damage Indicators Update Check").setPhase(Phase.LATE).setSide(Side.CLIENT).addMixinClasses(new String[]{"damageindicators.MixinDIClientProxy"}).setApplyIf(() -> FixesConfig.removeUpdateChecks).addTargetedMod((ITargetedMod)TargetedMod.DAMAGE_INDICATORS)),
    WAKE_ANCHORS_ON_LOGIN_PASSIVE(new MixinBuilder("Wake passive anchors on login").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"railcraft.MixinTileAnchorPassive"}).setApplyIf(() -> TweaksConfig.installAnchorAlarm).addTargetedMod((ITargetedMod)TargetedMod.RAILCRAFT)),
    WAKE_ANCHORS_ON_LOGIN_PERSONAL(new MixinBuilder("Wake person anchors on login").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"railcraft.MixinTileAnchorPersonal"}).setApplyIf(() -> TweaksConfig.installAnchorAlarm).addTargetedMod((ITargetedMod)TargetedMod.RAILCRAFT)),
    HUNGER_OVERHAUL_LOW_STAT_EFFECT(new MixinBuilder("Patch unintended low stat effects").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"hungeroverhaul.MixinHungerOverhaulLowStatEffect"}).setApplyIf(() -> FixesConfig.fixHungerOverhaul).addTargetedMod((ITargetedMod)TargetedMod.HUNGER_OVERHAUL)),
    HUNGER_OVERHAUL_REGEN(new MixinBuilder("Patch Regen").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"hungeroverhaul.MixinHungerOverhaulHealthRegen"}).setApplyIf(() -> FixesConfig.fixHungerOverhaul).addTargetedMod((ITargetedMod)TargetedMod.HUNGER_OVERHAUL)),
    HUNGER_OVERHAUL_0_HUNGER(new MixinBuilder("Fix some items restore 0 hunger").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"hungeroverhaul.MixinHungerOverhaulModuleHarvestCraft"}).setApplyIf(() -> FixesConfig.fixHungerOverhaulRestore0Hunger).addTargetedMod((ITargetedMod)TargetedMod.HUNGER_OVERHAUL).addTargetedMod((ITargetedMod)TargetedMod.HARVESTCRAFT)),
    THREADED_THAUMCRAFT_MAZE_SAVING(new MixinBuilder("Threaded Thaumcraft Maze Saving").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"thaumcraft.MixinMazeHandler_threadedIO"}).setApplyIf(() -> TweaksConfig.threadedWorldDataSaving).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    ADD_CV_SUPPORT_TO_WAND_PEDESTAL(new MixinBuilder("CV Support for Wand Pedestal").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"thaumcraft.MixinTileWandPedestal"}).setApplyIf(() -> TweaksConfig.addCVSupportToWandPedestal).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_ASPECT_SORTING(new MixinBuilder("Fix Thaumcraft Aspects not being sorted by name").addMixinClasses(new String[]{"thaumcraft.MixinGuiResearchRecipe", "thaumcraft.MixinGuiResearchTable", "thaumcraft.MixinGuiThaumatorium", "thaumcraft.MixinItem_SortAspectsByName"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixThaumcraftAspectSorting).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_GOLEM_MARKER_LOADING(new MixinBuilder("Fix golem marker loading failure when dimensionId larger than MAX_BYTE").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"thaumcraft.MixinEntityGolemBase", "thaumcraft.MixinItemGolemBell"}).setApplyIf(() -> FixesConfig.fixThaumcraftGolemMarkerLoading).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_WORLD_COORDINATE_HASHING_METHOD(new MixinBuilder("Implement a proper hashing method for WorldCoordinates").addMixinClasses(new String[]{"thaumcraft.MixinWorldCoordinates"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixThaumcraftWorldCoordinatesHashingMethod).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_MAGICAL_LEAVES_LAG(new MixinBuilder("Fix Thaumcraft leaves frequent ticking").addMixinClasses(new String[]{"thaumcraft.MixinBlockMagicalLeaves", "thaumcraft.MixinBlockMagicalLog"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixThaumcraftLeavesLag).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_THAUMCRAFT_VIS_DUPLICATION(new MixinBuilder("Fix Thaumcraft Vis Duplication").addMixinClasses(new String[]{"thaumcraft.MixinTileWandPedestal_VisDuplication"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixWandPedestalVisDuplication).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_NULL_HANDLING_ITEMWISPESSENCE_CLIENT(new MixinBuilder("Fix handling of null stacks in ItemWispEssence").addMixinClasses(new String[]{"thaumcraft.MixinItemWispEssence_Client"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixNullHandlingItemWispEssence).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_NULL_HANDLING_ITEMWISPESSENCE_BOTH(new MixinBuilder("Fix handling of null stacks in ItemWispEssence").addMixinClasses(new String[]{"thaumcraft.MixinItemWispEssence_Both"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixNullHandlingItemWispEssence).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    FIX_QUICKSAND_XRAY(new MixinBuilder("Fix Xray through block without collision boundingBox").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"biomesoplenty.MixinBlockMud_FixXray"}).setApplyIf(() -> FixesConfig.fixPerspectiveCamera).addTargetedMod((ITargetedMod)TargetedMod.BOP)),
    DEDUPLICATE_FORESTRY_COMPAT_IN_BOP(new MixinBuilder("BOP Forestry Compat").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"biomesoplenty.MixinForestryIntegration"}).setApplyIf(() -> FixesConfig.deduplicateForestryCompatInBOP).addTargetedMod((ITargetedMod)TargetedMod.BOP)),
    SPEEDUP_BOP_BIOME_FOG(new MixinBuilder("BOP Biome Fog").addMixinClasses(new String[]{"biomesoplenty.MixinFogHandler"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> SpeedupsConfig.speedupBOPFogHandling).addTargetedMod((ITargetedMod)TargetedMod.BOP)),
    SPEEDUP_BOP_BIOME_FOG_ACCESSOR(new MixinBuilder("BOP Biome Fog Accessor").addMixinClasses(new String[]{"biomesoplenty.AccessorFogHandler"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> SpeedupsConfig.speedupBOPFogHandling).addTargetedMod((ITargetedMod)TargetedMod.BOP)),
    BIG_FIR_TREES(new MixinBuilder("BOP Fir Trees").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"biomesoplenty.MixinBlockBOPSapling"}).setApplyIf(() -> TweaksConfig.makeBigFirsPlantable).addTargetedMod((ITargetedMod)TargetedMod.BOP)),
    JAVA12_BOP(new MixinBuilder("BOP Java12-safe reflection").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"biomesoplenty.MixinBOPBiomes"}).addMixinClasses(new String[]{"biomesoplenty.MixinBOPReflectionHelper"}).setApplyIf(() -> FixesConfig.java12BopCompat).addTargetedMod((ITargetedMod)TargetedMod.BOP)),
    DISABLE_QUICKSAND_GENERATION(new MixinBuilder("Disable BOP quicksand").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"biomesoplenty.MixinDisableQuicksandGeneration"}).setApplyIf(() -> TweaksConfig.removeBOPQuicksandGeneration).addTargetedMod((ITargetedMod)TargetedMod.BOP)),
    COFH_REMOVE_TE_CACHE(new MixinBuilder("Remove CoFH tile entity cache").addMixinClasses(new String[]{"minecraft.MixinWorld_CoFH_TE_Cache"}).setSide(Side.BOTH).setApplyIf(() -> ASMConfig.cofhWorldTransformer).addTargetedMod((ITargetedMod)TargetedMod.COFH_CORE).setPhase(Phase.EARLY)),
    MFR_FIX_COFH_VALIDATE(new MixinBuilder("Remove CoFH TE cache usage from MFR").addMixinClasses(new String[]{"minefactoryreloaded.MixinTileEntityBase", "minefactoryreloaded.MixinTileEntityRedNetCable"}).addTargetedMod((ITargetedMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> ASMConfig.cofhWorldTransformer).setPhase(Phase.LATE).setSide(Side.BOTH)),
    TE_FIX_COFH_VALIDATE(new MixinBuilder("Remove CoFH TE cache usage from TE").addMixinClasses(new String[]{"thermalexpansion.MixinTileInventoryTileLightFalse"}).addTargetedMod((ITargetedMod)TargetedMod.THERMALEXPANSION).setApplyIf(() -> ASMConfig.cofhWorldTransformer).setPhase(Phase.LATE).setSide(Side.BOTH)),
    FIX_ORE_DICT_NPE(new MixinBuilder("Fix NPE in OreDictionaryArbiter").addMixinClasses(new String[]{"cofhcore.MixinOreDictionaryArbiter"}).setPhase(Phase.EARLY).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.COFH_CORE).setApplyIf(() -> FixesConfig.fixCofhOreDictNPE)),
    FIX_ORE_DICT_CME(new MixinBuilder("Fix race condition in CoFH oredict").addMixinClasses(new String[]{"cofhcore.MixinFMLEventHandler"}).setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.COFH_CORE).setApplyIf(() -> FixesConfig.fixCofhOreDictCME)),
    COFH_IMPROVE_BREAKBLOCK(new MixinBuilder("Improve CoFH breakBlock method to support mods").addMixinClasses(new String[]{"cofhcore.MixinBlockHelper"}).setPhase(Phase.EARLY).setSide(Side.CLIENT).addTargetedMod((ITargetedMod)TargetedMod.COFH_CORE).setApplyIf(() -> TweaksConfig.improveCofhBreakBlock)),
    DISARM_SACRED_TREE(new MixinBuilder("Prevents Sacred Rubber Tree Generation").addMixinClasses(new String[]{"minefactoryreloaded.MixinBlockRubberSapling"}).setPhase(Phase.LATE).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> FixesConfig.disableMassiveSacredTreeGeneration)),
    MFR_IMPROVE_BLOCKSMASHER(new MixinBuilder("Improve MFR block smasher").addMixinClasses(new String[]{"minefactoryreloaded.MixinTileEntityBlockSmasher"}).setPhase(Phase.LATE).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> TweaksConfig.improveMfrBlockSmasher)),
    MFR_IMPROVE_BLOCKBREAKER(new MixinBuilder("Improve MFR block breaker").addMixinClasses(new String[]{"minefactoryreloaded.MixinTileEntityBlockBreaker"}).setPhase(Phase.LATE).setSide(Side.BOTH).addTargetedMod((ITargetedMod)TargetedMod.MINEFACTORY_RELOADED).setApplyIf(() -> TweaksConfig.improveMfrBlockBreaker)),
    JAVA12_IMMERSIVE_ENGINERRING(new MixinBuilder("Immersive Engineering Java-12 safe potion array resizing").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"immersiveengineering.MixinIEPotions"}).setApplyIf(() -> FixesConfig.java12ImmersiveEngineeringCompat).addTargetedMod((ITargetedMod)TargetedMod.IMMERSIVE_ENGINENEERING)),
    JAVA12_MINE_CHEM(new MixinBuilder("Minechem Java-12 safe potion array resizing").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"minechem.MixinPotionInjector"}).setApplyIf(() -> FixesConfig.java12MineChemCompat).addTargetedMod((ITargetedMod)TargetedMod.MINECHEM)),
    MPS_PREVENT_RF_ENERGY_SYPHON(new MixinBuilder("Prevent MPS from charging and draining RF from Inventory").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"mps.MixinElectricAdapterRF"}).setApplyIf(() -> TweaksConfig.preventMPSEnergyTransferRF).addTargetedMod((ITargetedMod)TargetedMod.MODULARPOWERSUITS)),
    MPS_PREVENT_EU_ENERGY_SYPHON(new MixinBuilder("Prevent MPS from charging and draining EU from Inventory").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"mps.MixinElectricAdapterEU"}).setApplyIf(() -> TweaksConfig.preventMPSEnergyTransferEU).addTargetedMod((ITargetedMod)TargetedMod.MODULARPOWERSUITS)),
    MPS_PREVENT_ME_ENERGY_SYPHON(new MixinBuilder("Prevent MPS from charging and draining ME from Inventory").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"mps.MixinElectricAdapterME"}).setApplyIf(() -> TweaksConfig.preventMPSEnergyTransferME).addTargetedMod((ITargetedMod)TargetedMod.MODULARPOWERSUITS)),
    FIX_HUD_LIGHTING_GLITCH(new MixinBuilder("HUD Lighting glitch").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"mrtjpcore.MixinFXEngine"}).setApplyIf(() -> TweaksConfig.fixHudLightingGlitch).addTargetedMod((ITargetedMod)TargetedMod.MRTJPCORE)),
    FIX_POPPING_OFF(new MixinBuilder("Fix Popping Off").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"mrtjpcore.MixinPlacementLib"}).setApplyIf(() -> TweaksConfig.fixComponentsPoppingOff).addTargetedMod((ITargetedMod)TargetedMod.MRTJPCORE)),
    IMPLEMENTS_CONTAINER_FOR_THIRSTY_TANK(new MixinBuilder("Thirsty Tank Container").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"automagy.MixinItemBlockThirstyTank"}).setApplyIf(() -> TweaksConfig.thirstyTankContainer).addTargetedMod((ITargetedMod)TargetedMod.AUTOMAGY)),
    FIX_BETTERHUD_ARMOR_BAR(new MixinBuilder("Fix better HUD armor display breaking with skulls").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"betterhud.MixinSkullDurabilityDisplay"}).setApplyIf(() -> FixesConfig.fixBetterHUDArmorDisplay).addTargetedMod((ITargetedMod)TargetedMod.BETTERHUD)),
    FIX_BETTERHUD_HEARTS_FREEZE(new MixinBuilder("Fix better HUD freezing the game when trying to render high amounts of hp").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"betterhud.MixinHealthRender"}).setApplyIf(() -> FixesConfig.fixBetterHUDHPDisplay).addTargetedMod((ITargetedMod)TargetedMod.BETTERHUD)),
    FIX_FURNACE_ITERATION(new MixinBuilder("Speedup Furnaces").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"projecte.MixinObjHandler"}).setApplyIf(() -> SpeedupsConfig.speedupVanillaFurnace).addTargetedMod((ITargetedMod)TargetedMod.PROJECTE)),
    FIX_LOTR_FURNACE_ERROR(new MixinBuilder("Patches lotr to work with the vanilla furnace speedup").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"lotr.MixinLOTRRecipes"}).setApplyIf(() -> SpeedupsConfig.speedupVanillaFurnace).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addTargetedMod((ITargetedMod)TargetedMod.GTNHLIB).addTargetedMod((ITargetedMod)TargetedMod.LOTR)),
    FIX_LOTR_JAVA12(new MixinBuilder("Fix lotr java 12+ compat").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"lotr.MixinLOTRLogReflection", "lotr.MixinRedirectHuornAI", "lotr.MixinRemoveUnlockFinalField"}).setApplyIf(() -> FixesConfig.java12LotrCompat).addTargetedMod((ITargetedMod)TargetedMod.LOTR)),
    FIX_JOURNEYMAP_KEYBINDS(new MixinBuilder("Fix Journeymap Keybinds").setPhase(Phase.LATE).setSide(Side.CLIENT).addMixinClasses(new String[]{"journeymap.MixinConstants"}).setApplyIf(() -> FixesConfig.fixJourneymapKeybinds).addTargetedMod((ITargetedMod)TargetedMod.JOURNEYMAP)),
    FIX_JOURNEYMAP_ILLEGAL_FILE_PATH_CHARACTER(new MixinBuilder("Fix Journeymap Illegal File Path Character").setPhase(Phase.LATE).setSide(Side.CLIENT).addMixinClasses(new String[]{"journeymap.MixinWorldData"}).setApplyIf(() -> FixesConfig.fixJourneymapFilePath).addTargetedMod((ITargetedMod)TargetedMod.JOURNEYMAP)),
    FIX_JOURNEYMAP_JUMPY_SCROLLING(new MixinBuilder("Fix Journeymap jumpy scrolling in the waypoint manager").setPhase(Phase.LATE).setSide(Side.CLIENT).addMixinClasses(new String[]{"journeymap.MixinWaypointManager"}).setApplyIf(() -> FixesConfig.fixJourneymapJumpyScrolling).addTargetedMod((ITargetedMod)TargetedMod.JOURNEYMAP)),
    FIX_XAEROS_WORLDMAP_SCROLL(new MixinBuilder("Fix Xaero's World Map map screen scrolling").addMixinClasses(new String[]{"xaeroworldmap.MixinGuiMap"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixXaerosWorldMapScroll).addTargetedMod((ITargetedMod)TargetedMod.XAEROWORLDMAP).addTargetedMod((ITargetedMod)TargetedMod.LWJGL3IFY)),
    FIX_XAEROS_MINIMAP_ENTITYDOT(new MixinBuilder("Fix Xaero's Minimap player entity dot rendering when arrow is chosen").addMixinClasses(new String[]{"xaerominimap.MixinMinimapRenderer"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixXaerosMinimapEntityDot).addTargetedMod((ITargetedMod)TargetedMod.XAEROMINIMAP)),
    FIX_IGNIS_FRUIT_AABB(new MixinBuilder("Ignis Fruit").setPhase(Phase.LATE).setSide(Side.BOTH).addMixinClasses(new String[]{"harvestthenether.MixinBlockPamFruit"}).setApplyIf(() -> FixesConfig.fixIgnisFruitAABB).addTargetedMod((ITargetedMod)TargetedMod.HARVESTTHENETHER)),
    FIX_NETHER_LEAVES_FACE_RENDERING(new MixinBuilder("Nether Leaves").addMixinClasses(new String[]{"harvestthenether.MixinBlockNetherLeaves"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixIgnisFruitAABB).addTargetedMod((ITargetedMod)TargetedMod.HARVESTTHENETHER)),
    FIX_BAUBLES_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder("Baubles Inventory with Potions").addMixinClasses(new String[]{"baubles.MixinGuiEvents"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addTargetedMod((ITargetedMod)TargetedMod.BAUBLES)),
    FIX_GALACTICRAFT_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder("Galacticraft Inventory with Potions").addMixinClasses(new String[]{"galacticraftcore.MixinGuiExtendedInventory"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addTargetedMod((ITargetedMod)TargetedMod.GALACTICRAFT_CORE)),
    FIX_TRAVELLERSGEAR_INVENTORY_OFFSET_WITH_POTIONS(new MixinBuilder("Travelers Gear with Potions").addMixinClasses(new String[]{"travellersgear.MixinClientProxy"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addTargetedMod((ITargetedMod)TargetedMod.TRAVELLERSGEAR)),
    FIX_TINKER_POTION_EFFECT_OFFSET(new MixinBuilder("Prevents the inventory from shifting when the player has active potion effects").setSide(Side.CLIENT).setPhase(Phase.LATE).addTargetedMod((ITargetedMod)TargetedMod.TINKERSCONSTRUCT).setApplyIf(() -> TweaksConfig.fixPotionRenderOffset).addMixinClasses(new String[]{"tconstruct.MixinTabRegistry"})),
    Fix_EXTRATIC_TECONFLICT(new MixinBuilder("Disable ExtraTic's Integration with Metallurgy 3 Precious Materials Module: [Brass, Silver, Electrum & Platinum]").addMixinClasses(new String[]{"extratic.MixinPartsHandler", "extratic.MixinRecipeHandler"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraTiCTEConflict).addTargetedMod((ITargetedMod)TargetedMod.EXTRATIC)),
    FIX_EXTRA_UTILITIES_UNENCHANTING(new MixinBuilder("Fix Exu Unenchanting").addMixinClasses(new String[]{"extrautilities.MixinRecipeUnEnchanting"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesUnEnchanting).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    DISABLE_AID_SPAWN_XU_SPIKES(new MixinBuilder("Fixes the vanilla zombie aid spawn triggering when killed by Extra Utilities Spikes").addMixinClasses(new String[]{"extrautilities.MixinBlockSpike"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> TweaksConfig.disableAidSpawnByXUSpikes).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_EXTRA_UTILITIES_TRANSPARENT_ITEM_RENDER(new MixinBuilder("Fix extra utilities item rendering for transparent items").addMixinClasses(new String[]{"extrautilities.MixinTransparentItemRender"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixExtraUtilitiesItemRendering).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_DRUM_EATING_CELLS(new MixinBuilder("Fix extra utilities drums eating ic2 cells and forestry capsules").addMixinClasses(new String[]{"extrautilities.MixinBlockDrum"}).setSide(Side.BOTH).setPhase(Phase.LATE).setApplyIf(() -> FixesConfig.fixExtraUtilitiesDrumEatingCells).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_GREENSCREEN_MICROBLOCKS(new MixinBuilder("Fix extra utilities Lapis Caelestis microblocks").addMixinClasses(new String[]{"extrautilities.MixinFullBrightMicroMaterial"}).setSide(Side.CLIENT).setPhase(Phase.LATE).setApplyIf(() -> FixesConfig.fixExtraUtilitiesGreenscreenMicroblocks).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_LAST_MILLENIUM_RAIN(new MixinBuilder("Remove rain from the Last Millenium (Extra Utilities)").addMixinClasses(new String[]{"extrautilities.MixinChunkProviderEndOfTime"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesLastMilleniumRain).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_LAST_MILLENIUM_CREATURES(new MixinBuilder("Remove creatures from the Last Millenium (Extra Utilities)").addMixinClasses(new String[]{"extrautilities.MixinWorldProviderEndOfTime"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesLastMilleniumCreatures).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_FLUID_RETRIEVAL_NODE(new MixinBuilder("Prevent fluid retrieval node from voiding (Extra Utilities)").addMixinClasses(new String[]{"extrautilities.MixinFluidBufferRetrieval"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesFluidRetrievalNode).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_FILING_CABINET_DUPE(new MixinBuilder("Caps hotkey'd stacks to their maximum stack size in filing cabinets").addMixinClasses(new String[]{"extrautilities.MixinContainerFilingCabinet"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesFilingCabinetDupe).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_FILTER_DUPE(new MixinBuilder("Prevent hotkeying other items onto item filters while they are open").addMixinClasses(new String[]{"extrautilities.MixinContainerFilter"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesFilterDupe).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    CONFIGURABLE_ENDERQUARRY_ENERGY(new MixinBuilder("Ender Quarry energy storage override").addMixinClasses(new String[]{"extrautilities.MixinTileEntityEnderQuarry"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> TweaksConfig.extraUtilitiesEnderQuarryOverride > 0).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_ENDERQUARRY_FREEZE(new MixinBuilder("Fix Ender Quarry freezes randomly").addMixinClasses(new String[]{"extrautilities.MixinTileEntityEnderQuarry_FixFreeze"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesEnderQuarryFreeze).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_HEALING_AXE_HEAL(new MixinBuilder("Fix the healing axe not healing entities when attacking them").addMixinClasses(new String[]{"extrautilities.MixinItemHealingAxe"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixExtraUtilitiesHealingAxeHeal).addTargetedMod((ITargetedMod)TargetedMod.EXTRA_UTILITIES)),
    FIX_GLIBYS_VC_THREAD_SHUTDOWN_CLIENT(new MixinBuilder("Fix Gliby's voice chat not shutting down its client thread cleanly").addMixinClasses(new String[]{"glibysvoicechat.MixinClientNetwork"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> FixesConfig.fixGlibysVoiceChatThreadStop).addTargetedMod((ITargetedMod)TargetedMod.GLIBYS_VOICE_CHAT)),
    FIX_GLIBYS_VC_THREAD_SHUTDOWN_SERVER(new MixinBuilder("Fix Gliby's voice chat not shutting down its server thread cleanly").addMixinClasses(new String[]{"glibysvoicechat.MixinVoiceChatServer"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixGlibysVoiceChatThreadStop).addTargetedMod((ITargetedMod)TargetedMod.GLIBYS_VOICE_CHAT)),
    PORTALGUN_FIX_URLS(new MixinBuilder("Fix URLs used to download the sound pack").addMixinClasses(new String[]{"portalgun.MixinThreadDownloadResources"}).addTargetedMod((ITargetedMod)TargetedMod.PORTAL_GUN).setApplyIf(() -> FixesConfig.fixPortalGunURLs).setPhase(Phase.LATE).setSide(Side.CLIENT)),
    REPLACE_VOXELMAP_REFLECTION(new MixinBuilder("Replace VoxelMap Reflection").addMixinClasses(new String[]{"voxelmap.reflection.MixinAddonResourcePack", "voxelmap.reflection.MixinColorManager", "voxelmap.reflection.MixinMap", "voxelmap.reflection.MixinRadar", "voxelmap.reflection.MixinVoxelMap", "voxelmap.reflection.MixinWaypointManager$1"}).addTargetedMod((ITargetedMod)TargetedMod.VOXELMAP).setApplyIf(() -> SpeedupsConfig.replaceVoxelMapReflection).setPhase(Phase.LATE).setSide(Side.CLIENT)),
    VOXELMAP_Y_FIX(new MixinBuilder("Fix off by one Y coord").addMixinClasses(new String[]{"voxelmap.MixinMap"}).addTargetedMod((ITargetedMod)TargetedMod.VOXELMAP).setApplyIf(() -> FixesConfig.fixVoxelMapYCoord).setPhase(Phase.LATE).setSide(Side.CLIENT)),
    VOXELMAP_NPE_FIX(new MixinBuilder("Fix VoxelMap NPEs with Chunks").addMixinClasses(new String[]{"voxelmap.chunk.MixinCachedRegion", "voxelmap.chunk.MixinComparisonCachedRegion"}).addTargetedMod((ITargetedMod)TargetedMod.VOXELMAP).setApplyIf(() -> FixesConfig.fixVoxelMapChunkNPE).setPhase(Phase.LATE).setSide(Side.CLIENT)),
    VOXELMAP_FILE_EXT(new MixinBuilder("Change VoxelMap cache file extension").addMixinClasses(new String[]{"voxelmap.cache.MixinCachedRegion", "voxelmap.cache.MixinCachedRegion$1", "voxelmap.cache.MixinComparisonCachedRegion"}).addTargetedMod((ITargetedMod)TargetedMod.VOXELMAP).setApplyIf(() -> TweaksConfig.changeCacheFileExtension).setPhase(Phase.LATE).setSide(Side.CLIENT)),
    DISABLE_POTION_ARRAY_EXTENDER(new MixinBuilder("Disable Witchery potion array extender").addMixinClasses(new String[]{"witchery.MixinPotionArrayExtender"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.disableWitcheryPotionExtender).addTargetedMod((ITargetedMod)TargetedMod.WITCHERY)),
    FIX_WITCHERY_REFLECTION_SKIN(new MixinBuilder("Fixes Witchery player skins reflections").addMixinClasses(new String[]{"witchery.MixinExtendedPlayer", "witchery.MixinEntityReflection"}).setSide(Side.CLIENT).setPhase(Phase.LATE).setApplyIf(() -> FixesConfig.fixWitcheryReflections).addTargetedMod((ITargetedMod)TargetedMod.WITCHERY)),
    FIX_WITCHERY_THUNDERING_DETECTION(new MixinBuilder("Fixes Witchery Thunder Detection for rituals and Witch Hunters breaking with mods modifying thunder frequency").addMixinClasses(new String[]{"witchery.MixinBlockCircle", "witchery.MixinEntityWitchHunter", "witchery.MixinRiteClimateChange"}).setSide(Side.BOTH).setPhase(Phase.LATE).setApplyIf(() -> FixesConfig.fixWitcheryThunderDetection).addTargetedMod((ITargetedMod)TargetedMod.WITCHERY)),
    FIX_WITCHERY_RENDERING(new MixinBuilder("Fixes Witchery Rendering errors").addMixinClasses(new String[]{"witchery.MixinBlockCircleGlyph"}).setSide(Side.CLIENT).setPhase(Phase.LATE).setApplyIf(() -> FixesConfig.fixWitcheryRendering).addTargetedMod((ITargetedMod)TargetedMod.WITCHERY)),
    GC_TIME_COMMAND_FIX(new MixinBuilder("GC Time Fix").addMixinClasses(new String[]{"minecraft.MixinTimeCommandGalacticraftFix"}).setPhase(Phase.EARLY).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixTimeCommandWithGC).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).addTargetedMod((ITargetedMod)TargetedMod.GALACTICRAFT_CORE)),
    BIBLIOCRAFT_PACKET_FIX(new MixinBuilder("Packet Fix").addMixinClasses(new String[]{"bibliocraft.MixinBibliocraftPatchPacketExploits"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixBibliocraftPackets).addTargetedMod((ITargetedMod)TargetedMod.BIBLIOCRAFT)),
    BIBLIOCRAFT_PATH_SANITIZATION_FIX(new MixinBuilder("Path sanitization fix").addMixinClasses(new String[]{"bibliocraft.MixinPathSanitization"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixBibliocraftPackets).addTargetedMod((ITargetedMod)TargetedMod.BIBLIOCRAFT)),
    ZTONES_PACKET_FIX(new MixinBuilder("Packet Fix").addMixinClasses(new String[]{"ztones.MixinZtonesPatchPacketExploits"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixZTonesPackets).addTargetedMod((ITargetedMod)TargetedMod.ZTONES)),
    ASP_RECIPE_FIX(new MixinBuilder("MT Core recipe fix").addMixinClasses(new String[]{"advancedsolarpanels.MixinAdvancedSolarPanel"}).addTargetedMod((ITargetedMod)TargetedMod.ADVANCED_SOLAR_PANELS).addExcludedMod((ITargetedMod)TargetedMod.DREAMCRAFT).setApplyIf(() -> FixesConfig.fixMTCoreRecipe).setPhase(Phase.LATE).setSide(Side.BOTH)),
    TD_NASE_PREVENTION(new MixinBuilder("Prevent NegativeArraySizeException on itemduct transfers").addMixinClasses(new String[]{"thermaldynamics.MixinSimulatedInv"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.preventThermalDynamicsNASE).addTargetedMod((ITargetedMod)TargetedMod.THERMALDYNAMICS).setPhase(Phase.LATE)),
    TD_FLUID_GRID_CCE(new MixinBuilder("Prevent ClassCastException on forming invalid Thermal Dynamic fluid grid").addMixinClasses(new String[]{"thermaldynamics.MixinTileFluidDuctSuper"}).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.preventFluidGridCrash).addTargetedMod((ITargetedMod)TargetedMod.THERMALDYNAMICS).setPhase(Phase.LATE)),
    UNBIND_KEYS_TRAVELLERSGEAR(new MixinBuilder("Unbind Traveller's Gear keybinds").addMixinClasses(new String[]{"travellersgear.MixinKeyHandler"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addTargetedMod((ITargetedMod)TargetedMod.TRAVELLERSGEAR)),
    UNBIND_KEYS_INDUSTRIALCRAFT(new MixinBuilder("Unbind Industrial craft keybinds").addMixinClasses(new String[]{"ic2.MixinKeyboardClient"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    UNBIND_KEYS_THAUMCRAFT(new MixinBuilder("Unbind Thaumcraft keybinds").addMixinClasses(new String[]{"thaumcraft.MixinKeyHandlerThaumcraft"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addTargetedMod((ITargetedMod)TargetedMod.THAUMCRAFT)),
    UNBIND_KEYS_COFH(new MixinBuilder("Unbind COFH Core keybinds").addMixinClasses(new String[]{"cofhcore.MixinProxyClient"}).setSide(Side.CLIENT).setPhase(Phase.EARLY).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addTargetedMod((ITargetedMod)TargetedMod.COFH_CORE)),
    CHANGE_KEYBIND_CATEGORY_AUTOMAGY(new MixinBuilder("Change keybind category of Automagy").addMixinClasses(new String[]{"automagy.MixinAutomagyKeyHandler"}).setPhase(Phase.LATE).setSide(Side.CLIENT).setApplyIf(() -> TweaksConfig.unbindKeybindsByDefault).addTargetedMod((ITargetedMod)TargetedMod.AUTOMAGY)),
    IC2_CELL(new MixinBuilder("No IC2 Cell Consumption in tanks").addMixinClasses(new String[]{"ic2.MixinIC2ItemCell"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> TweaksConfig.ic2CellWithContainer).addTargetedMod((ITargetedMod)TargetedMod.IC2)),
    DISABLE_CHUNK_TERRAIN_GENERATION(new MixinBuilder("Disable chunk terrain generation").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinChunkProviderServer_DisableTerrain"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setApplyIf(() -> TweaksConfig.disableChunkTerrainGeneration)),
    DISABLE_WORLD_TYPE_CHUNK_POPULATION(new MixinBuilder("Disable chunk population tied to chunk generation (ores/structure)").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinChunkProviderServer_DisablePopulation"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setApplyIf(() -> TweaksConfig.disableWorldTypeChunkPopulation)),
    DISABLE_MODDED_CHUNK_POPULATION(new MixinBuilder("Disable all other mod chunk population (e.g. Natura clouds").setPhase(Phase.EARLY).addMixinClasses(new String[]{"minecraft.MixinChunkProviderServer_DisableModGeneration"}).addTargetedMod((ITargetedMod)TargetedMod.VANILLA).setSide(Side.BOTH).setApplyIf(() -> TweaksConfig.disableModdedChunkPopulation)),
    FIX_SUGARBLOCK_NPE(new MixinBuilder("Fix NPE when interacting with sugar block").addMixinClasses(new String[]{"candycraft.MixinBlockSugar"}).setPhase(Phase.LATE).setSide(Side.BOTH).setApplyIf(() -> FixesConfig.fixCandycraftBlockSugarNPE).addTargetedMod((ITargetedMod)TargetedMod.CANDYCRAFT)),
    FIX_NOT_WAKING_PLAYERS(new MixinBuilder("Fix players not being woken properly when not everyone is sleeping").addMixinClasses(new String[]{"morpheus.MixinMorpheusWakePlayers"}).setPhase(Phase.LATE).setSide(Side.SERVER).setApplyIf(() -> FixesConfig.fixMorpheusWaking).addTargetedMod((ITargetedMod)TargetedMod.MORPHEUS));

    private final List<String> mixinClasses;
    private final List<ITargetedMod> targetedMods;
    private final List<ITargetedMod> excludedMods;
    private final Supplier<Boolean> applyIf;
    private final Phase phase;
    private final Side side;

    private Mixins(MixinBuilder builder) {
        this.mixinClasses = builder.mixinClasses;
        this.targetedMods = builder.targetedMods;
        this.excludedMods = builder.excludedMods;
        this.applyIf = builder.applyIf;
        this.phase = builder.phase;
        this.side = builder.side;
        if (this.mixinClasses.isEmpty()) {
            throw new RuntimeException("No mixin class specified for Mixin : " + this.name());
        }
        if (this.targetedMods.isEmpty()) {
            throw new RuntimeException("No targeted mods specified for Mixin : " + this.name());
        }
        if (this.applyIf == null) {
            throw new RuntimeException("No ApplyIf function specified for Mixin : " + this.name());
        }
        if (this.phase == null) {
            throw new RuntimeException("No Phase specified for Mixin : " + this.name());
        }
        if (this.side == null) {
            throw new RuntimeException("No Side function specified for Mixin : " + this.name());
        }
    }

    public List<String> getMixinClasses() {
        return this.mixinClasses;
    }

    public Supplier<Boolean> getApplyIf() {
        return this.applyIf;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public Side getSide() {
        return this.side;
    }

    public List<ITargetedMod> getTargetedMods() {
        return this.targetedMods;
    }

    public List<ITargetedMod> getExcludedMods() {
        return this.excludedMods;
    }
}

