/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntityLivingBase.class})
public abstract class MixinEntityLivingBase_FixPotionException
extends Entity {
    @Shadow
    @Final
    private HashMap<Integer, PotionEffect> activePotionsMap;
    @Shadow
    private boolean potionsNeedUpdate;

    private MixinEntityLivingBase_FixPotionException(World p_i1594_1_) {
        super(p_i1594_1_);
    }

    @Overwrite
    protected void updatePotionEffects() {
        int i;
        Iterator<Integer> iterator = this.activePotionsMap.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                PotionEffect potioneffect = this.activePotionsMap.get(iterator.next());
                if (!potioneffect.onUpdate((EntityLivingBase)this)) {
                    if (this.worldObj.isRemote) continue;
                    iterator.remove();
                    this.onFinishedPotionEffect(potioneffect);
                    continue;
                }
                if (potioneffect.getDuration() % 600 != 0) continue;
                this.onChangedPotionEffect(potioneffect, false);
            }
        }
        catch (ConcurrentModificationException potioneffect) {
            // empty catch block
        }
        if (this.potionsNeedUpdate) {
            if (!this.worldObj.isRemote) {
                if (this.activePotionsMap.isEmpty()) {
                    this.dataWatcher.updateObject(8, (Object)0);
                    this.dataWatcher.updateObject(7, (Object)0);
                    this.setInvisible(false);
                } else {
                    int i2 = PotionHelper.calcPotionLiquidColor(this.activePotionsMap.values());
                    this.dataWatcher.updateObject(8, (Object)((byte)(PotionHelper.func_82817_b(this.activePotionsMap.values()) ? 1 : 0)));
                    this.dataWatcher.updateObject(7, (Object)i2);
                    this.setInvisible(this.isPotionActive(Potion.invisibility.id));
                }
            }
            this.potionsNeedUpdate = false;
        }
        if ((i = this.dataWatcher.getWatchableObjectInt(7)) > 0) {
            boolean ambient;
            boolean bl = ambient = this.dataWatcher.getWatchableObjectByte(8) > 0;
            boolean spawnParticle = this.isInvisible() ? this.rand.nextInt(15) == 0 : this.rand.nextBoolean();
            if (ambient) {
                spawnParticle &= this.rand.nextInt(5) == 0;
            }
            if (spawnParticle) {
                double r = (double)(i >> 16 & 0xFF) / 255.0;
                double g = (double)(i >> 8 & 0xFF) / 255.0;
                double b = (double)(i & 0xFF) / 255.0;
                this.worldObj.spawnParticle(ambient ? "mobSpellAmbient" : "mobSpell", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height - (double)this.yOffset, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, r, g, b);
            }
        }
    }

    @Shadow
    protected abstract void onFinishedPotionEffect(PotionEffect var1);

    @Shadow
    protected abstract void onChangedPotionEffect(PotionEffect var1, boolean var2);

    @Shadow
    public abstract boolean isPotionActive(int var1);
}

