/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.google.common.collect.Sets;
import com.mitchej123.hodgepodge.HodgepodgeEventHandler;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayerMP.class})
public abstract class MixinEntityPlayerMP
extends EntityLivingBase {
    @Inject(method={"clonePlayer(Lnet/minecraft/entity/player/EntityPlayer;Z)V"}, at={@At(value="RETURN")})
    private void hodgepodge$injectClonePlayer(EntityPlayer oldPlayer, boolean copyEverything, CallbackInfo ci) {
        ServersideAttributeMap oldAttributeMap;
        Collection watchedAttribs;
        if (copyEverything && !(watchedAttribs = (oldAttributeMap = (ServersideAttributeMap)oldPlayer.getAttributeMap()).getWatchedAttributes()).isEmpty()) {
            ServersideAttributeMap newAttributeMap = (ServersideAttributeMap)this.getAttributeMap();
            for (IAttributeInstance oldAttr : watchedAttribs) {
                if (!(oldAttr instanceof ModifiableAttributeInstance)) continue;
                ModifiableAttributeInstance oldAttrModifiable = (ModifiableAttributeInstance)oldAttr;
                ModifiableAttributeInstance newInst = newAttributeMap.getAttributeInstance(oldAttr.getAttribute());
                for (AttributeModifier modifier : this.getModifiers(oldAttrModifiable)) {
                    try {
                        newInst.applyModifier(modifier);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            this.setHealth(oldPlayer.getHealth());
        }
    }

    @Unique
    private Collection<AttributeModifier> getModifiers(ModifiableAttributeInstance attr) {
        HashSet toReturn = Sets.newHashSet();
        for (int i = 0; i < 3; ++i) {
            toReturn.addAll(attr.getModifiersByOperation(i));
        }
        return toReturn;
    }

    @Inject(method={"closeContainer"}, at={@At(value="HEAD")})
    private void hodgepodge$detectClosingContainer(CallbackInfo ci) {
        HodgepodgeEventHandler.playersClosedContainers.add((EntityPlayerMP)this);
    }

    private MixinEntityPlayerMP(World p_i1594_1_) {
        super(p_i1594_1_);
    }
}

