/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FastUtilsObjectIntIdentityHashMap<K>
extends IdentityHashMap<K, Integer> {
    private final Reference2IntMap<K> forwardMap;

    public FastUtilsObjectIntIdentityHashMap() {
        this(32);
    }

    public FastUtilsObjectIntIdentityHashMap(int expectedMaxSize) {
        super(0);
        this.forwardMap = new Reference2IntOpenHashMap(expectedMaxSize);
        this.forwardMap.defaultReturnValue(-1);
    }

    @Override
    public Integer put(K key, Integer value) {
        return this.forwardMap.put(key, value);
    }

    @Override
    public int put(K key, int value) {
        return this.forwardMap.put(key, value);
    }

    @Override
    public Integer get(Object key) {
        int value = this.forwardMap.getInt(key);
        return value == -1 ? null : Integer.valueOf(value);
    }

    public int getInt(Objects key) {
        return this.forwardMap.getInt((Object)key);
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        return this.containsKey(key) ? this.forwardMap.getInt(key) : defaultValue.intValue();
    }

    public int getIntOrDefault(Object key, int defaultValue) {
        return this.containsKey(key) ? this.forwardMap.getInt(key) : defaultValue;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forwardMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return this.forwardMap.containsValue(intValue.intValue());
        }
        return false;
    }

    @Override
    public Integer remove(Object key) {
        return this.forwardMap.removeInt(key);
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
    }

    @Override
    public int size() {
        return this.forwardMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.forwardMap.keySet();
    }

    @Override
    @NotNull
    public Collection<Integer> values() {
        return this.forwardMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, Integer>> entrySet() {
        return this.forwardMap.entrySet();
    }
}

