package com.mitchej123.hodgepodge.client;

import java.util.Collections;

import net.minecraftforge.common.MinecraftForge;

import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.Compat;
import com.mitchej123.hodgepodge.client.handlers.ClientKeyListener;
import com.mitchej123.hodgepodge.client.handlers.ReloadSoundsGui;
import com.mitchej123.hodgepodge.config.DebugConfig;
import com.mitchej123.hodgepodge.config.FixesConfig;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.util.ManagedEnum;

import biomesoplenty.common.eventhandler.client.gui.WorldTypeMessageEventHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModMetadata;

public class HodgepodgeClient {

    public static final ManagedEnum<AnimationMode> animationsMode = new ManagedEnum<>(AnimationMode.VISIBLE_ONLY);
    public static final ManagedEnum<RenderDebugMode> renderDebugMode = new ManagedEnum<>(RenderDebugMode.REDUCED);

    public static void postInit() {

        if (DebugConfig.renderDebug) {
            renderDebugMode.set(DebugConfig.renderDebugMode);
        } else {
            renderDebugMode.set(RenderDebugMode.OFF);
        }

        if (TweaksConfig.enableDefaultLanPort) {
            if (TweaksConfig.defaultLanPort < 0 || TweaksConfig.defaultLanPort > 65535) {
                Common.log.error(
                        String.format(
                                "Default LAN port number must be in range of 0-65535, but %s was given. Defaulting to 0.",
                                TweaksConfig.defaultLanPort));
                TweaksConfig.defaultLanPort = 0;
            }
        }

        FMLCommonHandler.instance().bus().register(ClientTicker.INSTANCE);

        MinecraftForge.EVENT_BUS.register(new ReloadSoundsGui());

        if (TweaksConfig.addSystemInfo) {
            MinecraftForge.EVENT_BUS.register(DebugScreenHandler.INSTANCE);
        }

        FMLCommonHandler.instance().bus().register(new ClientKeyListener());

        if (Compat.isIC2CropPluginPresent()) {
            ModMetadata meta = Loader.instance().getIndexedModList().get("Ic2Nei").getMetadata();
            meta.authorList = Collections.singletonList("Speiger");
            meta.description = "This IC2 Addon allows you to simulate the CropBreeding.";
            meta.autogenerated = false;
        }

        if (Compat.isBiomesOPlentyPresent() && (Compat.isDreamcraftPresent() || FixesConfig.removeBOPWarning)) {
            // removes the popup that BOP shows on first world gen
            MinecraftForge.EVENT_BUS.unregister(WorldTypeMessageEventHandler.instance);
        }
    }

    public enum AnimationMode {
        NONE,
        VISIBLE_ONLY,
        ALL
    }

    public enum RenderDebugMode {
        OFF,
        REDUCED,
        FULL
    }
}
