package com.mitchej123.hodgepodge.mixins.late.ztones;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mitchej123.hodgepodge.Common;
import com.riciJak.Ztones.item.block.ItemBlockZTMetadata;
import com.riciJak.Ztones.item.block.ItemDecoBlocks2;
import com.riciJak.Ztones.network.ToggleMetaData;

/*
 * Merged from ModMixins under the MIT License Copyright bartimaeusnek & GTNewHorizons
 */
@Mixin(ToggleMetaData.class)
public class MixinZtonesPatchPacketExploits {

    @ModifyExpressionValue(
            method = "processData",
            remap = false,
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/entity/player/EntityPlayer;getHeldItem()Lnet/minecraft/item/ItemStack;",
                    remap = true))
    private ItemStack hodgepodge$getPlayerHeldZtonesItem(ItemStack original, EntityPlayer player) {
        if (original == null) {
            // no logging here. usually happens due to bad timing, e.g. the item is ejected out of inventory somehow.
            // no way this can be exploited in the first place.
            return null;
        }
        final Item heldItem = original.getItem();
        if (!(heldItem instanceof ItemBlockZTMetadata || heldItem instanceof ItemDecoBlocks2)) {
            // not valid
            // Don't kick as there are legitimate ways this could happen due to bad timing.
            Common.log.warn(
                    Common.securityMarker,
                    "{} tried to alter meta of a non-ztones block",
                    player.getGameProfile());
            return null;
        }
        return original;
    }
}
