/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockHopper.class})
public class MixinBlockHopper
extends Block {
    @Unique
    private static final EnumMap<EnumFacing, List<AxisAlignedBB>> BOUNDS;

    private MixinBlockHopper(Material materialIn) {
        super(materialIn);
    }

    @Unique
    private static AxisAlignedBB makeAABB(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return AxisAlignedBB.getBoundingBox((double)((float)fromX / 16.0f), (double)((float)fromY / 16.0f), (double)((float)fromZ / 16.0f), (double)((float)toX / 16.0f), (double)((float)toY / 16.0f), (double)((float)toZ / 16.0f));
    }

    @Unique
    private static MovingObjectPosition rayTrace(Vec3 pos, Vec3 start, Vec3 end, AxisAlignedBB boundingBox) {
        Vec3 vec3d1;
        Vec3 vec3d = start.addVector(-pos.xCoord, -pos.yCoord, -pos.zCoord);
        MovingObjectPosition raytraceresult = boundingBox.calculateIntercept(vec3d, vec3d1 = end.addVector(-pos.xCoord, -pos.yCoord, -pos.zCoord));
        if (raytraceresult == null) {
            return null;
        }
        Vec3 res = raytraceresult.hitVec.addVector(pos.xCoord, pos.yCoord, pos.zCoord);
        return new MovingObjectPosition((int)res.xCoord, (int)res.yCoord, (int)res.zCoord, raytraceresult.sideHit, pos);
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        Vec3 pos = Vec3.createVectorHelper((double)x, (double)y, (double)z);
        EnumFacing facing = EnumFacing.values()[BlockHopper.getDirectionFromMetadata((int)world.getBlockMetadata(x, y, z))];
        List<AxisAlignedBB> list = BOUNDS.get(facing);
        if (list == null) {
            return super.collisionRayTrace(world, x, y, z, start, end);
        }
        return list.stream().map(bb -> MixinBlockHopper.rayTrace(pos, start, end, bb)).anyMatch(Objects::nonNull) ? super.collisionRayTrace(world, x, y, z, start, end) : null;
    }

    private static /* synthetic */ List lambda$static$2(List commonBounds, EnumFacing a2) {
        return new ArrayList(commonBounds);
    }

    static {
        ImmutableList commonBounds = ImmutableList.of((Object)MixinBlockHopper.makeAABB(0, 10, 0, 16, 16, 16), (Object)MixinBlockHopper.makeAABB(4, 4, 4, 12, 10, 12));
        BOUNDS = Stream.of(EnumFacing.values()).filter(t -> t != EnumFacing.UP).collect(Collectors.toMap(a2 -> a2, arg_0 -> MixinBlockHopper.lambda$static$2((List)commonBounds, arg_0), (u, v) -> {
            throw new IllegalStateException();
        }, () -> new EnumMap(EnumFacing.class)));
        BOUNDS.get(EnumFacing.DOWN).add(MixinBlockHopper.makeAABB(6, 0, 6, 10, 4, 10));
        BOUNDS.get(EnumFacing.NORTH).add(MixinBlockHopper.makeAABB(6, 4, 0, 10, 8, 4));
        BOUNDS.get(EnumFacing.SOUTH).add(MixinBlockHopper.makeAABB(6, 4, 12, 10, 8, 16));
        BOUNDS.get(EnumFacing.WEST).add(MixinBlockHopper.makeAABB(12, 4, 6, 16, 8, 10));
        BOUNDS.get(EnumFacing.EAST).add(MixinBlockHopper.makeAABB(0, 4, 6, 4, 8, 10));
    }
}

