/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldDataSaver
implements IThreadedFileIO {
    public static final WorldDataSaver INSTANCE = new WorldDataSaver();
    public static final Logger LOGGER = LogManager.getLogger((String)"HodgepodgeWorldDataSaver");
    private final Map<File, WrappedNBTTagCompound> pendingData = Collections.synchronizedMap(new LinkedHashMap());

    protected WorldDataSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeNextIO() {
        block14: {
            boolean compressed;
            boolean backup;
            NBTTagCompound data;
            File file;
            Map<File, WrappedNBTTagCompound> map = this.pendingData;
            synchronized (map) {
                Iterator<Map.Entry<File, WrappedNBTTagCompound>> it = this.pendingData.entrySet().iterator();
                if (!it.hasNext()) {
                    return false;
                }
                Map.Entry<File, WrappedNBTTagCompound> entry = it.next();
                file = entry.getKey();
                WrappedNBTTagCompound wrapped = entry.getValue();
                data = wrapped.tag;
                backup = wrapped.backup;
                compressed = wrapped.compressed;
                it.remove();
            }
            if (backup) {
                File backupFile = new File(file.getParentFile(), file.getName() + "_old");
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                file.renameTo(backupFile);
            }
            try {
                if (compressed) {
                    try (FileOutputStream fileoutputstream = new FileOutputStream(file);){
                        CompressedStreamTools.writeCompressed((NBTTagCompound)data, (OutputStream)fileoutputstream);
                        break block14;
                    }
                }
                CompressedStreamTools.write((NBTTagCompound)data, (File)file);
            }
            catch (Exception e) {
                LOGGER.error("Failed to write data to file {}", new Object[]{file, e});
                e.printStackTrace();
            }
        }
        return true;
    }

    public void saveData(File file, NBTTagCompound parentTag, boolean compressed, boolean backup) {
        WrappedNBTTagCompound wrapped = new WrappedNBTTagCompound(parentTag, compressed, backup);
        if (this.pendingData.containsKey(file)) {
            this.pendingData.replace(file, wrapped);
        } else {
            this.pendingData.put(file, wrapped);
        }
        ThreadedFileIOBase.threadedIOInstance.queueIO((IThreadedFileIO)this);
    }

    static class WrappedNBTTagCompound {
        public final NBTTagCompound tag;
        public final boolean compressed;
        public final boolean backup;

        public WrappedNBTTagCompound(NBTTagCompound tag, boolean compressed, boolean backup) {
            this.tag = tag;
            this.compressed = compressed;
            this.backup = backup;
        }
    }
}

