/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringPooler {
    public static StringPooler INSTANCE;
    private static final Logger LOGGER;

    protected StringPooler() {
    }

    public static void setupPooler() {
        StringPooler stringPooler;
        String string;
        if (INSTANCE != null) {
            throw new IllegalStateException("Pooler already set up");
        }
        StringBuilder stringBuilder = new StringBuilder().append("Setting up string pooler: ");
        switch (TweaksConfig.stringPoolMode) {
            case 0: {
                string = " (JVM)";
                break;
            }
            case 1: {
                string = " (Guava strong)";
                break;
            }
            case 2: {
                string = " (Guava weak)";
                break;
            }
            default: {
                string = " (unknown)";
            }
        }
        LOGGER.info(stringBuilder.append(string).toString());
        switch (TweaksConfig.stringPoolMode) {
            case 0: {
                stringPooler = new StringPooler();
                break;
            }
            case 1: {
                stringPooler = new GuavaPooler(true);
                break;
            }
            case 2: {
                stringPooler = new GuavaPooler(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode");
            }
        }
        INSTANCE = stringPooler;
    }

    public String getString(String s2) {
        return s2.intern();
    }

    static {
        LOGGER = LogManager.getLogger((String)"HodgepodgeStringPooler");
    }

    static class GuavaPooler
    extends StringPooler {
        private final Interner<String> pool;

        protected GuavaPooler(boolean strong) {
            this.pool = strong ? Interners.newStrongInterner() : Interners.newWeakInterner();
        }

        @Override
        public String getString(String s2) {
            return (String)this.pool.intern((Object)s2);
        }
    }
}

