/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.config.FixesConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TravellersGear {
    private static NBTTagCompound cachedRoot;
    private static NBTTagCompound cachedData;
    private static NBTTagList cachedPlayerList;
    private static File dataFile;
    private static boolean dirty;

    public static void returnTGItems(EntityPlayer player) {
        if (cachedPlayerList == null) {
            Common.log.info("[TG Recovery] No player data loaded.");
            return;
        }
        UUID playerUUID = player.getUniqueID();
        boolean found = false;
        NBTTagList updatedList = new NBTTagList();
        for (int i = 0; i < cachedPlayerList.tagCount(); ++i) {
            NBTTagCompound playerTag = cachedPlayerList.getCompoundTagAt(i);
            UUID tagUUID = new UUID(playerTag.getLong("UUIDMost"), playerTag.getLong("UUIDLeast"));
            if (playerUUID.equals(tagUUID)) {
                TravellersGear.restoreInventory(player, playerTag);
                found = true;
                continue;
            }
            updatedList.appendTag((NBTBase)playerTag);
        }
        if (found) {
            cachedPlayerList = updatedList;
            dirty = true;
            TravellersGear.saveIfDirty();
        }
    }

    private static void restoreInventory(EntityPlayer player, NBTTagCompound playerTag) {
        if (!playerTag.hasKey("Inventory", 9)) {
            return;
        }
        NBTTagList inventory = playerTag.getTagList("Inventory", 10);
        for (int j2 = 0; j2 < inventory.tagCount(); ++j2) {
            ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)inventory.getCompoundTagAt(j2));
            if (stack == null || player.inventory.addItemStackToInventory(stack)) continue;
            player.entityDropItem(stack, 0.0f);
        }
        player.inventoryContainer.detectAndSendChanges();
        Common.log.info("[TG Recovery] Restored items to {}.", new Object[]{player.getCommandSenderName()});
    }

    public static void initialize() {
        WorldServer world = DimensionManager.getWorld((int)0);
        dataFile = new File(world.getSaveHandler().getWorldDirectory(), "data/TG-SaveData.dat");
        if (!dataFile.exists() || dataFile.length() == 0L) {
            Common.log.info("[TG Recovery] No TG-SaveData.dat file found.");
            TravellersGear.clearCache();
            return;
        }
        try (FileInputStream in = new FileInputStream(dataFile);){
            cachedRoot = CompressedStreamTools.readCompressed((InputStream)in);
            cachedData = cachedRoot.getCompoundTag("data");
            cachedPlayerList = cachedData.getTagList("playerList", 10);
            Common.log.info("[TG Recovery] Loaded TG-SaveData.dat with {} entries.", new Object[]{cachedPlayerList.tagCount()});
        }
        catch (Exception e) {
            Common.log.error("[TG Recovery] Failed to load TG-SaveData.dat.", (Throwable)e);
            TravellersGear.clearCache();
        }
    }

    private static void saveIfDirty() {
        if (!dirty || dataFile == null) {
            return;
        }
        if (cachedPlayerList.tagCount() == 0) {
            TravellersGear.deleteFile();
            return;
        }
        try {
            CompressedStreamTools.write((NBTTagCompound)cachedRoot, (File)dataFile);
            dirty = false;
            Common.log.info("[TG Recovery] Saved updated TG-SaveData.dat.");
        }
        catch (IOException e) {
            Common.log.error("[TG Recovery] Failed to save TG-SaveData.dat.", (Throwable)e);
        }
    }

    private static void deleteFile() {
        if (dataFile.delete()) {
            Common.log.info("[TG Recovery] TG-SaveData.dat is empty, file deleted.");
        } else {
            Common.log.warn("[TG Recovery] Failed to delete empty TG-SaveData.dat.");
        }
        TravellersGear.clearCache();
        if (FMLCommonHandler.instance().getSide().isServer()) {
            FixesConfig.returnTravellersGearItems = false;
            Common.log.info("[TG Recovery] Automatically disabled recovery config on server with no TG-SaveData.dat.");
        }
    }

    private static void clearCache() {
        cachedRoot = new NBTTagCompound();
        cachedData = new NBTTagCompound();
        cachedPlayerList = new NBTTagList();
        dirty = false;
    }
}

