/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.fml;

import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.StatCollector;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiConfig.class})
public abstract class MixinGuiConfig
extends GuiScreen {
    @Shadow(remap=false)
    @Final
    public List<IConfigElement> configElements;
    @Shadow(remap=false)
    public String title;
    @Shadow(remap=false)
    public GuiConfigEntries entryList;
    @Unique
    private List<GuiConfigEntries.IConfigEntry> hodgepodge$allEntries;
    @Unique
    private GuiTextField hodgepodge$searchBar;
    @Unique
    private static String hodgepodge$lastSearch = "";
    @Unique
    private String hodgepodge$localLastSearch = "";
    @Unique
    private int hodgepodge$oldWidth;

    @Inject(method={"<init>(Lnet/minecraft/client/gui/GuiScreen;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/String;Ljava/lang/String;)V"}, at={@At(value="TAIL")})
    private void hodgepodge$init(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2, CallbackInfo ci) {
        this.hodgepodge$oldWidth = this.field_146294_l;
        this.hodgepodge$allEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(this.entryList.listEntries);
        if (!(parentScreen instanceof GuiConfig)) {
            hodgepodge$lastSearch = "";
        }
    }

    @Inject(method={"initGui"}, at={@At(value="TAIL")})
    private void hodgepodge$initSearchBar(CallbackInfo ci) {
        int centeredTitleWidth = this.field_146289_q.func_78256_a(this.title) / 2;
        int x = this.field_146294_l / 2 + centeredTitleWidth + 10;
        int searchWidth = this.field_146294_l - x - 10;
        if (this.hodgepodge$searchBar == null) {
            this.hodgepodge$searchBar = new GuiTextField(this.field_146289_q, x, 5, searchWidth, 12);
        } else if (this.field_146294_l != this.hodgepodge$oldWidth) {
            this.hodgepodge$oldWidth = this.field_146294_l;
            this.hodgepodge$searchBar.field_146209_f = x;
            this.hodgepodge$searchBar.field_146218_h = searchWidth;
        }
        this.hodgepodge$searchBar.func_146180_a(hodgepodge$lastSearch);
    }

    @Inject(method={"initGui"}, at={@At(value="FIELD", opcode=181, target="Lcpw/mods/fml/client/config/GuiConfig;needsRefresh:Z", remap=false)})
    private void hodgepodge$captureEntries(CallbackInfo ci) {
        this.hodgepodge$allEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(this.entryList.listEntries);
    }

    @Inject(method={"keyTyped"}, at={@At(value="TAIL")})
    private void hodgepodge$keyTyped(char eventChar, int eventKey, CallbackInfo ci) {
        if (this.hodgepodge$searchBar.func_146206_l()) {
            this.hodgepodge$searchBar.func_146201_a(eventChar, eventKey);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="TAIL")})
    private void hodgepodge$clearSearchbar(int x, int y, int mouseEvent, CallbackInfo ci) {
        this.hodgepodge$searchBar.func_146192_a(x, y, mouseEvent);
        if (mouseEvent == 1 && x >= this.hodgepodge$searchBar.field_146209_f && x < this.hodgepodge$searchBar.field_146209_f + this.hodgepodge$searchBar.field_146218_h && y >= this.hodgepodge$searchBar.field_146210_g && y < this.hodgepodge$searchBar.field_146210_g + this.hodgepodge$searchBar.field_146219_i) {
            this.hodgepodge$searchBar.func_146180_a("");
        }
    }

    @Inject(method={"drawScreen"}, at={@At(value="TAIL")})
    private void hodgepodge$renderSearchBar(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        this.hodgepodge$searchBar.func_146194_f();
        if (!this.hodgepodge$searchBar.func_146206_l() && this.hodgepodge$searchBar.func_146179_b().isEmpty()) {
            this.field_146289_q.func_78276_b("Search...", this.hodgepodge$searchBar.field_146209_f + 2, 8, -1);
        }
    }

    @Inject(method={"updateScreen"}, at={@At(value="TAIL")})
    private void hodgepodge$updateElements(CallbackInfo ci) {
        this.hodgepodge$searchBar.func_146178_a();
        String searchText = this.hodgepodge$searchBar.func_146179_b().toLowerCase();
        if (!searchText.isEmpty()) {
            if (searchText.equals(this.hodgepodge$localLastSearch)) {
                return;
            }
            hodgepodge$lastSearch = this.hodgepodge$localLastSearch = searchText;
            HashSet<String> matches = new HashSet<String>();
            for (IConfigElement element : this.configElements) {
                if (!this.hodgepodge$doesElementMatchSearch(element, searchText)) continue;
                matches.add(element.getName());
                matches.add(StatCollector.func_74838_a((String)element.getLanguageKey()));
            }
            ArrayList<GuiConfigEntries.IConfigEntry> entries = new ArrayList<GuiConfigEntries.IConfigEntry>();
            for (GuiConfigEntries.IConfigEntry entry : this.hodgepodge$allEntries) {
                if (!matches.contains(entry.getName())) continue;
                entries.add(entry);
            }
            this.entryList.listEntries = entries;
        } else if (!this.hodgepodge$localLastSearch.isEmpty()) {
            this.entryList.listEntries = this.hodgepodge$allEntries;
            this.hodgepodge$localLastSearch = "";
            hodgepodge$lastSearch = "";
        }
    }

    @Unique
    private boolean hodgepodge$doesElementMatchSearch(IConfigElement<?> element, String search) {
        boolean matches;
        String name = element.getName().toLowerCase();
        String lang = StatCollector.func_74838_a((String)element.getLanguageKey()).toLowerCase();
        boolean bl = matches = name.contains(search) || lang.contains(search);
        if (!element.isProperty() && !matches) {
            List children = element.getChildElements();
            if (children == null) {
                return false;
            }
            for (IConfigElement child : children) {
                if (child == null || !this.hodgepodge$doesElementMatchSearch(child, search)) continue;
                return true;
            }
        }
        return matches;
    }
}

