/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class PacketSerializationHelper {
    public static int readExtendedVarShortOrInt(ByteBuf buf) {
        int shortValue;
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        if ((shortValue = (high & 0xFF) << 15 | low) != 0x7FFFFF) {
            return shortValue;
        }
        return ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
    }

    public static void writeExtendedVarShortOrInt(ByteBuf buf, int toWrite) {
        if (toWrite != (toWrite & 0x7FFFFF) || toWrite == 0x7FFFFF) {
            buf.writeShort(0xFFFFFF);
            buf.writeByte(255);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)toWrite, (int)5);
            return;
        }
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    private static void validateExtendedShort(ByteBuf scratch, int value) {
        scratch.clear();
        PacketSerializationHelper.writeExtendedVarShortOrInt(scratch, value);
        int readback = PacketSerializationHelper.readExtendedVarShortOrInt(scratch);
        if (value != readback) {
            System.err.printf("0x%08x != 0x%08x%n", value, readback);
            throw new RuntimeException("mismatch");
        }
        if (scratch.isReadable()) {
            System.err.printf("0x%08x overflow%n", value);
            throw new RuntimeException("overflow");
        }
        if (value >= 0 && value < 0x7FFFFF) {
            scratch.resetReaderIndex();
            int fmlReadback = ByteBufUtils.readVarShort((ByteBuf)scratch);
            if (fmlReadback != value) {
                System.err.printf("FML: 0x%08x != 0x%08x%n", value, fmlReadback);
                throw new RuntimeException("FML mismatch");
            }
        }
    }

    public static void main(String[] args) {
        ByteBuf scratchBuffer = Unpooled.buffer((int)16);
        for (int value = 0; value < Integer.MAX_VALUE; ++value) {
            if (value % 0x10000000 == 0) {
                System.out.printf("Checking 0x%08x%n", value);
            }
            PacketSerializationHelper.validateExtendedShort(scratchBuffer, value);
        }
        PacketSerializationHelper.validateExtendedShort(scratchBuffer, Integer.MAX_VALUE);
        System.out.println("All positive integers checked.");
    }
}

