/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.util.StatHandler;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.StatCollector;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.client.gui.achievement.GuiStats$StatsMobsList"})
public class MixinStatsMobsList {
    @Shadow
    @Final
    private List<EntityList.EntityEggInfo> field_148222_l;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void hodgepodge$addModdedEntities(CallbackInfo ci) {
        StatFileWriter stats = FMLClientHandler.instance().getClientPlayerEntity().getStatFileWriter();
        for (EntityList.EntityEggInfo info : StatHandler.ADDITIONAL_ENTITY_EGGS.values()) {
            if (stats.writeStat(info.field_151512_d) <= 0 && stats.writeStat(info.field_151513_e) <= 0) continue;
            this.field_148222_l.add(info);
        }
        if (TweaksConfig.sortEntityStats) {
            this.field_148222_l.sort(new Comparator<EntityList.EntityEggInfo>(){

                @Override
                public int compare(EntityList.EntityEggInfo o1, EntityList.EntityEggInfo o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    String name1 = "entity." + 1.getName(o1) + ".name";
                    String name2 = "entity." + 1.getName(o2) + ".name";
                    return StatCollector.translateToLocal((String)name1).compareToIgnoreCase(StatCollector.translateToLocal((String)name2));
                }

                private static String getName(EntityList.EntityEggInfo eei) {
                    if (eei instanceof StatHandler.EntityInfo) {
                        StatHandler.EntityInfo info = (StatHandler.EntityInfo)eei;
                        return info.name;
                    }
                    return EntityList.getStringFromID((int)eei.spawnedID);
                }
            });
        }
    }

    @ModifyExpressionValue(at={@At(target="Lnet/minecraft/entity/EntityList;getStringFromID(I)Ljava/lang/String;", value="INVOKE")}, method={"drawSlot"})
    private static String hodgepodge$getEntityName(String original, @Local EntityList.EntityEggInfo entityegginfo) {
        if (entityegginfo instanceof StatHandler.EntityInfo) {
            StatHandler.EntityInfo info = (StatHandler.EntityInfo)entityegginfo;
            return info.name;
        }
        return original;
    }
}

