/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.config.FixesConfig;
import net.minecraft.block.Block;
import net.minecraft.world.WorldServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldServer.class})
public class MixinWorldServer_LimitUpdateRecursion {
    @Unique
    private int hodgepodge$currentBlockUpdateRecursiveCalls = 0;

    @Inject(method={"scheduleBlockUpdateWithPriority"}, at={@At(value="HEAD")}, cancellable=true)
    private void hodgepodge$incrementBlockUpdateRecursionCounter(int x, int y, int z, Block block, int tickDelay, int priority, CallbackInfo ci) {
        if (this.hodgepodge$currentBlockUpdateRecursiveCalls >= FixesConfig.limitRecursiveBlockUpdateDepth) {
            StackOverflowError error = new StackOverflowError(String.format("Too many recursive block updates (%d) at world %d, block %s (%d, %d, %d) - aborting further block updates", this.hodgepodge$currentBlockUpdateRecursiveCalls, ((WorldServer)this).provider.dimensionId, block, x, y, z));
            Common.log.error(error.getMessage(), (Throwable)error);
            ci.cancel();
            return;
        }
        ++this.hodgepodge$currentBlockUpdateRecursiveCalls;
    }

    @Inject(method={"scheduleBlockUpdateWithPriority"}, at={@At(value="RETURN")})
    private void hodgepodge$decrementBlockUpdateRecursionCounter(int x, int y, int z, Block block, int tickDelay, int priority, CallbackInfo ci) {
        this.hodgepodge$currentBlockUpdateRecursiveCalls = Math.max(0, this.hodgepodge$currentBlockUpdateRecursiveCalls - 1);
    }
}

