/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EntityEnderman.class})
public abstract class MixinEntityEndermanPlaceBlacklist
extends EntityMob {
    @Unique
    private static final ArrayList<ItemStack> hodgepodge$blacklist = new ArrayList();

    public MixinEntityEndermanPlaceBlacklist(World p_i1738_1_) {
        super(p_i1738_1_);
    }

    @WrapOperation(method={"onLivingUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;renderAsNormalBlock()Z")})
    private boolean checkEndermanBlockPlace(Block instance, Operation<Boolean> original, @Local(ordinal=0) int k, @Local(ordinal=1) int i, @Local(ordinal=2) int j2) {
        int meta;
        Item item = Item.func_150898_a((Block)instance);
        if (this.hodgepodge$isBlockInEndermanPlaceBlacklist(item, meta = this.field_70170_p.func_72805_g(k, i - 1, j2))) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Unique
    private boolean hodgepodge$isBlockInEndermanPlaceBlacklist(Item item, int meta) {
        for (ItemStack is : hodgepodge$blacklist) {
            if (!Objects.equals(is.func_77973_b(), item) || is.func_77960_j() != Short.MAX_VALUE && is.func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static ItemStack hodgepodge$parseConfigLine(String str) {
        String[] input = str.split(":");
        if (input.length < 2) {
            Common.log.warn("Unable to parse item stack \"{}\" for enderman blacklist. Valid format is \"modId:name(:meta optional)\"", new Object[]{str});
            return null;
        }
        ItemStack itemStack = GameRegistry.findItemStack((String)input[0], (String)input[1], (int)1);
        if (itemStack == null) {
            Common.log.warn("Unable to find item stack \"{}\" for enderman blacklist", new Object[]{str});
            return null;
        }
        if (input.length < 3) {
            return itemStack;
        }
        try {
            itemStack.func_77964_b(Integer.parseInt(input[2]));
        }
        catch (NumberFormatException e) {
            Common.log.warn("Invalid metadata value {} for item stack {}:{} for enderman blacklist", new Object[]{input[2], input[0], input[1]});
        }
        return itemStack;
    }

    static {
        for (String s2 : TweaksConfig.endermanBlockPlaceBlacklistBlocks) {
            ItemStack stack = MixinEntityEndermanPlaceBlacklist.hodgepodge$parseConfigLine(s2);
            if (stack == null) continue;
            hodgepodge$blacklist.add(stack);
        }
    }
}

