/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.mc;

import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class SpeedupLongIntHashMapTransformer
implements IClassTransformer,
Opcodes {
    private static final String LONG_HASH_MAP = "net/minecraft/util/LongHashMap";
    private static final String LONG_HASH_MAP_OBF = "qd";
    private static final String INT_HASH_MAP = "net/minecraft/util/IntHashMap";
    private static final String INT_HASH_MAP_OBF = "pz";
    private static final String FAST_UTIL_LONG_HASH_MAP = "com/mitchej123/hodgepodge/util/FastUtilLongHashMap";
    private static final String FAST_UTIL_INT_HASH_MAP = "com/mitchej123/hodgepodge/util/FastUtilIntHashMap";
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser(new String[]{"net/minecraft/util/IntHashMap", "pz", "net/minecraft/util/LongHashMap", "qd"});
    private static final Logger LOGGER = LogManager.getLogger((String)"SpeedupLongIntHashMapTransformer");
    private static final String INIT = "<init>";
    private static final String EMPTY_DESC = "()V";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (cstPoolParser.find(basicClass, true) && !transformedName.startsWith("com.mitchej123.hodgepodge.util")) {
            byte[] transformedBytes = SpeedupLongIntHashMapTransformer.transformBytes(transformedName, basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static byte[] transformBytes(String transformedName, byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = SpeedupLongIntHashMapTransformer.transformClassNode(transformedName, cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    private static boolean transformClassNode(String transformedName, ClassNode cn) {
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                String replacement;
                AbstractInsnNode thirdNode;
                AbstractInsnNode secondNode;
                if (node.getOpcode() != 187 || !(node instanceof TypeInsnNode)) continue;
                TypeInsnNode tNode = (TypeInsnNode)node;
                if (!SpeedupLongIntHashMapTransformer.isTargetDesc(tNode.desc) || (secondNode = node.getNext()).getOpcode() != 89 || (thirdNode = secondNode.getNext()).getOpcode() != 183 || !(thirdNode instanceof MethodInsnNode)) continue;
                MethodInsnNode mNode = (MethodInsnNode)thirdNode;
                if (!mNode.name.equals(INIT) || !mNode.desc.equals(EMPTY_DESC) || !SpeedupLongIntHashMapTransformer.isTargetDesc(mNode.owner) || !tNode.desc.equals(mNode.owner)) continue;
                HodgepodgeCore.logASM(LOGGER, "Replaced " + SpeedupLongIntHashMapTransformer.getDeobfName(tNode.desc) + " instantiation in " + transformedName + "." + mn.name);
                tNode.desc = replacement = SpeedupLongIntHashMapTransformer.getReplacement(tNode.desc);
                mNode.owner = replacement;
                changed = true;
            }
        }
        return changed;
    }

    private static boolean isTargetDesc(String desc) {
        if (HodgepodgeCore.isObf()) {
            return desc.equals(INT_HASH_MAP_OBF) || desc.equals(LONG_HASH_MAP_OBF);
        }
        return desc.equals(INT_HASH_MAP) || desc.equals(LONG_HASH_MAP);
    }

    private static String getReplacement(String desc) {
        if (desc.equals(INT_HASH_MAP_OBF) || desc.equals(INT_HASH_MAP)) {
            return FAST_UTIL_INT_HASH_MAP;
        }
        if (desc.equals(LONG_HASH_MAP_OBF) || desc.equals(LONG_HASH_MAP)) {
            return FAST_UTIL_LONG_HASH_MAP;
        }
        throw new IllegalArgumentException();
    }

    private static String getDeobfName(String desc) {
        if (desc.equals(INT_HASH_MAP_OBF) || desc.equals(INT_HASH_MAP)) {
            return "IntHashMap";
        }
        if (desc.equals(LONG_HASH_MAP_OBF) || desc.equals(LONG_HASH_MAP)) {
            return "LongHashMap";
        }
        throw new IllegalArgumentException();
    }
}

