/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.rfb.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import java.util.ListIterator;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ConfigParsingTimeTransformer
implements RfbClassTransformer,
Opcodes {
    private static final String THIS = "net/minecraftforge/common/config/Configuration";

    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "debugconfigparsingtime";
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        return "net.minecraftforge.common.config.Configuration".equals(className) && classNode.isPresent();
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return;
        }
        ConfigParsingTimeTransformer.transformClassNode(cn);
        HodgepodgeClassDump.dumpRFBClass(className, classNode, this);
    }

    private static void transformClassNode(ClassNode cn) {
        cn.visitField(2, "hp$time", "J", null, null);
        for (MethodNode mn : cn.methods) {
            if (!"<init>".equals(mn.name) || !"(Ljava/io/File;Ljava/lang/String;)V".equals(mn.desc)) continue;
            ListIterator it = mn.instructions.iterator();
            boolean found = false;
            while (it.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                if (!found && insnNode.getOpcode() == 183 && insnNode instanceof MethodInsnNode) {
                    MethodInsnNode mNode = (MethodInsnNode)insnNode;
                    if (mNode.owner.equals("java/lang/Object") && mNode.name.equals("<init>") && mNode.desc.equals("()V")) {
                        found = true;
                        InsnList listStart = new InsnList();
                        listStart.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        listStart.add((AbstractInsnNode)new MethodInsnNode(183, THIS, "hp$startTimer", "()V", false));
                        mn.instructions.insert(insnNode, listStart);
                        continue;
                    }
                }
                if (insnNode.getOpcode() != 177) continue;
                InsnList listEnd = new InsnList();
                listEnd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                listEnd.add((AbstractInsnNode)new VarInsnNode(25, 1));
                listEnd.add((AbstractInsnNode)new MethodInsnNode(183, THIS, "hp$stopTimer", "(Ljava/io/File;)V", false));
                mn.instructions.insertBefore(insnNode, listEnd);
            }
        }
        MethodVisitor mv = cn.visitMethod(2, "hp$startTimer", "()V", null, null);
        mv.visitCode();
        Label label0 = new Label();
        mv.visitLabel(label0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", false);
        mv.visitFieldInsn(181, THIS, "hp$time", "J");
        Label label1 = new Label();
        mv.visitLabel(label1);
        mv.visitInsn(177);
        Label label2 = new Label();
        mv.visitLabel(label2);
        mv.visitLocalVariable("this", "Lnet/minecraftforge/common/config/Configuration;", null, label0, label2, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        mv = cn.visitMethod(2, "hp$stopTimer", "(Ljava/io/File;)V", null, null);
        mv.visitCode();
        label0 = new Label();
        mv.visitLabel(label0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", false);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, THIS, "hp$time", "J");
        mv.visitInsn(101);
        mv.visitMethodInsn(184, "com/mitchej123/hodgepodge/core/rfb/hooks/ConfigParsingTimeHook", "onEnd", "(Ljava/io/File;J)V", false);
        label1 = new Label();
        mv.visitLabel(label1);
        mv.visitInsn(177);
        label2 = new Label();
        mv.visitLabel(label2);
        mv.visitLocalVariable("this", "Lnet/minecraftforge/common/config/Configuration;", null, label0, label2, 0);
        mv.visitLocalVariable("file", "Ljava/io/File;", null, label0, label2, 1);
        mv.visitMaxs(5, 2);
        mv.visitEnd();
    }
}

