/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge;

import com.mitchej123.hodgepodge.Compat;
import com.mitchej123.hodgepodge.config.FixesConfig;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.net.MessageConfigSync;
import com.mitchej123.hodgepodge.net.NetworkHandler;
import com.mitchej123.hodgepodge.util.TravellersGear;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;

public class HodgepodgeEventHandler {
    public static final Set<EntityPlayerMP> playersClosedContainers = new ReferenceOpenHashSet();
    private boolean xuDisableAidTrigger;

    public void preinit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onZombieAidSummon(ZombieEvent.SummonAidEvent event) {
        if (!event.world.isRemote && this.xuDisableAidTrigger) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void setAidTriggerDisabled(boolean disableAidTrigger) {
        this.xuDisableAidTrigger = disableAidTrigger;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        NetworkHandler.instance.sendTo((IMessage)new MessageConfigSync(), (EntityPlayerMP)event.player);
        if (FixesConfig.returnTravellersGearItems && !Compat.isTravellersGearPresent()) {
            TravellersGear.returnTGItems(event.player);
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (TweaksConfig.avoidDroppingItemsWhenClosing && event.player instanceof EntityPlayerMP && playersClosedContainers.contains(event.player) && event.player.inventory.addItemStackToInventory(event.entityItem.getEntityItem())) {
            event.player.inventory.setItemStack(null);
            ((EntityPlayerMP)event.player).sendContainerToPlayer(event.player.inventoryContainer);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && TweaksConfig.avoidDroppingItemsWhenClosing && !playersClosedContainers.isEmpty()) {
            playersClosedContainers.clear();
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer entityPlayer;
        if (FixesConfig.fixDimensionChangeAttributes && (entityPlayer = event.player) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
            player.addExperienceLevel(0);
        }
    }
}

