/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm.transformers.mc;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class VarargDissector
implements IClassTransformer {
    private static final ObjectArrayList<String> TARGETS = new ObjectArrayList((Object[])new String[]{"net.minecraft.world.gen.layer.GenLayer", "net.minecraft.world.gen.layer.GenLayerZoom", "net.minecraft.world.gen.layer.GenLayerFuzzyZoom"});
    private static final IntArrayList CONST_INT_BYTECODES = new IntArrayList(new int[]{3, 4, 5, 6, 7, 8});
    private static final String TARGET_MNAME = "selectRandom";
    private static final String TARGET_MDESC = "([I)I";
    private static final String REPLACE_CNAME = "com/mitchej123/hodgepodge/asm/hooks/mc/RandomAid";
    private static final String REPLACE_MNAME = "random";
    private static final String[] REPLACE_MDESC = new String[]{"(II)I", "(III)I", "(IIII)I", "(IIIII)I", "(IIIIII)I"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!TARGETS.contains((Object)transformedName)) {
            return basicClass;
        }
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean changed = false;
        for (MethodNode method : classNode.methods) {
            changed |= this.transformMethod(transformedName.replace('.', '/'), method);
        }
        if (changed) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private boolean transformMethod(String className, MethodNode method) {
        boolean changed = false;
        int lastCall = -1;
        for (int i = 0; i < method.instructions.size(); ++i) {
            int ni;
            VarInsnNode varInsn;
            int ii;
            AbstractInsnNode insn = method.instructions.get(i);
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode mInsn = (MethodInsnNode)insn;
            if (insn.getOpcode() != 182 || !mInsn.name.equals(TARGET_MNAME) || !mInsn.desc.equals(TARGET_MDESC)) continue;
            int X = -1;
            for (ii = i; ii > lastCall; --ii) {
                IntInsnNode intInsn;
                AbstractInsnNode insn2 = method.instructions.get(ii);
                if (!(insn2 instanceof IntInsnNode) || (intInsn = (IntInsnNode)insn2).getOpcode() != 188 || intInsn.operand != 10) continue;
                X = CONST_INT_BYTECODES.indexOf(method.instructions.get(ii - 1).getOpcode());
                break;
            }
            if (X < 0) {
                lastCall = i;
                continue;
            }
            if (ii + 4 * X + 1 != i) {
                lastCall = i;
                continue;
            }
            AbstractInsnNode thisInsn = method.instructions.get(ii - 2);
            if (!(thisInsn instanceof VarInsnNode) || (varInsn = (VarInsnNode)thisInsn).getOpcode() != 25 || varInsn.var != 0) {
                lastCall = i;
                continue;
            }
            boolean bail = false;
            for (ni = 0; ni < X; ++ni) {
                int base = ii + 4 * ni;
                AbstractInsnNode dupInsn = method.instructions.get(base + 1);
                if (dupInsn.getOpcode() != 89) {
                    bail = true;
                    break;
                }
                AbstractInsnNode idxInsn = method.instructions.get(base + 2);
                if (idxInsn.getOpcode() != 3 + ni) {
                    bail = true;
                    break;
                }
                AbstractInsnNode loadInsn = method.instructions.get(base + 3);
                if (loadInsn.getOpcode() != 21) {
                    bail = true;
                    break;
                }
                AbstractInsnNode astoreInsn = method.instructions.get(base + 4);
                if (astoreInsn.getOpcode() == 79) continue;
                bail = true;
                break;
            }
            if (bail) {
                lastCall = i;
                continue;
            }
            method.instructions.remove(method.instructions.get(ii));
            method.instructions.insert(method.instructions.get(ii - 1), (AbstractInsnNode)new MethodInsnNode(182, className, "nextInt", "(I)I", false));
            for (ni = 1; ni <= X; ++ni) {
                method.instructions.remove(method.instructions.get(ni + ii));
                method.instructions.remove(method.instructions.get(ni + ii));
                method.instructions.remove(method.instructions.get(ni + ii + 1));
            }
            method.instructions.set(method.instructions.get(ii + X + 1), (AbstractInsnNode)new MethodInsnNode(184, REPLACE_CNAME, REPLACE_MNAME, REPLACE_MDESC[X - 1], false));
            i = lastCall = ii + X + 1;
            changed = true;
        }
        return changed;
    }
}

