/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.commands;

import com.mitchej123.hodgepodge.util.AnchorAlarm;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DebugCommand
extends CommandBase {
    public String getCommandName() {
        return "hp";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "Usage: hp <subcommand>. Valid subcommands are: toggle, anchor, randomNbt.";
    }

    private void printHelp(ICommandSender sender) {
        sender.addChatMessage((IChatComponent)new ChatComponentText("Usage: hp <toggle|anchor|randomNbt>"));
        sender.addChatMessage((IChatComponent)new ChatComponentText("\"toggle anchordebug\" - toggles RC anchor debugging"));
        sender.addChatMessage((IChatComponent)new ChatComponentText("\"anchor list [player]\" - list RC anchors placed by the player (empty for current player)"));
        sender.addChatMessage((IChatComponent)new ChatComponentText("\"randomNbt [bytes]\" - adds a random byte array of the given size to the held item"));
    }

    public List<String> addTabCompletionOptions(ICommandSender sender, String[] ss) {
        String test;
        ArrayList<String> l = new ArrayList<String>();
        String string = test = ss.length == 0 ? "" : ss[0].trim();
        if (ss.length == 0 || ss.length == 1 && (test.isEmpty() || Stream.of("toggle", "anchor", "randomNbt").anyMatch(s -> s.startsWith(test)))) {
            Stream.of("toggle", "anchor", "randomNbt").filter(s -> test.isEmpty() || s.startsWith(test)).forEach(l::add);
        } else if (test.equals("toggle")) {
            String test1 = ss[1].trim();
            if (test1.isEmpty() || "anchordebug".startsWith(test1)) {
                l.add("anchordebug");
            }
        } else if (test.equals("anchor")) {
            String test1 = ss[1].trim();
            if (test1.isEmpty() || "list".startsWith(test1) && !"list".equals(test1)) {
                l.add("list");
            } else if ("list".equals(test1) && ss.length > 2) {
                l.addAll(DebugCommand.getListOfStringsMatchingLastWord((String[])ss, (String[])MinecraftServer.getServer().getAllUsernames()));
            }
        }
        return l;
    }

    public void processCommand(ICommandSender sender, String[] strings) {
        if (strings.length < 1) {
            this.printHelp(sender);
            return;
        }
        switch (strings[0]) {
            case "toggle": {
                if (strings.length < 2 || !strings[1].equals("anchordebug")) {
                    this.printHelp(sender);
                    return;
                }
                AnchorAlarm.AnchorDebug = !AnchorAlarm.AnchorDebug;
                sender.addChatMessage((IChatComponent)new ChatComponentText("Anchor debugging: " + AnchorAlarm.AnchorDebug));
                break;
            }
            case "anchor": {
                String playerName;
                if (strings.length < 2 || !strings[1].equals("list")) {
                    this.printHelp(sender);
                    return;
                }
                String string = playerName = strings.length > 2 ? strings[2] : sender.getCommandSenderName();
                if (!AnchorAlarm.listSavedAnchors(playerName, sender.getEntityWorld())) {
                    sender.addChatMessage((IChatComponent)new ChatComponentText("No such player entity in the current world : " + playerName));
                    break;
                }
                sender.addChatMessage((IChatComponent)new ChatComponentText("Saved anchors dumped to the log for player: " + playerName));
                break;
            }
            case "randomNbt": {
                if (strings.length < 2) {
                    this.printHelp(sender);
                    return;
                }
                int byteCount = NumberUtils.toInt((String)strings[1], (int)-1);
                if (byteCount < 1) {
                    this.printHelp(sender);
                    return;
                }
                EntityPlayerMP player = DebugCommand.getCommandSenderAsPlayer((ICommandSender)sender);
                if (player.inventory == null) {
                    return;
                }
                ItemStack stack = player.inventory.getCurrentItem();
                if (stack == null || stack.getItem() == null) {
                    return;
                }
                if (stack.stackTagCompound == null) {
                    stack.stackTagCompound = new NBTTagCompound();
                }
                byte[] randomData = RandomUtils.nextBytes((int)byteCount);
                stack.stackTagCompound.setByteArray("DebugJunk", randomData);
                player.inventory.inventoryChanged = true;
                player.inventoryContainer.detectAndSendChanges();
            }
        }
    }
}

