/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.mitchej123.hodgepodge.Common;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={RandomPositionGenerator.class})
public class MixinRandomPositionGenerator {
    @Overwrite
    private static Vec3 findRandomTargetBlock(EntityCreature entityCreature, int hor, int ver, Vec3 facing) {
        boolean found = false;
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        float bestValue = -99999.0f;
        boolean tooFar = false;
        if (entityCreature.hasHome()) {
            double d1;
            double d0 = entityCreature.getHomePosition().getDistanceSquared(MathHelper.floor_double((double)entityCreature.posX), MathHelper.floor_double((double)entityCreature.posY), MathHelper.floor_double((double)entityCreature.posZ)) + 4.0f;
            tooFar = d0 < (d1 = (double)entityCreature.func_110174_bM() + (double)hor) * d1;
        }
        for (int i = 0; i < 10; ++i) {
            float blockPathWeight;
            int x1 = Common.RNG.nextInt(2 * hor + 1) - hor;
            int y1 = Common.RNG.nextInt(2 * ver + 1) - ver;
            int z1 = Common.RNG.nextInt(2 * hor + 1) - hor;
            if (facing != null && !((double)x1 * facing.xCoord + (double)z1 * facing.zCoord >= 0.0)) continue;
            int x2 = x1 + MathHelper.floor_double((double)entityCreature.posX);
            int y2 = y1 + MathHelper.floor_double((double)entityCreature.posY);
            int z2 = z1 + MathHelper.floor_double((double)entityCreature.posZ);
            if (tooFar && !entityCreature.isWithinHomeDistance(x2, y2, z2) || !((blockPathWeight = entityCreature.getBlockPathWeight(x2, y2, z2)) > bestValue)) continue;
            bestValue = blockPathWeight;
            tx = entityCreature.posX + (double)x1;
            ty = entityCreature.posY + (double)y1;
            tz = entityCreature.posZ + (double)z1;
            found = true;
            if (blockPathWeight == 0.0f) break;
        }
        return found ? Vec3.createVectorHelper((double)tx, (double)ty, (double)tz) : null;
    }
}

