/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.llamalad7.mixinextras.sugar.Local;
import com.mitchej123.hodgepodge.Common;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.chunk.storage.RegionFile;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RegionFile.class})
public abstract class MixinRegionFile {
    @Unique
    private static final int SECTOR_LENGTH = 4096;
    @Unique
    private static final long SECTOR_LLENGTH = 4096L;
    @Unique
    private static final int SECTOR_MASK = 4095;
    @Shadow
    @Final
    private static byte[] emptySector;
    @Shadow
    private RandomAccessFile dataFile;
    @Shadow
    @Final
    private int[] offsets;
    @Shadow
    @Final
    private int[] chunkTimestamps;
    @Shadow
    private ArrayList<Boolean> sectorFree;
    @Shadow
    private int sizeDelta;
    @Shadow
    private long lastModified;
    @Shadow
    @Final
    private File fileName;
    @Unique
    private final IOException hodgepodge$magicException = new IOException("cancel the constructor");

    @Shadow
    protected abstract int getOffset(int var1, int var2);

    @Shadow
    public abstract boolean isChunkSaved(int var1, int var2);

    @Shadow
    protected abstract void setChunkTimestamp(int var1, int var2, int var3) throws IOException;

    @Shadow
    protected abstract void setOffset(int var1, int var2, int var3) throws IOException;

    @Shadow
    protected abstract void write(int var1, byte[] var2, int var3) throws IOException;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/io/File;exists()Z", ordinal=0)})
    private void hodgepodge$initRedirect(File fileName, CallbackInfo ci) throws IOException {
        this.sizeDelta = 0;
        try {
            int i;
            if (fileName.exists()) {
                this.lastModified = fileName.lastModified();
            }
            this.dataFile = new RandomAccessFile(fileName, "rw");
            if (this.dataFile.length() < 4096L) {
                this.dataFile.write(emptySector);
                this.dataFile.write(emptySector);
                this.sizeDelta += 8192;
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                int oversize = (int)(this.dataFile.length() & 0xFFFL);
                int missing = 4096 - oversize;
                this.dataFile.write(emptySector, 0, missing);
            }
            int numSectors = (int)(this.dataFile.length() / 4096L);
            this.sectorFree = new ArrayList(numSectors);
            for (i = 0; i < numSectors; ++i) {
                this.sectorFree.add(true);
            }
            this.sectorFree.set(0, false);
            this.sectorFree.set(1, false);
            this.dataFile.seek(0L);
            for (i = 0; i < 1024; ++i) {
                int offset;
                this.offsets[i] = offset = this.dataFile.readInt();
                int length = offset & 0xFF;
                if (length == 255 && offset >> 8 <= this.sectorFree.size()) {
                    this.dataFile.seek((long)(offset >> 8) * 4096L);
                    length = (this.dataFile.readInt() + 4) / 4096 + 1;
                    this.dataFile.seek(i * 4 + 4);
                }
                if (offset != 0 && (offset >> 8) + length <= this.sectorFree.size()) {
                    for (int l = 0; l < length; ++l) {
                        this.sectorFree.set((offset >> 8) + l, false);
                    }
                    continue;
                }
                if (length <= 0) continue;
                FMLLog.warning((String)"Invalid chunk: (%s, %s) Offset: %s Length: %s runs off end file. %s", (Object[])new Object[]{i % 32, i / 32, offset >> 8, length, fileName});
            }
            for (i = 0; i < 1024; ++i) {
                int timestamp;
                this.chunkTimestamps[i] = timestamp = this.dataFile.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        throw this.hodgepodge$magicException;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/io/IOException;printStackTrace()V"))
    private void hodgepodge$ignoreMagicException(IOException e) {
        if (e != this.hodgepodge$magicException) {
            e.printStackTrace(System.err);
        }
    }

    @Overwrite(remap=false)
    public synchronized boolean chunkExists(int x, int z) {
        return this.isChunkSaved(x, z);
    }

    @ModifyVariable(method={"Lnet/minecraft/world/chunk/storage/RegionFile;getChunkDataInputStream(II)Ljava/io/DataInputStream;"}, at=@At(value="STORE"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/RegionFile;getOffset(II)I"), to=@At(value="INVOKE", target="Ljava/util/ArrayList;size()I")), index=5)
    private int hodgepodge$getChunkDataInputStream$extendedSectorCount(int sectorCount, @Local(index=4) int sector) throws IOException {
        if (sectorCount == 255) {
            this.dataFile.seek((long)sector * 4096L);
            sectorCount = (this.dataFile.readInt() + 4) / 4096 + 1;
        }
        return sectorCount;
    }

    @ModifyArg(method={"getChunkDataInputStream"}, at=@At(value="INVOKE", target="Ljava/io/DataInputStream;<init>(Ljava/io/InputStream;)V"), expect=2)
    private InputStream hodgepodge$getChunkDataInputStream$buffer(InputStream is) {
        return new BufferedInputStream(is);
    }

    @ModifyArg(method={"getChunkDataOutputStream"}, at=@At(value="INVOKE", target="Ljava/io/DataOutputStream;<init>(Ljava/io/OutputStream;)V"), index=0)
    private OutputStream hodgepodge$getChunkDataOutputStream$buffer(OutputStream os) {
        return new BufferedOutputStream(os);
    }

    @Overwrite
    protected synchronized void write(int x, int z, byte[] data, int length) {
        try {
            int sectorsNeeded;
            int offset = this.getOffset(x, z);
            int sector = offset >> 8;
            int sectorCount = offset & 0xFF;
            if (sectorCount == 255) {
                this.dataFile.seek((long)sector * 4096L);
                sectorCount = (this.dataFile.readInt() + 4) / 4096 + 1;
            }
            if ((sectorsNeeded = (length + 5) / 4096 + 1) >= 256) {
                Common.log.warn("[Hodgepodge] Oversized Chunk in {} at ({}, {}) - {} bytes used", new Object[]{this.fileName, x, z, (long)sectorsNeeded * 4096L});
            }
            if (sector != 0 && sectorCount == sectorsNeeded) {
                this.write(sector, data, length);
            } else {
                int i;
                for (int i2 = 0; i2 < sectorCount; ++i2) {
                    this.sectorFree.set(sector + i2, true);
                }
                int sectorStart = this.sectorFree.indexOf(true);
                int sectorLength = 0;
                if (sectorStart != -1) {
                    for (i = sectorStart; i < this.sectorFree.size(); ++i) {
                        if (sectorLength != 0) {
                            sectorLength = this.sectorFree.get(i).booleanValue() ? ++sectorLength : 0;
                        } else if (this.sectorFree.get(i).booleanValue()) {
                            sectorStart = i;
                            sectorLength = 1;
                        }
                        if (sectorLength >= sectorsNeeded) break;
                    }
                }
                if (sectorLength >= sectorsNeeded) {
                    sector = sectorStart;
                    this.setOffset(x, z, sector << 8 | Math.min(sectorsNeeded, 255));
                    for (i = 0; i < sectorsNeeded; ++i) {
                        this.sectorFree.set(sector + i, false);
                    }
                    this.write(sector, data, length);
                } else {
                    this.dataFile.seek(this.dataFile.length());
                    sector = this.sectorFree.size();
                    for (i = 0; i < sectorsNeeded; ++i) {
                        this.dataFile.write(emptySector);
                        this.sectorFree.add(false);
                    }
                    this.sizeDelta += 4096 * sectorsNeeded;
                    this.write(sector, data, length);
                    this.setOffset(x, z, sector << 8 | Math.min(sectorsNeeded, 255));
                }
            }
            this.setChunkTimestamp(x, z, (int)(MinecraftServer.getSystemTimeMillis() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace(System.err);
        }
    }
}

