/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft.fastload;

import com.mitchej123.hodgepodge.config.SpeedupsConfig;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkWatchEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayerMP.class})
public abstract class MixinEntityPlayerMP
extends EntityPlayer {
    @Shadow
    @Final
    public List<ChunkCoordIntPair> loadedChunks;
    @Shadow
    public NetHandlerPlayServer playerNetServerHandler;
    @Unique
    private final ObjectArrayList<ObjectImmutableList<Chunk>> hodgepodge$chunkSends = new ObjectArrayList();
    @Unique
    private final ObjectArrayList<Chunk> hodgepodge$rollingChunks = new ObjectArrayList();
    @Unique
    private final ObjectArrayList<TileEntity> hodgepodge$rollingTEs = new ObjectArrayList();

    @Shadow
    protected abstract void func_147097_b(TileEntity var1);

    @Shadow
    public abstract WorldServer getServerForPlayer();

    public MixinEntityPlayerMP(World world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method={"onUpdate", "localOnUpdate"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/EntityPlayerMP;loadedChunks:Ljava/util/List;", shift=At.Shift.BEFORE, ordinal=0)}, cancellable=true)
    private void hodgepodge$replaceChunkSending(CallbackInfo ci) {
        if (this.loadedChunks.isEmpty()) {
            ci.cancel();
            return;
        }
        int numChunks = 0;
        Iterator<ChunkCoordIntPair> allChunks = this.loadedChunks.iterator();
        int chunksPerPacket = S26PacketMapChunkBulk.func_149258_c();
        while (allChunks.hasNext() && numChunks < SpeedupsConfig.maxSendSpeed) {
            Chunk chunk;
            ChunkCoordIntPair ccip = allChunks.next();
            if (ccip == null) {
                allChunks.remove();
                continue;
            }
            if (!this.worldObj.blockExists(ccip.chunkXPos << 4, 0, ccip.chunkZPos << 4) || !(chunk = this.worldObj.getChunkFromChunkCoords(ccip.chunkXPos, ccip.chunkZPos)).func_150802_k()) continue;
            if (this.hodgepodge$rollingChunks.size() == chunksPerPacket) {
                this.hodgepodge$chunkSends.add((Object)new ObjectImmutableList(this.hodgepodge$rollingChunks));
                this.hodgepodge$rollingChunks.clear();
            }
            this.hodgepodge$rollingChunks.add((Object)chunk);
            this.hodgepodge$rollingTEs.addAll((Collection)((WorldServer)this.worldObj).func_147486_a(ccip.chunkXPos * 16, 0, ccip.chunkZPos * 16, ccip.chunkXPos * 16 + 15, 256, ccip.chunkZPos * 16 + 15));
            allChunks.remove();
            ++numChunks;
        }
        this.hodgepodge$chunkSends.add((Object)new ObjectImmutableList(this.hodgepodge$rollingChunks));
        if (numChunks > 0) {
            for (int i = 0; i < this.hodgepodge$chunkSends.size(); ++i) {
                this.playerNetServerHandler.sendPacket((Packet)new S26PacketMapChunkBulk((List)this.hodgepodge$chunkSends.get(i)));
            }
            for (TileEntity tileentity : this.hodgepodge$rollingTEs) {
                this.func_147097_b(tileentity);
            }
            for (int i = 0; i < numChunks; ++i) {
                int div = i / chunksPerPacket;
                int rem = i % chunksPerPacket;
                Chunk chunk = (Chunk)((ObjectImmutableList)this.hodgepodge$chunkSends.get(div)).get(rem);
                this.getServerForPlayer().getEntityTracker().func_85172_a((EntityPlayerMP)this, chunk);
                MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.Watch(chunk.getChunkCoordIntPair(), (EntityPlayerMP)this));
            }
        }
        this.hodgepodge$chunkSends.clear();
        this.hodgepodge$rollingChunks.clear();
        this.hodgepodge$rollingTEs.clear();
        ci.cancel();
    }
}

