/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.late.biomesoplenty;

import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.common.blocks.BlockBOPSapling;
import biomesoplenty.common.world.features.trees.WorldGenBOPTaiga2;
import biomesoplenty.common.world.features.trees.WorldGenBOPTaiga3;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BlockBOPSapling.class})
public class MixinBlockBOPSapling {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(III)Z")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT, method={"func_149878_d"})
    public void hodgepodge$growTree(World world, int x, int y, int z, Random random, CallbackInfo ci, int meta, Object obj, int rnd) {
        if (meta != 6) {
            return;
        }
        if (MixinBlockBOPSapling.isBigFirPattern(world, x, y, z)) {
            obj = new WorldGenBOPTaiga3(BOPCBlocks.logs1, BOPCBlocks.leaves2, 3, 1, false, 35, 10, 0, 4);
        } else if (MixinBlockBOPSapling.isBigFirNeighbor(world, x, y, z)) {
            ci.cancel();
        } else if (random.nextInt(10) == 0) {
            obj = new WorldGenBOPTaiga2(BOPCBlocks.logs1, BOPCBlocks.leaves2, 3, 1, false, 20, 15, 4, 4);
        }
        world.setBlockToAir(x, y, z);
        if (!((WorldGenerator)obj).generate(world, random, x, y, z)) {
            world.setBlock(x, y, z, BOPCBlocks.saplings, meta, 2);
        }
        ci.cancel();
    }

    @Unique
    private static boolean isFirSapling(Block block, int meta) {
        return BOPCBlocks.saplings == block && meta == 6;
    }

    @Unique
    private static boolean isBigFirPattern(World world, int x, int y, int z) {
        if (world == null || !MixinBlockBOPSapling.isFirSapling(world.getBlock(x, y, z), world.getBlockMetadata(x, y, z))) {
            return false;
        }
        for (Pair<Block, Integer> neighborBlock : MixinBlockBOPSapling.getNeighbors(world, x, y, z)) {
            if (MixinBlockBOPSapling.isFirSapling((Block)neighborBlock.getLeft(), (Integer)neighborBlock.getRight())) continue;
            return false;
        }
        return true;
    }

    @Unique
    private static boolean isBigFirNeighbor(World world, int x, int y, int z) {
        if (world == null) {
            return false;
        }
        return MixinBlockBOPSapling.isBigFirPattern(world, x - 1, y, z) || MixinBlockBOPSapling.isBigFirPattern(world, x + 1, y, z) || MixinBlockBOPSapling.isBigFirPattern(world, x, y, z - 1) || MixinBlockBOPSapling.isBigFirPattern(world, x, y, z + 1);
    }

    @Unique
    private static List<Pair<Block, Integer>> getNeighbors(World world, int x, int y, int z) {
        ArrayList<Pair<Block, Integer>> result = new ArrayList<Pair<Block, Integer>>();
        if (world != null) {
            result.add((Pair<Block, Integer>)Pair.of((Object)world.getBlock(x - 1, y, z), (Object)world.getBlockMetadata(x - 1, y, z)));
            result.add((Pair<Block, Integer>)Pair.of((Object)world.getBlock(x + 1, y, z), (Object)world.getBlockMetadata(x + 1, y, z)));
            result.add((Pair<Block, Integer>)Pair.of((Object)world.getBlock(x, y, z - 1), (Object)world.getBlockMetadata(x, y, z - 1)));
            result.add((Pair<Block, Integer>)Pair.of((Object)world.getBlock(x, y, z + 1), (Object)world.getBlockMetadata(x, y, z + 1)));
        }
        return result;
    }
}

