/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.mc;

import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class PlayerManagerTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if ("net.minecraft.server.management.PlayerManager".equals(transformedName)) {
            byte[] transformedBytes = PlayerManagerTransformer.transformBytes(basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static byte[] transformBytes(byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean changed = false;
        for (MethodNode method : classNode.methods) {
            if (!PlayerManagerTransformer.isTargetMethod(method)) continue;
            changed |= PlayerManagerTransformer.transformMethod(method);
        }
        if (changed) {
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private static boolean isTargetMethod(MethodNode method) {
        if (HodgepodgeCore.isObf()) {
            return "b".equals(method.name) && "(Lmw;)V".equals(method.desc);
        }
        return "filterChunkLoadQueue".equals(method.name) && "(Lnet/minecraft/entity/player/EntityPlayerMP;)V".equals(method.desc);
    }

    private static boolean transformMethod(MethodNode method) {
        boolean changed = false;
        for (AbstractInsnNode insn : method.instructions) {
            if (insn.getOpcode() == 183 && insn instanceof MethodInsnNode) {
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (!methodInsn.owner.equals("java/util/ArrayList") || !methodInsn.name.equals("<init>")) continue;
                methodInsn.owner = "it/unimi/dsi/fastutil/objects/ObjectOpenHashSet";
                changed = true;
                continue;
            }
            if (insn.getOpcode() == 187 && insn instanceof TypeInsnNode) {
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                if (!typeInsn.desc.equals("java/util/ArrayList")) continue;
                typeInsn.desc = "it/unimi/dsi/fastutil/objects/ObjectOpenHashSet";
                changed = true;
                continue;
            }
            if (insn.getOpcode() != 182 || !(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!methodInsn.owner.equals("java/util/ArrayList") || !methodInsn.name.equals("contains")) continue;
            methodInsn.owner = "java/util/Set";
            methodInsn.name = "contains";
            methodInsn.desc = "(Ljava/lang/Object;)Z";
            methodInsn.setOpcode(185);
            methodInsn.itf = true;
            changed = true;
        }
        if (method.localVariables != null) {
            for (LocalVariableNode localVar : method.localVariables) {
                if (!"arraylist".equals(localVar.name) || !"Ljava/util/ArrayList;".equals(localVar.desc)) continue;
                localVar.name = "loadedChunks";
                localVar.desc = "Ljava/util/Set;";
                changed = true;
            }
        }
        return changed;
    }
}

