/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.mc;

import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class VarargDissector
implements IClassTransformer,
Opcodes {
    private static final IntArrayList CONST_INT_BYTECODES = new IntArrayList(new int[]{3, 4, 5, 6, 7, 8});
    private static final String REPLACE_CNAME = "com/mitchej123/hodgepodge/core/fml/hooks/mc/RandomAid";
    private static final String REPLACE_MNAME = "random";
    private static final String[] REPLACE_MDESC = new String[]{"(II)I", "(III)I", "(IIII)I", "(IIIII)I", "(IIIIII)I"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (VarargDissector.isTargetClass(transformedName)) {
            byte[] transformedBytes = VarargDissector.transformBytes(transformedName, basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static boolean isTargetClass(String s2) {
        return "net.minecraft.world.gen.layer.GenLayer".equals(s2) || "net.minecraft.world.gen.layer.GenLayerZoom".equals(s2) || "net.minecraft.world.gen.layer.GenLayerFuzzyZoom".equals(s2);
    }

    private static byte[] transformBytes(String transformedName, byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean changed = false;
        for (MethodNode method : classNode.methods) {
            changed |= VarargDissector.transformMethod(transformedName, method);
        }
        if (changed) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }

    private static boolean transformMethod(String transformedName, MethodNode method) {
        String className = transformedName.replace('.', '/');
        String TARGET_MNAME = HodgepodgeCore.isObf() ? "a" : "selectRandom";
        String TARGET_MDESC = "([I)I";
        boolean changed = false;
        int lastCall = -1;
        for (int i = 0; i < method.instructions.size(); ++i) {
            int ni;
            VarInsnNode varInsn;
            int ii;
            AbstractInsnNode insn = method.instructions.get(i);
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode mInsn = (MethodInsnNode)insn;
            if (insn.getOpcode() != 182 || !mInsn.name.equals(TARGET_MNAME) || !mInsn.desc.equals("([I)I")) continue;
            int X = -1;
            for (ii = i; ii > lastCall; --ii) {
                IntInsnNode intInsn;
                AbstractInsnNode insn2 = method.instructions.get(ii);
                if (!(insn2 instanceof IntInsnNode) || (intInsn = (IntInsnNode)insn2).getOpcode() != 188 || intInsn.operand != 10) continue;
                X = CONST_INT_BYTECODES.indexOf(method.instructions.get(ii - 1).getOpcode());
                break;
            }
            if (X < 0) {
                lastCall = i;
                continue;
            }
            if (ii + 4 * X + 1 != i) {
                lastCall = i;
                continue;
            }
            AbstractInsnNode thisInsn = method.instructions.get(ii - 2);
            if (!(thisInsn instanceof VarInsnNode) || (varInsn = (VarInsnNode)thisInsn).getOpcode() != 25 || varInsn.var != 0) {
                lastCall = i;
                continue;
            }
            boolean bail = false;
            for (ni = 0; ni < X; ++ni) {
                int base = ii + 4 * ni;
                AbstractInsnNode dupInsn = method.instructions.get(base + 1);
                if (dupInsn.getOpcode() != 89) {
                    bail = true;
                    break;
                }
                AbstractInsnNode idxInsn = method.instructions.get(base + 2);
                if (idxInsn.getOpcode() != 3 + ni) {
                    bail = true;
                    break;
                }
                AbstractInsnNode loadInsn = method.instructions.get(base + 3);
                if (loadInsn.getOpcode() != 21) {
                    bail = true;
                    break;
                }
                AbstractInsnNode astoreInsn = method.instructions.get(base + 4);
                if (astoreInsn.getOpcode() == 79) continue;
                bail = true;
                break;
            }
            if (bail) {
                lastCall = i;
                continue;
            }
            method.instructions.remove(method.instructions.get(ii));
            method.instructions.insert(method.instructions.get(ii - 1), (AbstractInsnNode)new MethodInsnNode(182, className, "nextInt", "(I)I", false));
            for (ni = 1; ni <= X; ++ni) {
                method.instructions.remove(method.instructions.get(ni + ii));
                method.instructions.remove(method.instructions.get(ni + ii));
                method.instructions.remove(method.instructions.get(ni + ii + 1));
            }
            method.instructions.set(method.instructions.get(ii + X + 1), (AbstractInsnNode)new MethodInsnNode(184, REPLACE_CNAME, REPLACE_MNAME, REPLACE_MDESC[X - 1], false));
            i = lastCall = ii + X + 1;
            changed = true;
        }
        return changed;
    }
}

