package com.mitchej123.hodgepodge.mixins.late.bibliocraft;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEmptyMap;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.mitchej123.hodgepodge.Common;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import jds.bibliocraft.Config;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.network.ServerPacketHandler;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import jds.bibliocraft.tileentities.TileEntityMapFrame;

/*
 * Merged from ModMixins under the MIT License Copyright bartimaeusnek & GTNewHorizons
 */
@Mixin(ServerPacketHandler.class)
public class MixinBibliocraftPatchPacketExploits {

    // Some methods don't pass in all the critical packet information like the player
    private static FMLNetworkEvent.ServerCustomPacketEvent currentEvent;

    @Inject(method = "onServerPacket", at = @At("HEAD"), remap = false)
    private void hodgepodge$storeEventInfo(FMLNetworkEvent.ServerCustomPacketEvent event, CallbackInfo c) {
        currentEvent = event;
    }

    @Inject(method = "onServerPacket", at = @At("RETURN"), remap = false)
    private void hodgepodge$freeEventInfo(FMLNetworkEvent.ServerCustomPacketEvent event, CallbackInfo c) {
        currentEvent = null;
    }

    @Inject(method = "transferWaypointsToAtlas", at = @At("HEAD"), remap = false, cancellable = true)
    private void hodgepodge$fixTransferWaypointsToAtlas(TileEntityMapFrame frameTile, ItemStack atlasStack,
            EntityPlayerMP player, CallbackInfo c) {
        if (!(atlasStack.getItem() instanceof ItemAtlas)) {
            this.kickAndWarn(player, c, "BiblioAtlasGive");
        }
    }

    @Inject(method = "handleAtlasSwapUpdate", at = @At("HEAD"), remap = false, cancellable = true)
    private void hodgepodge$fixHandleAtlasSwapUpdate(ByteBuf packet, EntityPlayerMP player, CallbackInfo c) {
        packet.markReaderIndex();
        final ItemStack insecureStack = ByteBufUtils.readItemStack(packet);
        if (insecureStack == null) return;
        packet.resetReaderIndex();

        NBTTagCompound tags = insecureStack.getTagCompound();
        if (tags == null) return;

        NBTTagList inventoryTagList = tags.getTagList("Inventory", 10);
        if (inventoryTagList == null) return;
        if (!player.worldObj.isRemote) {

            for (int i = 0; i < inventoryTagList.tagCount(); i++) {
                Item itemChecks = ItemStack.loadItemStackFromNBT(inventoryTagList.getCompoundTagAt(i)).getItem();

                if (!(itemChecks instanceof ItemMap || itemChecks instanceof ItemEmptyMap)) {
                    kickAndWarn(player, c, "BiblioFrameGive");
                }
            }
        }
    }

    @Inject(method = "handleBookEdit", at = @At("HEAD"), remap = false, cancellable = true)
    private void hodgepodge$fixHandleBookEdit(ByteBuf packet, EntityPlayerMP player, CallbackInfo c) {
        packet.markReaderIndex();
        ItemStack insecureStack = ByteBufUtils.readItemStack(packet);
        packet.resetReaderIndex();
        String namePrior = insecureStack.getDisplayName();
        insecureStack.func_135074_t();
        String nameAfter = insecureStack.getDisplayName();
        if (!namePrior.equals(nameAfter) && !Config.testBookValidity(insecureStack)) {
            this.kickAndWarn(player, c, "BiblioTableGive");
        }
    }

    @ModifyVariable(
            method = "handleFancySignUpdate",
            at = @At(
                    value = "INVOKE_ASSIGN",
                    target = "Lnet/minecraft/world/World;getTileEntity(III)Lnet/minecraft/tileentity/TileEntity;"))
    private TileEntity hodgepodge$handleFancySignUpdate(TileEntity tile) {
        if (!(tile instanceof TileEntityFancySign)) {
            return null;
        }
        EntityPlayerMP player = ((NetHandlerPlayServer) currentEvent.handler).playerEntity;
        PlayerInteractEvent pie = new PlayerInteractEvent(
                player,
                PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK,
                tile.xCoord,
                tile.yCoord,
                tile.zCoord,
                0,
                tile.getWorldObj());
        if (MinecraftForge.EVENT_BUS.post(pie)) {
            // Event cancelled by a world protection plugin or otherwise
            // Don't kick as there are legitimate ways this could happen (open a gui, then someone claims the chunk,
            // then exit gui)
            Common.log
                    .warn(Common.securityMarker, "{} tried to edit a sign without permission", player.getGameProfile());
            return null;
        }
        return tile;
    }

    @Unique
    private void kickAndWarn(EntityPlayerMP player, CallbackInfo c, String exploitName) {
        player.playerNetServerHandler.kickPlayerFromServer(
                player.getDisplayName() + " tried to cheat with \"" + exploitName + "\"-Exploit!");
        Common.log.error(
                Common.securityMarker,
                "{} tried to cheat with \"{}\"-Exploit!",
                player.getGameProfile(),
                exploitName);
        c.cancel();
    }
}
