/*
 * Decompiled with CFR 0.152.
 */
package net.teabs.teabsdoctorwhomod.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.teabs.teabsdoctorwhomod.TeabsDoctorWhoModMod;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToBadWolfExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToCobblestoneExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToLegoExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToOrganExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToSmithExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToSutekhExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToWarExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToWhittakerExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ConfirmChameleonSelectionProcedure;
import net.teabs.teabsdoctorwhomod.procedures.OpenChameleonGUIProcedure;
import net.teabs.teabsdoctorwhomod.procedures.OpenChameleonPage3Procedure;
import net.teabs.teabsdoctorwhomod.world.inventory.ChameleonGUIPage2Menu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChameleonGUIPage2ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public ChameleonGUIPage2ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = ChameleonGUIPage2ButtonMessage.readTextState(buffer);
    }

    public ChameleonGUIPage2ButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(ChameleonGUIPage2ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        ChameleonGUIPage2ButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(ChameleonGUIPage2ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            ChameleonGUIPage2ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ChameleonGUIPage2Menu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenChameleonGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ConfirmChameleonSelectionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ChangeToCobblestoneExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 3) {
            ChangeToLegoExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 4) {
            ChangeToOrganExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 5) {
            ChangeToBadWolfExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 6) {
            ChangeToWarExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 7) {
            ChangeToSmithExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 8) {
            ChangeToWhittakerExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 9) {
            ChangeToSutekhExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 10) {
            OpenChameleonPage3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TeabsDoctorWhoModMod.addNetworkMessage(ChameleonGUIPage2ButtonMessage.class, ChameleonGUIPage2ButtonMessage::buffer, ChameleonGUIPage2ButtonMessage::new, ChameleonGUIPage2ButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

