/*
 * Decompiled with CFR 0.152.
 */
package net.teabs.teabsdoctorwhomod.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.teabs.teabsdoctorwhomod.TeabsDoctorWhoModMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TeabsDoctorWhoModModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TeabsDoctorWhoModMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TeabsDoctorWhoModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.DalekaniumShieldTimer = message.data.DalekaniumShieldTimer;
                    variables.LastDeathX = message.data.LastDeathX;
                    variables.LastDeathY = message.data.LastDeathY;
                    variables.LastDeathZ = message.data.LastDeathZ;
                    variables.LastDeathDim = message.data.LastDeathDim;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double DalekaniumShieldTimer = 0.0;
        public double LastDeathX = 0.0;
        public double LastDeathY = 0.0;
        public double LastDeathZ = 0.0;
        public String LastDeathDim = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TeabsDoctorWhoModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("DalekaniumShieldTimer", this.DalekaniumShieldTimer);
            nbt.m_128347_("LastDeathX", this.LastDeathX);
            nbt.m_128347_("LastDeathY", this.LastDeathY);
            nbt.m_128347_("LastDeathZ", this.LastDeathZ);
            nbt.m_128359_("LastDeathDim", this.LastDeathDim);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.DalekaniumShieldTimer = nbt.m_128459_("DalekaniumShieldTimer");
            this.LastDeathX = nbt.m_128459_("LastDeathX");
            this.LastDeathY = nbt.m_128459_("LastDeathY");
            this.LastDeathZ = nbt.m_128459_("LastDeathZ");
            this.LastDeathDim = nbt.m_128461_("LastDeathDim");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("teabs_doctor_who_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "teabs_doctor_who_mod_mapvars";
        public boolean InteriorLoad = false;
        public String X = "";
        public String Y = "";
        public String Z = "";
        public boolean ExreriorSurplus = false;
        public boolean Dematerialzed = false;
        public String TargetDimension = "\"\"";
        public double DoorPosX = 0.0;
        public double DoorPosY = 0.0;
        public double DoorPosZ = 0.0;
        public String Desktop = "\"\"";
        public boolean Locked = false;
        public double PreviousX = 0.0;
        public double PreviousY = 0.0;
        public double PreviousZ = 0.0;
        public String PreviousDimension = "\"\"";
        public String Exterior = "\"\"";
        public boolean SWDCooldown = false;
        public double XSlot1 = 0.0;
        public double YSlot1 = 0.0;
        public double ZSlot1 = 0.0;
        public double XSlot2 = 0.0;
        public double YSlot2 = 0.0;
        public double ZSlot2 = 0.0;
        public double XSlot3 = 0.0;
        public double YSlot3 = 0.0;
        public double ZSlot3 = 0.0;
        public String DimensionSlot1 = "\"\"";
        public String DimensionSlot2 = "\"\"";
        public String DimensionSlot3 = "\"\"";
        public boolean ManualFlight = false;
        public boolean RiftFound = false;
        public double RiftLocationX = 0.0;
        public double RiftLocationY = 0.0;
        public double RiftLocationZ = 0.0;
        public boolean Open = false;
        public String ExteriorSelector = "\"\"";
        public double Joke = 0.0;
        public boolean MondasLoaded = false;
        public String Direction = "\"\"";
        public boolean Shields = false;
        public boolean SkaroLoaded = false;
        public boolean Welcome = false;
        public boolean CalculateY = false;
        public boolean GallifreyLoaded = false;
        public double VM_X = 0.0;
        public double VM_Y = 0.0;
        public double VM_Z = 0.0;
        public String VM_X_string = "\"\"";
        public String VM_Y_string = "\"\"";
        public String VM_Z_string = "\"\"";
        public double Y_Calculator = 0.0;
        public boolean CaveGameLoaded = false;
        public boolean FutureTrenzaloreLoaded = false;
        public boolean PocketDimensionLoaded = false;
        public double TimeHotelDoorX = 0.0;
        public double TimeHotelDoorY = 0.0;
        public double TimeHotelDoorZ = 0.0;
        public boolean SilurianCityOverworldLoaded = false;
        public boolean SilurianCityApocalypticLoaded = false;
        public boolean SilurianCityPrehistoricLoaded = false;
        public boolean SilurianCityClassicLoaded = false;
        public double InteriorSelector = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.InteriorLoad = nbt.m_128471_("InteriorLoad");
            this.X = nbt.m_128461_("X");
            this.Y = nbt.m_128461_("Y");
            this.Z = nbt.m_128461_("Z");
            this.ExreriorSurplus = nbt.m_128471_("ExreriorSurplus");
            this.Dematerialzed = nbt.m_128471_("Dematerialzed");
            this.TargetDimension = nbt.m_128461_("TargetDimension");
            this.DoorPosX = nbt.m_128459_("DoorPosX");
            this.DoorPosY = nbt.m_128459_("DoorPosY");
            this.DoorPosZ = nbt.m_128459_("DoorPosZ");
            this.Desktop = nbt.m_128461_("Desktop");
            this.Locked = nbt.m_128471_("Locked");
            this.PreviousX = nbt.m_128459_("PreviousX");
            this.PreviousY = nbt.m_128459_("PreviousY");
            this.PreviousZ = nbt.m_128459_("PreviousZ");
            this.PreviousDimension = nbt.m_128461_("PreviousDimension");
            this.Exterior = nbt.m_128461_("Exterior");
            this.SWDCooldown = nbt.m_128471_("SWDCooldown");
            this.XSlot1 = nbt.m_128459_("XSlot1");
            this.YSlot1 = nbt.m_128459_("YSlot1");
            this.ZSlot1 = nbt.m_128459_("ZSlot1");
            this.XSlot2 = nbt.m_128459_("XSlot2");
            this.YSlot2 = nbt.m_128459_("YSlot2");
            this.ZSlot2 = nbt.m_128459_("ZSlot2");
            this.XSlot3 = nbt.m_128459_("XSlot3");
            this.YSlot3 = nbt.m_128459_("YSlot3");
            this.ZSlot3 = nbt.m_128459_("ZSlot3");
            this.DimensionSlot1 = nbt.m_128461_("DimensionSlot1");
            this.DimensionSlot2 = nbt.m_128461_("DimensionSlot2");
            this.DimensionSlot3 = nbt.m_128461_("DimensionSlot3");
            this.ManualFlight = nbt.m_128471_("ManualFlight");
            this.RiftFound = nbt.m_128471_("RiftFound");
            this.RiftLocationX = nbt.m_128459_("RiftLocationX");
            this.RiftLocationY = nbt.m_128459_("RiftLocationY");
            this.RiftLocationZ = nbt.m_128459_("RiftLocationZ");
            this.Open = nbt.m_128471_("Open");
            this.ExteriorSelector = nbt.m_128461_("ExteriorSelector");
            this.Joke = nbt.m_128459_("Joke");
            this.MondasLoaded = nbt.m_128471_("MondasLoaded");
            this.Direction = nbt.m_128461_("Direction");
            this.Shields = nbt.m_128471_("Shields");
            this.SkaroLoaded = nbt.m_128471_("SkaroLoaded");
            this.Welcome = nbt.m_128471_("Welcome");
            this.CalculateY = nbt.m_128471_("CalculateY");
            this.GallifreyLoaded = nbt.m_128471_("GallifreyLoaded");
            this.VM_X = nbt.m_128459_("VM_X");
            this.VM_Y = nbt.m_128459_("VM_Y");
            this.VM_Z = nbt.m_128459_("VM_Z");
            this.VM_X_string = nbt.m_128461_("VM_X_string");
            this.VM_Y_string = nbt.m_128461_("VM_Y_string");
            this.VM_Z_string = nbt.m_128461_("VM_Z_string");
            this.Y_Calculator = nbt.m_128459_("Y_Calculator");
            this.CaveGameLoaded = nbt.m_128471_("CaveGameLoaded");
            this.FutureTrenzaloreLoaded = nbt.m_128471_("FutureTrenzaloreLoaded");
            this.PocketDimensionLoaded = nbt.m_128471_("PocketDimensionLoaded");
            this.TimeHotelDoorX = nbt.m_128459_("TimeHotelDoorX");
            this.TimeHotelDoorY = nbt.m_128459_("TimeHotelDoorY");
            this.TimeHotelDoorZ = nbt.m_128459_("TimeHotelDoorZ");
            this.SilurianCityOverworldLoaded = nbt.m_128471_("SilurianCityOverworldLoaded");
            this.SilurianCityApocalypticLoaded = nbt.m_128471_("SilurianCityApocalypticLoaded");
            this.SilurianCityPrehistoricLoaded = nbt.m_128471_("SilurianCityPrehistoricLoaded");
            this.SilurianCityClassicLoaded = nbt.m_128471_("SilurianCityClassicLoaded");
            this.InteriorSelector = nbt.m_128459_("InteriorSelector");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("InteriorLoad", this.InteriorLoad);
            nbt.m_128359_("X", this.X);
            nbt.m_128359_("Y", this.Y);
            nbt.m_128359_("Z", this.Z);
            nbt.m_128379_("ExreriorSurplus", this.ExreriorSurplus);
            nbt.m_128379_("Dematerialzed", this.Dematerialzed);
            nbt.m_128359_("TargetDimension", this.TargetDimension);
            nbt.m_128347_("DoorPosX", this.DoorPosX);
            nbt.m_128347_("DoorPosY", this.DoorPosY);
            nbt.m_128347_("DoorPosZ", this.DoorPosZ);
            nbt.m_128359_("Desktop", this.Desktop);
            nbt.m_128379_("Locked", this.Locked);
            nbt.m_128347_("PreviousX", this.PreviousX);
            nbt.m_128347_("PreviousY", this.PreviousY);
            nbt.m_128347_("PreviousZ", this.PreviousZ);
            nbt.m_128359_("PreviousDimension", this.PreviousDimension);
            nbt.m_128359_("Exterior", this.Exterior);
            nbt.m_128379_("SWDCooldown", this.SWDCooldown);
            nbt.m_128347_("XSlot1", this.XSlot1);
            nbt.m_128347_("YSlot1", this.YSlot1);
            nbt.m_128347_("ZSlot1", this.ZSlot1);
            nbt.m_128347_("XSlot2", this.XSlot2);
            nbt.m_128347_("YSlot2", this.YSlot2);
            nbt.m_128347_("ZSlot2", this.ZSlot2);
            nbt.m_128347_("XSlot3", this.XSlot3);
            nbt.m_128347_("YSlot3", this.YSlot3);
            nbt.m_128347_("ZSlot3", this.ZSlot3);
            nbt.m_128359_("DimensionSlot1", this.DimensionSlot1);
            nbt.m_128359_("DimensionSlot2", this.DimensionSlot2);
            nbt.m_128359_("DimensionSlot3", this.DimensionSlot3);
            nbt.m_128379_("ManualFlight", this.ManualFlight);
            nbt.m_128379_("RiftFound", this.RiftFound);
            nbt.m_128347_("RiftLocationX", this.RiftLocationX);
            nbt.m_128347_("RiftLocationY", this.RiftLocationY);
            nbt.m_128347_("RiftLocationZ", this.RiftLocationZ);
            nbt.m_128379_("Open", this.Open);
            nbt.m_128359_("ExteriorSelector", this.ExteriorSelector);
            nbt.m_128347_("Joke", this.Joke);
            nbt.m_128379_("MondasLoaded", this.MondasLoaded);
            nbt.m_128359_("Direction", this.Direction);
            nbt.m_128379_("Shields", this.Shields);
            nbt.m_128379_("SkaroLoaded", this.SkaroLoaded);
            nbt.m_128379_("Welcome", this.Welcome);
            nbt.m_128379_("CalculateY", this.CalculateY);
            nbt.m_128379_("GallifreyLoaded", this.GallifreyLoaded);
            nbt.m_128347_("VM_X", this.VM_X);
            nbt.m_128347_("VM_Y", this.VM_Y);
            nbt.m_128347_("VM_Z", this.VM_Z);
            nbt.m_128359_("VM_X_string", this.VM_X_string);
            nbt.m_128359_("VM_Y_string", this.VM_Y_string);
            nbt.m_128359_("VM_Z_string", this.VM_Z_string);
            nbt.m_128347_("Y_Calculator", this.Y_Calculator);
            nbt.m_128379_("CaveGameLoaded", this.CaveGameLoaded);
            nbt.m_128379_("FutureTrenzaloreLoaded", this.FutureTrenzaloreLoaded);
            nbt.m_128379_("PocketDimensionLoaded", this.PocketDimensionLoaded);
            nbt.m_128347_("TimeHotelDoorX", this.TimeHotelDoorX);
            nbt.m_128347_("TimeHotelDoorY", this.TimeHotelDoorY);
            nbt.m_128347_("TimeHotelDoorZ", this.TimeHotelDoorZ);
            nbt.m_128379_("SilurianCityOverworldLoaded", this.SilurianCityOverworldLoaded);
            nbt.m_128379_("SilurianCityApocalypticLoaded", this.SilurianCityApocalypticLoaded);
            nbt.m_128379_("SilurianCityPrehistoricLoaded", this.SilurianCityPrehistoricLoaded);
            nbt.m_128379_("SilurianCityClassicLoaded", this.SilurianCityClassicLoaded);
            nbt.m_128347_("InteriorSelector", this.InteriorSelector);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TeabsDoctorWhoModMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "teabs_doctor_who_mod_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TeabsDoctorWhoModMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.LastDeathX = original.LastDeathX;
            clone.LastDeathY = original.LastDeathY;
            clone.LastDeathZ = original.LastDeathZ;
            clone.LastDeathDim = original.LastDeathDim;
            if (!event.isWasDeath()) {
                clone.DalekaniumShieldTimer = original.DalekaniumShieldTimer;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    TeabsDoctorWhoModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TeabsDoctorWhoModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                TeabsDoctorWhoModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

