/*
 * Decompiled with CFR 0.152.
 */
package net.teabs.teabsdoctorwhomod.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.teabs.teabsdoctorwhomod.TeabsDoctorWhoModMod;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToBricksExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToChestExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToDalekExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToDoorExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToPhoneBoothExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToPoliceBoxExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToTTCapsuleExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ChangeToTreeExteriorProcedure;
import net.teabs.teabsdoctorwhomod.procedures.ConfirmChameleonSelectionProcedure;
import net.teabs.teabsdoctorwhomod.procedures.OpenChameleonPage2Procedure;
import net.teabs.teabsdoctorwhomod.world.inventory.ChameleonGUIPage1Menu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChameleonGUIPage1ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public ChameleonGUIPage1ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = ChameleonGUIPage1ButtonMessage.readTextState(buffer);
    }

    public ChameleonGUIPage1ButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(ChameleonGUIPage1ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        ChameleonGUIPage1ButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(ChameleonGUIPage1ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            ChameleonGUIPage1ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ChameleonGUIPage1Menu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ChangeToPoliceBoxExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 1) {
            ChangeToDoorExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 2) {
            ChangeToBricksExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 3) {
            ChangeToPhoneBoothExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 4) {
            ChangeToChestExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 5) {
            ChangeToTTCapsuleExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 6) {
            OpenChameleonPage2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            ChangeToTreeExteriorProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 8) {
            ConfirmChameleonSelectionProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            ChangeToDalekExteriorProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TeabsDoctorWhoModMod.addNetworkMessage(ChameleonGUIPage1ButtonMessage.class, ChameleonGUIPage1ButtonMessage::buffer, ChameleonGUIPage1ButtonMessage::new, ChameleonGUIPage1ButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getKey()));
            buffer.m_130083_((Component)Component.m_237113_((String)entry.getValue()));
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130238_().getString();
            String value = buffer.m_130238_().getString();
            map.put(key, value);
        }
        return map;
    }
}

