/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.events.entity;

import baspig.apis.utils.ModID;
import baspig.apis.utils.events.block.BlockEvents;
import baspig.apis.utils.events.entity.EntitySettingsClasses;
import baspig.apis.utils.events.item.ItemEvents;
import baspig.apis.utils.register.RegistryKeyOf;
import baspig.apis.utils.util.BP;
import baspig.apis.utils.util.GeneralUtils;
import baspig.apis.utils.util.LogColors;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public final class EntityEvents {
    static Random random = new Random();
    private final String modId;

    public static void generate(@NotNull class_3218 world, class_2338 pos, @NotNull class_1299<?> entity) {
        class_1297 summon = entity.method_5883((class_1937)world, class_3730.field_16467);
        assert (summon != null);
        summon.method_5725(pos, 0.0f, 0.0f);
        world.method_8649(summon);
    }

    public EntityEvents(String modId, String referenceId) {
        this.modId = modId + ":" + referenceId;
    }

    public void deleteEvent(class_1299<?> entity, BlockEvents.RemoveEvent removeEvent) {
        Object object;
        Map<class_1299<?>, Object> innerMap;
        for (String modIdKeys : EntitySettingsClasses.GeneralAddEntityOnDeathMap.keySet()) {
            innerMap = EntitySettingsClasses.GeneralAddEntityOnDeathMap.get(modIdKeys);
            if (!modIdKeys.contains(this.modId)) continue;
            for (Map.Entry<class_1299<?>, Object> entry : innerMap.entrySet()) {
                if (entity != entry.getKey() || !removeEvent.equals((Object)BlockEvents.RemoveEvent.AddEntityOnBreak) || !((object = entry.getValue()) instanceof EntitySettingsClasses.AddEntityOnDeath)) continue;
                EntitySettingsClasses.AddEntityOnDeath settings = (EntitySettingsClasses.AddEntityOnDeath)object;
                innerMap.remove(entity);
                return;
            }
        }
        for (String modIdKeys : EntitySettingsClasses.GeneralDropItemOnDeathMap.keySet()) {
            innerMap = EntitySettingsClasses.GeneralDropItemOnDeathMap.get(modIdKeys);
            if (!modIdKeys.contains(this.modId)) continue;
            for (Map.Entry<class_1299<?>, Object> entry : innerMap.entrySet()) {
                if (entity != entry.getKey() || !removeEvent.equals((Object)BlockEvents.RemoveEvent.DropItemOnBreak) || !((object = entry.getValue()) instanceof EntitySettingsClasses.DropItemOnDeathSettings)) continue;
                EntitySettingsClasses.DropItemOnDeathSettings settings = (EntitySettingsClasses.DropItemOnDeathSettings)object;
                innerMap.remove(entity);
                return;
            }
        }
    }

    public void spawnEntityOnDeath(@NotNull class_1299<?> source, @NotNull class_1299<?> entityToAdd) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.AddEntityOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.AddEntityOnDeath(entityToAdd, 100.0f, 1, false, 1));
        EntitySettingsClasses.GeneralAddEntityOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnEntityOnDeath(@NotNull class_1299<?> source, @NotNull class_1299<?> entityToAdd, float rate) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.AddEntityOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.AddEntityOnDeath(entityToAdd, rate, 1, false, 1));
        EntitySettingsClasses.GeneralAddEntityOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnEntityOnDeath(@NotNull class_1299<?> source, @NotNull class_1299<?> entityToAdd, float rate, int amount) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.AddEntityOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.AddEntityOnDeath(entityToAdd, rate, amount, false, 1));
        EntitySettingsClasses.GeneralAddEntityOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnEntityOnDeath(@NotNull class_1299<?> source, @NotNull class_1299<?> entityToAdd, float rate, int amount, boolean randomDrops) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.AddEntityOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.AddEntityOnDeath(entityToAdd, rate, amount, randomDrops, 1));
        EntitySettingsClasses.GeneralAddEntityOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnEntityOnDeath(@NotNull class_1299<?> source, @NotNull class_1299<?> entityToAdd, float rate, int amount, boolean randomDrops, int minDrop) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.AddEntityOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.AddEntityOnDeath(entityToAdd, rate, amount, randomDrops, minDrop));
        EntitySettingsClasses.GeneralAddEntityOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> source, class_1792 item) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.DropItemOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.DropItemOnDeathSettings(item, 100.0f, 1, false, 1));
        EntitySettingsClasses.GeneralDropItemOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> source, class_1792 item, float rate) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.DropItemOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.DropItemOnDeathSettings(item, rate, 1, false, 1));
        EntitySettingsClasses.GeneralDropItemOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> source, class_1792 item, float rate, int amount) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.DropItemOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.DropItemOnDeathSettings(item, rate, amount, false, 1));
        EntitySettingsClasses.GeneralDropItemOnDeathMap.put(this.modId, updateMap);
    }

    public void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> source, class_1792 item, float rate, int amount, boolean randomDrops) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.DropItemOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.DropItemOnDeathSettings(item, rate, amount, randomDrops, 1));
        EntitySettingsClasses.GeneralDropItemOnDeathMap.put(this.modId, updateMap);
    }

    public void dropItemOnEntityDeath(@NotNull class_1299<? extends class_1309> source, class_1792 item, float rate, int amount, boolean randomDrops, int minDrop) {
        Map<class_1299<?>, Object> updateMap = EntitySettingsClasses.DropItemOnDeathMap;
        updateMap.put(source, new EntitySettingsClasses.DropItemOnDeathSettings(item, rate, amount, randomDrops, minDrop));
        EntitySettingsClasses.GeneralDropItemOnDeathMap.put(this.modId, updateMap);
    }

    public static void RegisterEntityEvents(ModID id) {
        String clasWhoCallThis;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 2 && !(clasWhoCallThis = stackTrace[2].getClassName()).equals("baspig.apis.utils.Baspig_utils") && !Objects.equals(id.toString(), "baspig_utils")) {
            String r = "\u001b[0m";
            String red = "\u001b[0;31m";
            String yellow = "\u001b[0;33m";
            String lightBlue = "\u001b[0;94m";
            BP.LOG.warn("Other mod is trying to access and Register/modify Easy events. It's being called by class: {}{}", (Object)yellow, (Object)clasWhoCallThis);
        }
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            Object settings;
            Object patt1$temp;
            Map<class_1299<?>, Object> innerMap;
            class_1937 patt0$temp = livingEntity.method_37908();
            if (!(patt0$temp instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)patt0$temp;
            class_1299 deadEntityType = livingEntity.method_5864();
            class_2338 blockPos = livingEntity.method_24515();
            for (String modIdKeys : EntitySettingsClasses.GeneralAddEntityOnDeathMap.keySet()) {
                if (modIdKeys == null) {
                    return;
                }
                innerMap = EntitySettingsClasses.GeneralAddEntityOnDeathMap.get(modIdKeys);
                for (Map.Entry<class_1299<?>, Object> entry : innerMap.entrySet()) {
                    if (entry == null) {
                        return;
                    }
                    if (deadEntityType != entry.getKey() || !((patt1$temp = entry.getValue()) instanceof EntitySettingsClasses.AddEntityOnDeath)) continue;
                    settings = (EntitySettingsClasses.AddEntityOnDeath)patt1$temp;
                    EntityEvents.addEntityOnDeathFunction((EntitySettingsClasses.AddEntityOnDeath)settings, serverWorld, blockPos);
                }
            }
            for (String modIdKeys : EntitySettingsClasses.GeneralDropItemOnDeathMap.keySet()) {
                if (modIdKeys == null) {
                    return;
                }
                innerMap = EntitySettingsClasses.GeneralDropItemOnDeathMap.get(modIdKeys);
                for (Map.Entry<class_1299<?>, Object> entry : innerMap.entrySet()) {
                    if (entry == null) {
                        return;
                    }
                    if (deadEntityType != entry.getKey() || !((patt1$temp = entry.getValue()) instanceof EntitySettingsClasses.DropItemOnDeathSettings)) continue;
                    settings = (EntitySettingsClasses.DropItemOnDeathSettings)patt1$temp;
                    EntityEvents.dropItemOnDeathFunction((EntitySettingsClasses.DropItemOnDeathSettings)settings, serverWorld, blockPos);
                }
            }
        });
    }

    private static int dropMather(EntitySettingsClasses.AddEntityOnDeath settings) {
        if (settings.minDrop < settings.amount) {
            int extra = random.nextInt(settings.amount - settings.minDrop);
            return settings.randomDrops ? settings.minDrop + extra : settings.minDrop;
        }
        return settings.minDrop;
    }

    private static int dropMather(EntitySettingsClasses.DropItemOnDeathSettings settings) {
        if (settings.minDrop < settings.amount) {
            int extra = random.nextInt(settings.amount - settings.minDrop);
            return settings.randomDrops ? settings.minDrop + extra : settings.minDrop;
        }
        return settings.minDrop;
    }

    private static void addEntityOnDeathFunction(EntitySettingsClasses.AddEntityOnDeath settings, class_3218 serverWorld, class_2338 blockPos) {
        if (GeneralUtils.probability(settings.rate).booleanValue()) {
            int dropAmount = EntityEvents.dropMather(settings);
            for (int i = 0; i < dropAmount; ++i) {
                EntityEvents.generate(serverWorld, blockPos, settings.entityType);
            }
        }
    }

    private static void dropItemOnDeathFunction(EntitySettingsClasses.DropItemOnDeathSettings settings, class_3218 serverWorld, class_2338 blockPos) {
        if (GeneralUtils.probability(settings.rate).booleanValue()) {
            int dropAmount = EntityEvents.dropMather(settings);
            for (int i = 0; i < dropAmount; ++i) {
                ItemEvents.createWorldItem((class_1937)serverWorld, blockPos, settings.item.method_7854());
            }
        }
    }

    public static enum RemoveEvent {
        AddEntityOnBreak,
        DropItemOnBreak,
        ExplodeOnBreak,
        PlaySoundOnBreak;

    }

    public static class Register {
        public static <T extends class_1297> class_1299<T> entityType(class_2960 identifier, class_1299.class_4049<T> factory, class_1299.class_1300<T> builder) {
            return Register.register(identifier, factory, builder);
        }

        private static <T extends class_1297> class_1299<T> register(class_2960 identifier, class_1299.class_4049<T> factory, class_1299.class_1300<T> builder) {
            if (identifier == null) {
                throw new IllegalArgumentException("Identifier of '" + LogColors.tintBlue("Register Entity") + "' is" + LogColors.getNullText());
            }
            if (factory == null) {
                throw new IllegalArgumentException("Factory of '" + LogColors.tintBlue("Register Entity") + "' is" + LogColors.getNullText());
            }
            if (builder == null) {
                throw new IllegalArgumentException("Builder of '" + LogColors.tintBlue("Register Entity") + "' is " + LogColors.getNullText());
            }
            return (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)identifier, (Object)builder.method_5905(RegistryKeyOf.entity(identifier)));
        }
    }
}

