/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.util.screen;

import baspig.apis.utils.util.GeneralUtils;
import baspig.apis.utils.util.screen.ScreenRatios;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4588;

public class ScreenSize {
    public short screenWidth;
    public short screenHeight;
    protected class_4588 vertexConsumer;
    protected class_1921 renderLayer;
    int Min_X;
    int Min_Y;
    int Max_X;
    int Max_Y;

    public ScreenSize(int screenWidth, int screenHeight, short offsetX, short offsetY) {
        this.renderLayer = null;
        this.vertexConsumer = null;
        offsetX = GeneralUtils.switchToPositive(offsetX);
        offsetY = GeneralUtils.switchToPositive(offsetY);
        this.Min_X = offsetX;
        this.Min_Y = offsetY;
        this.Max_X = screenWidth + offsetX;
        this.Max_Y = screenHeight + offsetY;
    }

    public ScreenSize(int minX, int minY, int maxX, int maxY) {
        this.renderLayer = null;
        this.vertexConsumer = null;
        this.Min_X = GeneralUtils.switchToPositive(minX);
        this.Min_Y = GeneralUtils.switchToPositive(minY);
        this.Max_X = GeneralUtils.switchToPositive(maxX);
        this.Max_Y = GeneralUtils.switchToPositive(maxY);
        this.screenWidth = (short)(maxX - minX);
        this.screenHeight = (short)(maxY - minY);
    }

    public ScreenSize(class_1921 RenderLayer, int minX, int minY, int maxX, int maxY) {
        this.renderLayer = RenderLayer;
        this.vertexConsumer = null;
        this.Min_X = GeneralUtils.switchToPositive(minX);
        this.Min_Y = GeneralUtils.switchToPositive(minY);
        this.Max_X = GeneralUtils.switchToPositive(maxX);
        this.Max_Y = GeneralUtils.switchToPositive(maxY);
        this.screenWidth = (short)(maxX - minX);
        this.screenHeight = (short)(maxY - minY);
    }

    public ScreenSize(class_4588 VertexConsumer, int minX, int minY, int maxX, int maxY) {
        this.renderLayer = null;
        this.vertexConsumer = VertexConsumer;
        this.Min_X = GeneralUtils.switchToPositive(minX);
        this.Min_Y = GeneralUtils.switchToPositive(minY);
        this.Max_X = GeneralUtils.switchToPositive(maxX);
        this.Max_Y = GeneralUtils.switchToPositive(maxY);
        this.screenWidth = (short)(maxX - minX);
        this.screenHeight = (short)(maxY - minY);
    }

    public int getMax_X() {
        return this.Max_X;
    }

    public int getMax_Y() {
        return this.Max_Y;
    }

    public int getMin_X() {
        return this.Min_X;
    }

    public int getMin_Y() {
        return this.Min_Y;
    }

    public class_1921 getRenderLayer() {
        return this.renderLayer;
    }

    public class_4588 getVertexConsumer() {
        return this.vertexConsumer;
    }

    private void reSetSizes(int screenWidth, int screenHeight, byte offsetX, byte offsetY) {
        offsetX = GeneralUtils.switchToPositive(offsetX);
        offsetY = GeneralUtils.switchToPositive(offsetY);
        this.Min_X = offsetX;
        this.Min_Y = offsetY;
        this.Max_X = screenWidth + offsetX;
        this.Max_Y = screenHeight + offsetY;
    }

    public void setSizeWith(byte ratioWidth, byte ratioHeight, byte screenHeight) {
        int width = 500;
        int height = 500;
        screenHeight = (byte)(screenHeight / ratioWidth);
        width = screenHeight * ratioWidth;
        height = screenHeight * ratioHeight;
        this.reSetSizes(width, height, (byte)class_310.method_1551().method_22683().method_4480(), (byte)class_310.method_1551().method_22683().method_4507());
    }

    public void setSizeWith(ScreenRatios screenRatio, byte screenHeight) {
        int width = 500;
        int height = 500;
        switch (screenRatio) {
            case SR_16_9: {
                screenHeight = (byte)(screenHeight / 9);
                width = screenHeight * 16;
                height = screenHeight * 9;
                break;
            }
            case SR_3_2: {
                screenHeight = (byte)(screenHeight / 3);
                width = screenHeight * 3;
                height = screenHeight * 2;
                break;
            }
            case SR_4_3: {
                screenHeight = (byte)(screenHeight / 4);
                width = screenHeight * 4;
                height = screenHeight * 3;
                break;
            }
            case SR_1_1: {
                width = screenHeight;
                height = screenHeight;
                break;
            }
            case SR_21_9: {
                screenHeight = (byte)(screenHeight / 21);
                width = screenHeight * 21;
                height = screenHeight * 9;
            }
        }
        this.reSetSizes(width, height, (byte)class_310.method_1551().method_22683().method_4480(), (byte)class_310.method_1551().method_22683().method_4507());
    }
}

