/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.files;

import baspig.apis.utils.files.FileUtils;
import baspig.apis.utils.files.UpdateMode;
import baspig.apis.utils.util.BP;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EasyJSONInstance {
    private final String className;
    private final String PATH;
    private final String FILE;
    private final String XOR_EncryptKey;
    private final SerializationFeature SERIALIZATION_OUTPUT_INDENT = SerializationFeature.INDENT_OUTPUT;
    private final int JSON_SIMPLE_TYPE = 4032;
    private String LOGGER;

    public EasyJSONInstance(String path, String file, @Nullable String loggerId) {
        this.XOR_EncryptKey = null;
        this.className = loggerId != null ? "EasyJSONInstance-" + loggerId : "EasyJSONInstance";
        this.LOGGER = loggerId;
        this.PATH = FileUtils.fixPath(path);
        this.FILE = file;
    }

    public EasyJSONInstance(String path, String file, @Nullable String loggerId, String encrypt_key) {
        this.XOR_EncryptKey = encrypt_key;
        this.className = loggerId != null ? "EasyJSONInstance-" + loggerId : "EasyJSONInstance";
        this.LOGGER = loggerId;
        this.PATH = FileUtils.fixPath(path);
        this.FILE = file;
    }

    public EasyJSONInstance(Class<?> Class2, String path, String file, @Nullable String loggerId) {
        this.XOR_EncryptKey = null;
        this.className = loggerId != null ? Class2.getName() + "-" + loggerId : "EasyJSONInstance";
        this.PATH = FileUtils.fixPath(path);
        this.FILE = file;
    }

    public EasyJSONInstance(Class<?> Class2, String path, String file, @Nullable String loggerId, String encrypt_key) {
        this.XOR_EncryptKey = encrypt_key;
        this.className = loggerId != null ? Class2.getName() + "-" + loggerId : "EasyJSONInstance";
        this.LOGGER = loggerId;
        this.PATH = FileUtils.fixPath(path);
        this.FILE = file;
    }

    public void changeLoggerId(String loggerId) {
        this.LOGGER = loggerId;
    }

    public String getLOGGER_ID() {
        return this.LOGGER;
    }

    public String getPATH() {
        return this.PATH;
    }

    public String getFILE() {
        return this.FILE;
    }

    public synchronized void write(List<String> keys, List<Object> values) {
        FileUtils.checkJSONArgsLength(keys, values, this.LOGGER + ": write");
        try {
            File directory = new File(this.PATH);
            if (!(directory.exists() || directory.mkdirs() || this.PATH.isEmpty())) {
                BP.fancyFileLog(this.className, "write", "Already created - don't worry", directory.getAbsolutePath());
                return;
            }
            LinkedHashMap<String, Object> orderedMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                Object value = values.get(i);
                if (value instanceof JSONObject) {
                    value = new ObjectMapper().readValue(value.toString(), Map.class);
                }
                orderedMap.put(keys.get(i), value);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            File outputFile = new File(this.PATH + this.FILE + ".json");
            if (outputFile.exists()) {
                BP.fancyFileLog(this.className, "write", "File already exists", directory.getAbsolutePath());
                return;
            }
            mapper.writeValue(outputFile, orderedMap);
            BP.fancyFileLog(this.className, "write", "Successfully wrote JSON file", directory.getAbsolutePath());
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "write", "Successfully wrote JSON file", e.getMessage());
        }
    }

    public synchronized void write(List<String> keys, List<Object> values, UpdateMode mode) {
        FileUtils.checkJSONArgsLength(keys, values, this.LOGGER + ": write");
        try {
            File directory = new File(this.PATH);
            if (!(directory.exists() || directory.mkdirs() || this.PATH.isEmpty())) {
                BP.fancyFileLog(this.className, "write", "Failed to create directory", directory.getAbsolutePath());
                return;
            }
            String fullPath = this.PATH + this.FILE + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.fancyFileLog(this.className, "write", "File already exists, skipping due to NOTHING mode", directory.getAbsolutePath());
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String content = new String(Files.readAllBytes(outputFile.toPath()));
                    currentData = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(this){});
                }
                catch (IOException e) {
                    BP.fancyFileLog(this.className, "write", "Could not read existing JSON", directory.getAbsolutePath());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.fancyFileLog(this.className, "write", "No changes detected, skipping write.", directory.getAbsolutePath());
                return;
            }
            mapper.writeValue(outputFile, currentData);
            BP.fancyFileLog(this.className, "write", "Successfully wrote JSON file", directory.getAbsolutePath());
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "write", "Failed to write JSON", e.getMessage());
        }
    }

    public synchronized void write(List<String> keys, List<Object> values, UpdateMode mode, List<String> ignoredKeys) {
        String title = this.LOGGER + ": write-advanced";
        FileUtils.checkJSONArgsLength(keys, values, title);
        try {
            File directory = new File(this.PATH);
            if (!(directory.exists() || directory.mkdirs() || this.PATH.isEmpty())) {
                BP.fancyFileLog(this.className, "write", "Failed to create directory", directory.getAbsolutePath());
                return;
            }
            String fullPath = this.PATH + this.FILE + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.fancyFileLog(this.className, "write", "File already exists, skipping due to NOTHING mode", directory.getAbsolutePath());
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String content = new String(Files.readAllBytes(outputFile.toPath()));
                    currentData = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(this){});
                }
                catch (IOException e) {
                    BP.fancyFileLog(this.className, "write", "Could not read existing JSON", directory.getAbsolutePath());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                if (ignoredKeys.contains(keys.get(i)) && currentData.containsKey(keys.get(i))) continue;
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.fancyLog(this.className, "write", "No changes detected, skipping write.", directory.getAbsolutePath());
                return;
            }
            mapper.writeValue(outputFile, currentData);
            BP.fancyFileLog(this.className, "write", "Successfully wrote JSON file.", directory.getAbsolutePath());
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "write", "Failed to write JSON", e.getMessage());
        }
    }

    public synchronized void replace(List<String> keys, List<Object> values) {
        FileUtils.checkJSONArgsLength(keys, values, "replace-multiple");
        try {
            File directory = new File(this.PATH);
            File jsonFile = new File(directory, this.FILE + ".json");
            if (!jsonFile.exists()) {
                BP.fancyFileLog(this.className, "replace", "JSON file does not exist. No action taken", directory.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            Map jsonMap = (Map)mapper.readValue(jsonFile, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(this){});
            for (int i = 0; i < keys.size(); ++i) {
                String[] keyPath = keys.get(i).split("\\.");
                this.setValue(jsonMap, keyPath, values.get(i));
            }
            File outputFile = new File(this.PATH + this.FILE + ".json");
            mapper.writeValue(outputFile, (Object)jsonMap);
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "replace", "Failed to write JSON file", e.getMessage());
        }
    }

    public synchronized void replace(String key, Object value) {
        try {
            File directory = new File(this.PATH);
            File jsonFile = new File(directory, this.FILE + ".json");
            if (!jsonFile.exists()) {
                BP.fancyFileLog(this.className, "replace", "JSON file does not exist. No action taken", directory.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            Map jsonMap = (Map)mapper.readValue(jsonFile, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(this){});
            String[] keyPath = key.split("\\.");
            this.setValue(jsonMap, keyPath, value);
            File outputFile = new File(this.PATH + this.FILE + ".json");
            mapper.writeValue(outputFile, (Object)jsonMap);
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "replace", "Failed to write JSON file", e.getMessage());
        }
    }

    public synchronized void replace(String key, Object value, String encryptKey) {
        try {
            File directory = new File(this.PATH);
            File jsonFile = new File(directory, this.FILE + ".json");
            if (!jsonFile.exists()) {
                BP.fancyFileLog(this.className, "replace-encrypt", "JSON file does not exist. No action taken", directory.getAbsolutePath());
                return;
            }
            String encryptedContent = Files.readString(jsonFile.toPath());
            String decryptedContent = this.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            Map jsonMap = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(this){});
            String[] keyPath = key.split("\\.");
            this.setValue(jsonMap, keyPath, value);
            String updatedJson = mapper.writeValueAsString((Object)jsonMap);
            String encryptedJson = this.xorEncryptAndDecrypt(updatedJson, encryptKey);
            Files.writeString(jsonFile.toPath(), (CharSequence)encryptedJson, new OpenOption[0]);
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "replace-encrypt", "Failed to write JSON file", e.getMessage());
        }
    }

    private synchronized void setValue(Map<String, Object> jsonMap, String @NotNull [] keys, Object value) {
        Map currentMap = jsonMap;
        for (int i = 0; i < keys.length - 1; ++i) {
            currentMap = (Map)currentMap.get(keys[i]);
        }
        currentMap.put(keys[keys.length - 1], value);
    }

    @Nullable
    public synchronized Object read(@NotNull String key) {
        try {
            String[] keyParts;
            JSONParser parser = new JSONParser(4032);
            Object current = parser.parse((Reader)new FileReader(this.PATH + this.FILE + ".json"));
            for (String k : keyParts = key.split("\\.")) {
                if (!(current instanceof JSONObject)) {
                    BP.fancyLog(this.className, "read", "Key '" + k + "' is not a valid JSON object");
                    return null;
                }
                JSONObject jsonObj = (JSONObject)current;
                current = jsonObj.get((Object)k);
                if (current != null) continue;
                BP.fancyLog(this.className, "read", "No key found: " + k);
                return null;
            }
            return current;
        }
        catch (IOException | ParseException e) {
            BP.fancyLog(this.className, "read", "Failed to read JSON file");
            return null;
        }
    }

    @Nullable
    private synchronized Object readObject(String key) {
        try {
            JSONParser parser = new JSONParser(4032);
            Object current = parser.parse((Reader)new FileReader(this.PATH + this.FILE + ".json"));
            if (!(current instanceof JSONObject)) {
                BP.fancyFileLog(this.className, "readObject", "is not a valid JSON object: " + key);
                return null;
            }
            JSONObject jsonNested = (JSONObject)current;
            current = jsonNested.get((Object)key);
            if (current == null) {
                BP.fancyFileLog(this.className, "readObject", "is not a valid JSON object: " + key);
                return null;
            }
            return current;
        }
        catch (IOException | ParseException e) {
            BP.fancyLog(this.className, "readObject", "Failed to read JSON file: ", e.getMessage());
            return null;
        }
    }

    public synchronized String readString(String keys) {
        Object result = this.read(keys);
        if (result == null) {
            return BP.Return.fancyLog(this.className, "readString", "No key string found");
        }
        Object object = result;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, JSONObject.class}, (Object)object2, n)) {
            case 0 -> {
                String s;
                yield s = (String)object2;
            }
            case 1 -> {
                JSONObject jsonObject = (JSONObject)object2;
                yield jsonObject.toJSONString();
            }
            default -> String.valueOf(result);
        };
    }

    public synchronized byte readByte(String keys) {
        Object result = this.read(keys);
        if (result instanceof Integer) {
            return ((Integer)result).byteValue();
        }
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        BP.fancyLog(this.className, "readByte", "something went wrong");
        return 0;
    }

    public synchronized short readShort(String keys) {
        Object result = this.read(keys);
        if (result instanceof Integer) {
            return ((Integer)result).shortValue();
        }
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        BP.fancyLog(this.className, "readShort", "something went wrong");
        return 0;
    }

    public synchronized int readInt(String keys) {
        Object result = this.read(keys);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        BP.fancyLog(this.className, "readInt", "something went wrong");
        return 0;
    }

    public float readFloat(String keys) {
        Object result = this.read(keys);
        if (result instanceof Integer) {
            return ((Integer)result).floatValue();
        }
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        BP.fancyLog(this.className, "readFloat", "something went wrong");
        return 0.0f;
    }

    public boolean readBoolean(String keys) {
        Object result = this.read(keys);
        if (result != null) {
            return (Boolean)result;
        }
        BP.fancyLog(this.className, "readBoolean", "Boolean value from readBoolean is null...\n switched to false!");
        return false;
    }

    @NotNull
    public synchronized Object nestObject(List<String> keys, List<Object> values) {
        FileUtils.checkJSONArgsLength(keys, values, "nestObject");
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < keys.size(); ++i) {
            jsonObject.put((Object)keys.get(i), values.get(i));
        }
        return jsonObject;
    }

    @NotNull
    public synchronized JSONArray writeList(List<Object> values) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(values);
        return jsonArray;
    }

    private synchronized void replaceListValue(String searchKey, Object newValue, String ... listKeys) {
        try {
            Map map;
            Map jsonMap;
            File jsonFile = new File(this.PATH + this.FILE + ".json");
            if (!jsonFile.exists()) {
                BP.fancyFileLog(this.className, "replaceListValue", "JSON file does not exist. No action taken", jsonFile.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            Map listObject = jsonMap = (Map)mapper.readValue(jsonFile, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(this){});
            for (String key : listKeys) {
                if (!(listObject instanceof Map)) {
                    BP.fancyFileLog(this.className, "replaceListValue", "Key is " + key + " not a valid JSON object", jsonFile.getAbsolutePath());
                    return;
                }
                map = listObject;
                listObject = map.get(key);
            }
            if (listObject instanceof List) {
                List list = (List)((Object)listObject);
                boolean updated = false;
                for (Object obj : list) {
                    if (!(obj instanceof Map) || !(map = (Map)obj).containsKey(searchKey)) continue;
                    map.put(searchKey, newValue);
                    updated = true;
                    break;
                }
                if (!updated) {
                    BP.fancyFileLog(this.className, "replaceListValue", "Key " + searchKey + " not found in list " + listKeys[listKeys.length - 1], jsonFile.getAbsolutePath());
                    return;
                }
            } else {
                BP.fancyFileLog(this.className, "replaceListValue", "The key " + listKeys[listKeys.length - 1] + " does not point to a list", jsonFile.getAbsolutePath());
                return;
            }
            mapper.writeValue(jsonFile, (Object)jsonMap);
            BP.fancyFileLog(this.className, "replaceListValue", "The key " + listKeys[listKeys.length - 1] + " does not point to a list", jsonFile.getAbsolutePath());
            BP.LOG.info("Successfully updated the JSON file.");
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "replaceListValue", "Failed to modify JSON file", e.getMessage());
        }
    }

    public synchronized JSONArray readList(String ... keys) {
        try {
            JSONParser parser = new JSONParser(4032);
            Object listObject = parser.parse((Reader)new FileReader(this.PATH + this.FILE + ".json"));
            for (String key : keys) {
                if (!(listObject instanceof JSONObject)) {
                    BP.fancyFileLog(this.className, "readList", "Key is " + key + " not a valid JSON object");
                    return null;
                }
                JSONObject jsonNested = (JSONObject)listObject;
                listObject = jsonNested.get((Object)key);
                if (listObject != null) continue;
                BP.fancyFileLog(this.className, "readList", "No key found: " + key);
                return null;
            }
            if (listObject instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)listObject;
                return jsonArray;
            }
            BP.fancyFileLog(this.className, "readList", "The final object is not a JSONArray");
            return null;
        }
        catch (IOException | ParseException e) {
            BP.fancyLog(this.className, "readList", "Failed to read JSON file", e.getMessage());
            return null;
        }
    }

    public synchronized void delete() {
        Path jsonFile = Paths.get(this.PATH, this.FILE + ".json");
        try {
            Files.delete(jsonFile);
            BP.fancyFileLog(this.className, "delete", "Successfully deleted JSON file", String.valueOf(jsonFile.toAbsolutePath()));
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "delete", "Failed to delete JSON file", String.valueOf(jsonFile.toAbsolutePath()), e.getMessage());
        }
    }

    @NotNull
    private synchronized String xorEncryptAndDecrypt(@NotNull String input, String key) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            output.append((char)(input.charAt(i) ^ key.charAt(i % key.length())));
        }
        return output.toString();
    }

    public synchronized void write_encrypt(List<String> keys, List<Object> values, String encryptKey) {
        FileUtils.checkJSONArgsLength(keys, values, "writeAndEncrypt");
        try {
            File directory = new File(this.PATH);
            if (!directory.exists() && !directory.mkdirs()) {
                BP.fancyFileLog(this.className, "write_encrypt", "Failed to create directory", directory.getAbsolutePath());
                return;
            }
            LinkedHashMap<String, Object> orderedMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                Object value = values.get(i);
                if (value instanceof JSONObject) {
                    value = new ObjectMapper().readValue(value.toString(), Map.class);
                }
                orderedMap.put(keys.get(i), value);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            String jsonString = mapper.writeValueAsString(orderedMap);
            String encryptedJson = this.xorEncryptAndDecrypt(jsonString, encryptKey);
            String fullPath = this.PATH + this.FILE + ".json";
            File outputFile = new File(fullPath);
            BP.LOG.info(((Object)orderedMap).toString());
            File outFile = new File(fullPath);
            Files.writeString(outputFile.toPath(), (CharSequence)encryptedJson, new OpenOption[0]);
            BP.fancyFileLog(this.className, "write_encrypt", "Successfully wrote JSON encrypted file", directory.getAbsolutePath());
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "write_encrypt", "Failed to write encrypted JSON", e.getMessage());
        }
    }

    public synchronized void write_encrypt(List<String> keys, List<Object> values, UpdateMode mode, String encryptionKey) {
        String title = "writeAndEncrypt";
        FileUtils.checkJSONArgsLength(keys, values, title);
        try {
            File directory = new File(this.PATH);
            if (!directory.exists() && !directory.mkdirs()) {
                BP.fancyFileLog(this.className, "write_encrypt", "Failed to create directory", directory.getAbsolutePath());
                return;
            }
            String fullPath = this.PATH + this.FILE + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.fancyFileLog(this.className, "write_encrypt", "File already exists, skipping due to NOTHING mode", fullPath);
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String encryptedContent = new String(Files.readAllBytes(outputFile.toPath()));
                    String decryptedContent = this.xorEncryptAndDecrypt(encryptedContent, encryptionKey);
                    currentData = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<Map<String, Object>>(this){});
                }
                catch (IOException e) {
                    BP.fancyLog(this.className, "write_encrypt", "Could not read existing JSON", e.getMessage());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.fancyFileLog(this.className, "write_encrypt", "No changes detected, skipping write", directory.getAbsolutePath());
                return;
            }
            String jsonString = mapper.writeValueAsString(currentData);
            String encryptedJson = this.xorEncryptAndDecrypt(jsonString, encryptionKey);
            Files.write(outputFile.toPath(), encryptedJson.getBytes(), new OpenOption[0]);
            BP.fancyFileLog(this.className, "write_encrypt", "Successfully wrote JSON encrypted file", directory.getAbsolutePath());
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "write_encrypt", "Failed to write encrypted JSON", e.getMessage());
        }
    }

    public synchronized void write_encrypt(List<String> keys, List<Object> values, UpdateMode mode, List<String> ignoredKeys, String encryptionKey) {
        String title = "write-encrypt";
        FileUtils.checkJSONArgsLength(keys, values, title);
        try {
            File directory = new File(this.PATH);
            if (!directory.exists() && !directory.mkdirs()) {
                BP.fancyFileLog(this.className, "write_encrypt", "Failed to create directory", directory.getAbsolutePath());
                return;
            }
            String fullPath = this.PATH + this.FILE + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.fancyFileLog(this.className, "write_encrypt", "File already exists, skipping due to NOTHING mode", fullPath);
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String encryptedContent = new String(Files.readAllBytes(outputFile.toPath()));
                    String decryptedContent = this.xorEncryptAndDecrypt(encryptedContent, encryptionKey);
                    currentData = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<Map<String, Object>>(this){});
                }
                catch (IOException e) {
                    BP.fancyLog(this.className, "write_encrypt", "Could not read existing JSON", e.getMessage());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                if (ignoredKeys.contains(keys.get(i)) && currentData.containsKey(keys.get(i))) continue;
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.fancyFileLog(this.className, "write_encrypt", "No changes detected, skipping write", fullPath);
                return;
            }
            String jsonString = mapper.writeValueAsString(currentData);
            String encryptedJson = this.xorEncryptAndDecrypt(jsonString, encryptionKey);
            Files.write(outputFile.toPath(), encryptedJson.getBytes(), new OpenOption[0]);
            BP.fancyFileLog(this.className, "write_encrypt", "Successfully wrote JSON encrypted file", directory.getAbsolutePath());
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "write_encrypt", "Failed to write encrypted JSON", e.getMessage());
        }
    }

    @Nullable
    public synchronized Object read(@NotNull String key, String encryptKey) {
        try {
            String[] keyParts;
            String filePath = this.PATH + this.FILE + ".json";
            String encryptedContent = Files.readString(Paths.get(filePath, new String[0]));
            String decryptedContent = this.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            JSONParser parser = new JSONParser(-1);
            Object current = parser.parse(decryptedContent);
            for (String k : keyParts = key.split("\\.")) {
                if (!(current instanceof JSONObject)) {
                    BP.fancyFileLog(this.className, "read", "Key " + k + " is not a valid JSON object");
                    return null;
                }
                JSONObject jsonObj = (JSONObject)current;
                current = jsonObj.get((Object)k);
                if (current != null) continue;
                BP.fancyFileLog(this.className, "read", "Not found key " + k);
                return null;
            }
            return current;
        }
        catch (IOException | ParseException e) {
            BP.fancyLog(this.className, "read", "Failed to read encrypted JSON file", e.getMessage());
            return null;
        }
    }

    @Nullable
    public synchronized Object readObject(String key, @NotNull String encryptKey) {
        try {
            String encryptedContent = Files.readString(Paths.get(this.PATH + this.FILE + ".json", new String[0]));
            String decryptedContent = this.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            JSONParser parser = new JSONParser(4032);
            JSONObject reference = (JSONObject)parser.parse(decryptedContent);
            Object value = reference.get((Object)key);
            if (value == null) {
                BP.fancyFileLog(this.className, "readObject", "Encrypted key not found: " + key);
                return null;
            }
            return value;
        }
        catch (IOException | ParseException e) {
            BP.fancyFileLog(this.className, "readObject", "Failed to read encrypted JSON file: " + e.getMessage());
            return null;
        }
    }

    public synchronized String readString(String keys, String encryptKey) {
        Object result;
        Object object = result = this.read(keys, encryptKey);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, JSONObject.class}, (Object)object, n)) {
            case -1 -> "|readString-Encrypted|";
            case 0 -> {
                String s;
                yield s = (String)object;
            }
            case 1 -> {
                JSONObject jsonObject = (JSONObject)object;
                yield jsonObject.toJSONString();
            }
            default -> String.valueOf(result);
        };
    }

    public synchronized byte readByte(String keys, String encryptKey) {
        Object result = this.read(keys, encryptKey);
        if (result instanceof Integer) {
            return ((Integer)result).byteValue();
        }
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        return 0;
    }

    public synchronized short readShort(String keys, String encryptKey) {
        Object result = this.read(keys, encryptKey);
        if (result instanceof Integer) {
            return ((Integer)result).shortValue();
        }
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        return 0;
    }

    public synchronized int readInt(String keys, String encryptKey) {
        Object result = this.read(keys, encryptKey);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return 0;
    }

    public synchronized float readFloat(String keys, String encryptKey) {
        Object result = this.read(keys, encryptKey);
        if (result instanceof Integer) {
            return ((Integer)result).floatValue();
        }
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        return 0.0f;
    }

    public synchronized boolean readBoolean(String keys, String encryptKey) {
        Object result = this.read(keys, encryptKey);
        if (result != null) {
            return (Boolean)result;
        }
        BP.fancyLog(this.className, "readBoolean", "Boolean value from encrypted readBoolean is null!");
        return false;
    }

    public synchronized void replace(List<String> keys, List<Object> values, String encryptKey) {
        FileUtils.checkJSONArgsLength(keys, values, "replace");
        try {
            File directory = new File(this.PATH);
            File jsonFile = new File(directory, this.FILE + ".json");
            if (!jsonFile.exists()) {
                BP.fancyLog(this.className, "replace", "JSON file does not exist. No action taken.", jsonFile.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(this.SERIALIZATION_OUTPUT_INDENT);
            String encryptedContent = Files.readString(jsonFile.toPath());
            String decryptedContent = this.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            Map jsonMap = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(this){});
            for (int i = 0; i < keys.size(); ++i) {
                String[] keyPath = keys.get(i).split("\\.");
                this.setValue(jsonMap, keyPath, values.get(i));
            }
            String updatedJson = mapper.writeValueAsString((Object)jsonMap);
            String encryptedJson = this.xorEncryptAndDecrypt(updatedJson, encryptKey);
            Files.writeString(jsonFile.toPath(), (CharSequence)encryptedJson, new OpenOption[0]);
            BP.fancyLog(this.className, "replace", "Successfully updated and encrypted JSON file", jsonFile.getAbsolutePath());
        }
        catch (IOException e) {
            BP.fancyLog(this.className, "replace", "Failed to write encrypted JSON file", e.getMessage());
        }
    }
}

