/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.files;

import baspig.apis.utils.files.FileUtils;
import baspig.apis.utils.util.BP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TextFile {
    public static void create(String path, String fileName) {
        for (int i = 1; i > 0; --i) {
            try {
                File myObj = new File(path + "/" + fileName.replaceAll("/", "") + ".txt");
                if (myObj.createNewFile()) {
                    System.out.println("Files created: " + myObj.getName());
                    continue;
                }
                System.out.println("Files already exists.");
                continue;
            }
            catch (IOException e) {
                BP.LOG.info("An error occurred while executing fileWriter: {}\nCaused by: {}", (Object)e.getMessage(), (Object)e.getCause());
            }
        }
    }

    public static String read(String fileToRead) {
        try {
            FileReader reader = new FileReader("config/" + fileToRead.replaceAll("/", "") + ".txt");
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            if (line != null) {
                return line;
            }
            reader.close();
        }
        catch (IOException e) {
            BP.LOG.info("An error occurred while executing fileWriter: {}\nCaused by: {}", (Object)e.getMessage(), (Object)e.getCause());
        }
        return null;
    }

    public static String read(String path, String fileToRead) {
        if (Objects.equals(path, "")) {
            try {
                FileReader reader = new FileReader(path + fileToRead + ".txt");
                BufferedReader bufferedReader = new BufferedReader(reader);
                String line = bufferedReader.readLine();
                if (line != null) {
                    return line;
                }
                reader.close();
            }
            catch (IOException e) {
                BP.LOG.info("An error occurred while executing fileWriter: {}\nCaused by: {}", (Object)e.getMessage(), (Object)e.getCause());
            }
        } else {
            try {
                FileReader reader = new FileReader(path + "/" + fileToRead.replaceAll("/", "") + ".txt");
                BufferedReader bufferedReader = new BufferedReader(reader);
                String line = bufferedReader.readLine();
                if (line != null) {
                    return line;
                }
                reader.close();
            }
            catch (IOException e) {
                BP.LOG.info("An error occurred while executing fileWriter: {}\nCaused by: {}", (Object)e.getMessage(), (Object)e.getCause());
            }
        }
        return null;
    }

    public static void write(String fileToWrite, String textToWrite, boolean append) {
        try {
            File myObj = new File("config/" + fileToWrite.replaceAll("/", "") + ".txt");
            if (myObj.createNewFile()) {
                BP.LOG.info("File created successfully");
            }
            FileWriter writer = new FileWriter("config/" + textToWrite.replaceAll("/", "") + ".txt", append);
            writer.write(textToWrite);
            writer.close();
        }
        catch (IOException e) {
            BP.LOG.info("An error occurred while executing fileWriter: {}\nCaused by: {}", (Object)e.getMessage(), (Object)e.getCause());
        }
    }

    public static void write(String path, String fileToWrite, @NotNull String textToWrite, boolean append) {
        FileUtils.fixPath(path);
        try {
            File myObj = new File(path + "/" + fileToWrite.replaceAll("/", "") + ".txt");
            if (myObj.createNewFile()) {
                BP.LOG.info("|write| File created successfully");
            }
            FileWriter writer = new FileWriter(path + textToWrite.replaceAll("/", "") + ".txt", append);
            writer.write(textToWrite);
            writer.close();
        }
        catch (IOException e) {
            BP.LOG.info("An error occurred while executing fileWriter: {}\nCaused by: {}", (Object)e.getMessage(), (Object)e.getCause());
        }
    }

    public static synchronized void delete(String file) {
        Path txtFile = Paths.get(file + ".txt", new String[0]);
        try {
            Files.delete(txtFile);
            BP.LOG.info("|txt-delete| Successfully deleted file: {}", (Object)txtFile.toAbsolutePath());
        }
        catch (IOException e) {
            BP.LOG.error("|txt-delete| Failed to delete file: {}", (Object)txtFile.toAbsolutePath(), (Object)e);
        }
    }

    public static synchronized void delete(String path, String file) {
        Path txtFile = Paths.get(path, file + ".txt");
        try {
            Files.delete(txtFile);
            BP.LOG.info("|txt-delete | Successfully deleted file: {}", (Object)txtFile.toAbsolutePath());
        }
        catch (IOException e) {
            BP.LOG.error("|txt-delete| Failed to delete file: {}", (Object)txtFile.toAbsolutePath(), (Object)e);
        }
    }
}

