package baspig.apis.utils.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

/**
 * This class is for Render custom images on the client screen menu and more
 * @author Baspig_
 */
@SuppressWarnings("unused")
@Environment(EnvType.CLIENT)
public class GuiTexture {


    /**This method renderers an opaque background texture in the main menu
     * ¡It doesn't override any texture!
     * @param context You must provide the DrawContext in the caller method
     * @param modId this is the mod-id for the texture path
     * @param texturePath This the texture file path. E.g: "gui/especial_image_file"
     */
    public static void renderBackgroundOpaque(class_332 context, String modId,String texturePath){
        class_310 client = class_310.method_1551();
        class_2960 texture = class_2960.method_60655(modId, "textures/"+ texturePath + ".png");

        int x = 0;
        int y = 0;
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();

        context.method_25290((id) -> class_1921.method_62276(texture),
                texture, x, y, 1,1, width, height, width + 1,height + 1 );
    }

    /**This method renderers an opaque background texture in the main menu
     * ¡It doesn't override any texture!
     * @param context You must provide the DrawContext in the caller method
     * @param modId this is the mod-id for the texture path
     * @param texturePath This the texture file path. E.g: "gui/especial_image_file"
     */
    public static void renderBackgroundOpaque(class_332 context, String modId,String texturePath, short x, short y, short Max_x, short Max_y){
        class_2960 texture = class_2960.method_60655(modId, "textures/"+ texturePath + ".png");
        context.method_25290((id) -> class_1921.method_62276(texture),
                texture, x, y, 1,1, Max_x, Max_y, Max_x + 1,Max_y + 1 );
    }

    /**This method renderers a background texture in the main menu
     * ¡It doesn't override any texture!
     * @param context You must provide the DrawContext in the caller method
     * @param modId this is the mod-id for the texture path
     * @param texturePath This the texture file path. E.g: "gui/especial_image_file"
     */
    public static void renderBackground(class_332 context, String modId,String texturePath){
        class_2960 texture = class_2960.method_60655(modId, "textures/"+ texturePath + ".png");
        class_310 client = class_310.method_1551();

        int x = 0;
        int y = 0;
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();

        context.method_25290((id) -> class_1921.method_62277(texture),
                texture, x, y, 1,1, width, height, width + 1,height + 1 );
    }

    /**This method renderers a background texture in the main menu
     * ¡It doesn't override any texture!
     * @param context You must provide the DrawContext in the caller method
     * @param modId this is the mod-id for the texture path
     * @param texturePath This the texture file path. E.g: "gui/especial_image_file"
     * @param x is the x start point texture size, 0 = left top screen border
     * @param y is the y start point texture size, 0 = left top screen border
     * @param Max_x is the x max point texture size
     * @param Max_y is the y max point texture size
     */
    public static void renderBackground(class_332 context, String modId,String texturePath, short x, short y, short Max_x, short Max_y){
        class_2960 texture = class_2960.method_60655(modId, "textures/"+ texturePath + ".png");
        context.method_25290((id) -> class_1921.method_62277(texture),
                texture, x, y, 1,1, Max_x, Max_y, Max_x + 1,Max_y + 1 );
    }

    /**This method renderers a background texture in the main menu
     * ¡It doesn't override any texture!
     * @param context You must provide the DrawContext in the caller method
     * @param modId this is the mod-id for the texture path
     * @param texturePath This the texture file path. E.g: "gui/especial_image_file"
     * @param x is the x start point texture size, 0 = left top screen border
     * @param y is the y start point texture size, 0 = left top screen border
     * @param Max_x is the x max point texture size
     * @param Max_y is the y max point texture size
     * @param customRenderLayer It's which vanilla render layer you want to use for the texture rendering
     */
    public static void renderBackground(class_332 context, String modId,String texturePath, short x, short y, short Max_x, short Max_y, class_1921 customRenderLayer){
        class_2960 texture = class_2960.method_60655(modId, "textures/"+ texturePath + ".png");
        context.method_25290((id) -> customRenderLayer,
                texture, x, y, 1,1, Max_x, Max_y, Max_x + 1,Max_y + 1 );
    }
}
