package baspig.apis.utils.events.block;

import baspig.apis.utils.events.item.ItemEvents;
import baspig.apis.utils.register.tags.ExtraItemTags;
import baspig.apis.utils.util.ParticleVelocityType;
import baspig.apis.utils.util.ShapeType;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**This class gives you some easy config block events
 * @author Baspig_
 */
@SuppressWarnings("unused")
public class BlockEvents {
    static Random random = new Random();


    /**
     * Spawns a number of particles at random positions outside the block position.
     *
     * @param world The server world in which the particles are to be spawned. Must not be null.
     * @param particle The particle effect to spawn.
     * @param pos The block position inside which the particles will be spawned.
     * @param count The number of particles per tick to spawn.
     * @param spread The area around the block where particles will be added
     */
    public static void spawnParticles(@NotNull class_1937 world, class_2394 particle, class_2338 pos, int count, double spread) {
        net.minecraft.class_5819 random = world.method_8409();

        for (int i = 0; i < count; i++) {

            class_2350 face = class_2350.values()[random.method_43048(6)];

            double x = pos.method_10263() + 0.5 + face.method_10148() * 0.51 + (face.method_10148() == 0 ? (random.method_43058() - 0.5) * spread : 0);
            double y = pos.method_10264() + 0.5 + face.method_10164() * 0.51 + (face.method_10164() == 0 ? (random.method_43058() - 0.5) * spread : 0);
            double z = pos.method_10260() + 0.5 + face.method_10165() * 0.51 + (face.method_10165() == 0 ? (random.method_43058() - 0.5) * spread : 0);

            world.method_8406(particle, x, y, z, 0, 0, 0);

        }
    }

    /**
     * Spawns a number of particles at random positions outside the block position.
     *
     * @param world The server world in which the particles are to be spawned. Must not be null.
     * @param particle The particle effect to spawn.
     * @param pos The block position inside which the particles will be spawned.
     * @param count The number of particles per tick to spawn.
     * @param spread The area around the block where particles will be added
     * @param velocityType Type of particle velocity.
     * @param velocityX Initial particle X velocity, it may be affected by particle behavior.
     * @param velocityY Initial particle Y velocity, it may be affected by particle behavior.
     * @param velocityZ Initial particle Z velocity, it may be affected by particle behavior.
     */
    public static void spawnParticles(@NotNull class_1937 world,
                                      class_2394 particle,
                                      class_2338 pos, int count, double spread, ParticleVelocityType velocityType, float velocityX, float velocityY, float velocityZ) {
        net.minecraft.class_5819 random = world.method_8409();

        for (int i = 0; i < count; i++) {
            class_2350 face = class_2350.values()[random.method_43048(6)];

            double x = pos.method_10263() + 0.5 + face.method_10148() * 0.51 + (face.method_10148() == 0 ? (random.method_43058() - 0.5) * spread : 0);
            double y = pos.method_10264() + 0.5 + face.method_10164() * 0.51 + (face.method_10164() == 0 ? (random.method_43058() - 0.5) * spread : 0);
            double z = pos.method_10260() + 0.5 + face.method_10165() * 0.51 + (face.method_10165() == 0 ? (random.method_43058() - 0.5) * spread : 0);

            double velocity;

            float XVelocity = 0;
            float YVelocity = 0;
            float ZVelocity = 0;

            switch (velocityType){
                case CUSTOM:
                    XVelocity = velocityX;
                    YVelocity = velocityY;
                    ZVelocity = velocityZ;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case RANDOM:
                    XVelocity = (-random.method_43057() + random.method_43057());
                    YVelocity = (-random.method_43057() + random.method_43057());
                    ZVelocity = (-random.method_43057() + random.method_43057());
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case UPWARD:
                    YVelocity = 0.25F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case UPWARD_SLOW:
                    YVelocity = 0.05F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case UPWARD_CUSTOM_VELOCITY:
                    YVelocity = velocityY;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;

                case DOWNWARD:
                    YVelocity = -0.25F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case DOWNWARD_SLOW:
                    YVelocity = -0.05F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case DOWNWARD_CUSTOM_VELOCITY:
                    YVelocity = -velocityY;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;

                case EASTWARD:
                    XVelocity = 0.25F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case EASTWARD_SLOW:
                    XVelocity = 0.05F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case EASTWARD_CUSTOM_VELOCITY:
                    XVelocity = velocityX;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;

                case WESTWARD:
                    XVelocity = -0.25F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case WESTWARD_SLOW:
                    XVelocity = -0.05F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case WESTWARD_CUSTOM_VELOCITY:
                    XVelocity = -velocityX;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;

                case SOUTHWARD:
                    ZVelocity = 0.25F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case SOUTHWARD_SLOW:
                    ZVelocity = 0.05F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case SOUTHWARD_CUSTOM_VELOCITY:
                    ZVelocity = velocityX;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;

                case NORTHWARD:
                    ZVelocity = -0.25F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case NORTHWARD_SLOW:
                    ZVelocity = -0.05F;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
                case NORTHWARD_CUSTOM_VELOCITY:
                    ZVelocity = -velocityX;
                    world.method_8406(particle, x, y, z, XVelocity, YVelocity, ZVelocity);
                    break;
            }
        }
    }

    /**
     * Spawns particles in various shapes at block position. The shape, size, and number of particles can be customized.
     *
     * @param world The world where the particles will be spawned.
     * @param particle The particle effect to spawn.
     * @param pos The position of the shape where the particles will spawn, by default aligns in the block center.
     * @param count The number of particles to spawn.
     * @param shape The shape in which the particles will spawn.
     * @param radius The radius of the shape for particle spawning.<p>
     * @param height The height of the shape. Height argument is only for CYLINDER, it will be skipped if another shape is selected.<p>
     * @param offset The positional offset to be applied from the provided center position.
     */
    @Deprecated(forRemoval = true)
    public static void spawnShapeParticles(@NotNull class_1937 world, @NotNull class_2394 particle, class_2338 pos, /// Pos is the center of the shape
                                           int count, @NotNull ShapeType shape,
                                           float radius,
                                           float height,
                                           class_2338 offset) {
        net.minecraft.class_5819 random = world.method_8409();

        double X;
        double Y;
        double Z;

        for (int i = 0; i < count; i++) {

            double theta = random.method_43058() * 2 * Math.PI;
            double phi = Math.acos(2 * random.method_43058() - 1);

            double sphere_radius = Math.cbrt(random.method_43058()) * radius;

            double cylinder_height = random.method_43058() * height;

            double cylinder_radius = Math.sqrt(random.method_43058()) * radius;

            float size = radius + radius;

            double xOffset = (random.method_43058() - 0.5) * size;
            double yOffset = (random.method_43058() - 0.5) * size;
            double zOffset = (random.method_43058() - 0.5) * size;

            switch (shape){
                case CIRCLE:

                    X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;

                case CIRCLE_OUTLINE:
                    X = pos.method_10263() + 0.5 + radius * Math.cos(theta);
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + radius * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;

                case SPHERE:
                    X = pos.method_10263() + 0.5 + sphere_radius * Math.sin(phi) * Math.cos(theta);
                    Y = pos.method_10264() + 0.5 + sphere_radius * Math.cos(phi);
                    Z = pos.method_10260() + 0.5 + sphere_radius * Math.sin(phi) * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case SPHERE_OUTLINE:
                    double r = Math.sqrt(random.method_43058()) * radius; ///Fill the sphere

                    X = pos.method_10263() + 0.5 + r * Math.cos(theta);
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + r * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;

                case CYLINDER:

                    X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    Y = pos.method_10264() + 0.5 - (height/2) + cylinder_height;
                    Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case CYLINDER_OUTLINE:

                    double angle = random.method_43058() * 2 * Math.PI;

                    byte side = (byte) random.method_43048(3);

                    if (side == 0) {
                        // DOWN face
                        X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = pos.method_10264() + 0.5 - (height / 2);
                        Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else if (side == 1) {
                        // UP face
                        X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = pos.method_10264() + 0.5 + (height / 2);
                        Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else {
                        // Circle outline
                        double yHeight = pos.method_10264() + 0.5 - (height / 2) + random.method_43058() * height;
                        X = pos.method_10263() + 0.5 + radius * Math.cos(angle);
                        Y = yHeight;
                        Z = pos.method_10260() + 0.5 + radius * Math.sin(angle);
                    }

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case SQUARE:

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case SQUARE_OUTLINE:
                    double edge = random.method_43058() * size - size / 2;

                    if (random.method_43056()) {

                        xOffset = (random.method_43056() ? size / 2 : -size / 2);
                        zOffset = edge;
                    } else {

                        xOffset = edge;
                        zOffset = (random.method_43056() ? size / 2 : -size / 2);
                    }

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case CUBE:

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5 + yOffset;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case CUBE_OUTLINE:
                    int axis = random.method_43048(3);
                    double fixed = (random.method_43056() ? size / 2 : -size / 2);

                    if (axis == 0) {
                        xOffset = fixed;
                        yOffset = (random.method_43058() - 0.5) * size;
                        zOffset = (random.method_43058() - 0.5) * size;
                    } else if (axis == 1) {
                        yOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * size;
                        zOffset = (random.method_43058() - 0.5) * size;
                    } else {
                        zOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * size;
                        yOffset = (random.method_43058() - 0.5) * size;
                    }

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5 + yOffset;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
            }

        }
    }

    /**
     * Spawns particles in various shapes at block position. The shape, size, and number of particles can be customized.
     *
     * @param world The world where the particles will be spawned.
     * @param particleSettings The Settings of the shape to be added.
     */
    public static void spawnShapeParticles(@NotNull class_1937 world, @NotNull ParticleSettings particleSettings) {
        net.minecraft.class_5819 random = world.method_8409();

        double X;
        double Y;
        double Z;

        int count = particleSettings.getAmount();

        double radius = particleSettings.getRadius();
        double height = particleSettings.getHeight();

        ShapeType shape = particleSettings.getShapeType();

        class_2338 pos = particleSettings.getBlockPos();

        class_2394 particle = particleSettings.getParticleEffect();

        for (int i = 0; i < count; i++) {

            double theta = particleSettings.getSpecialTheta();
            double phi = particleSettings.getSpecialPhi();

            double sphere_uniform = particleSettings.getCubicRadiusScaling();

            double cylinder_height = random.method_43058() * height;

            double cylinder_radius = Math.sqrt(random.method_43058()) * radius;

            double size = particleSettings.getDiameter();

            double xOffset = particleSettings.getArea();
            double yOffset = particleSettings.getArea();
            double zOffset = particleSettings.getArea();

            switch (shape){
                case CIRCLE:
                    X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;

                case CIRCLE_OUTLINE:
                    X = pos.method_10263() + 0.5 + radius * Math.cos(theta);
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + radius * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;

                case SPHERE:

                    X = pos.method_10263() + 0.5 + sphere_uniform * Math.sin(phi) * Math.cos(theta);
                    Y = pos.method_10264() + 0.5 + sphere_uniform * Math.cos(phi);
                    Z = pos.method_10260() + 0.5 + sphere_uniform * Math.sin(phi) * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case SPHERE_OUTLINE:

                    X = pos.method_10263() + 0.5 + radius * Math.sin(phi) * Math.cos(theta);
                    Y = pos.method_10264() + 0.5 + radius * Math.cos(phi);
                    Z = pos.method_10260() + 0.5 + radius * Math.sin(phi) * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;

                case CYLINDER:

                    X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    Y = pos.method_10264() + 0.5 - (height/2) + cylinder_height;
                    Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case CYLINDER_OUTLINE:

                    double angle = random.method_43058() * 2 * Math.PI;

                    byte side = (byte) random.method_43048(90);

                    if (side <= 25) {
                        // DOWN face
                        X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = pos.method_10264() + 0.5 - (height / 2);
                        Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else if (side <= 50) {
                        // UP face
                        X = pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = pos.method_10264() + 0.5 + (height / 2);
                        Z = pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else {
                        // Circle outline
                        double yHeight = pos.method_10264() + 0.5 - (height / 2) + random.method_43058() * height;
                        X = pos.method_10263() + 0.5 + radius * Math.cos(angle);
                        Y = yHeight;
                        Z = pos.method_10260() + 0.5 + radius * Math.sin(angle);
                    }

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case SQUARE:

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case SQUARE_OUTLINE:
                    double edge = random.method_43058() * size - size / 2;

                    if (random.method_43056()) {

                        xOffset = (random.method_43056() ? size / 2 : -size / 2);
                        zOffset = edge;
                    } else {

                        xOffset = edge;
                        zOffset = (random.method_43056() ? size / 2 : -size / 2);
                    }

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case CUBE:

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5 + yOffset;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
                case CUBE_OUTLINE:
                    int axis = random.method_43048(3);
                    double fixed = (random.method_43056() ? size / 2 : -size / 2);

                    if (axis == 0) {
                        xOffset = fixed;
                        yOffset = (random.method_43058() - 0.5) * size;
                        zOffset = (random.method_43058() - 0.5) * size;
                    } else if (axis == 1) {
                        yOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * size;
                        zOffset = (random.method_43058() - 0.5) * size;
                    } else {
                        zOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * size;
                        yOffset = (random.method_43058() - 0.5) * size;
                    }

                    X = pos.method_10263() + 0.5 + xOffset;
                    Y = pos.method_10264() + 0.5 + yOffset;
                    Z = pos.method_10260() + 0.5 + zOffset;

                    world.method_8406(particle, X, Y, Z, 0, 0, 0);
                    break;
            }

        }
    }


        /**
         * Checks if the block in any direction isn't the specified block.
         * <p>
         *
         * It is unnecessary while {@link #nextBlockIs} exists. It won't be documented on GitHub Wiki.
         *
         * @param world The world in which the check is performed.
         * @param pos The position to check adjacent blocks from.
         * @param block The block to compare against adjacent blocks.
         * @return True if at least one adjacent block is not the same as the specified block, false otherwise.
         */
    public static boolean nextBlockIsExcept(class_1937 world, class_2338 pos, class_2248 block) {
        class_2338[] directions = {
                pos.method_10084(),
                pos.method_10074(),
                pos.method_10095(),
                pos.method_10072(),
                pos.method_10078(),
                pos.method_10067()
        };

        for (class_2338 adjacentPos : directions) {
            if (!world.method_8608() && world.method_8320(adjacentPos).method_26204() != block) {
                return true;
            }
        }

        return false;
    }

    /**
     * Checks if the block in the specified direction isn't the specified block.
     *
     * @param world the world in which the block is located
     * @param pos the position of the current block
     * @param block the block that is compared against
     * @param direction the direction in which to check for a block
     * @return true if the block in the specified direction is not the same as the given block, false otherwise
     */
    public static boolean nextBlockIsExcept(class_1937 world, class_2338 pos, class_2248 block, class_2350 direction) {
        return switch (direction) {
            case field_11036 -> world.method_8320(pos.method_10069(0, 1, 0)).method_26204() != block;
            case field_11033 -> world.method_8320(pos.method_10069(0, -1, 0)).method_26204() != block;
            case field_11043 -> world.method_8320(pos.method_10069(0, 0, 1)).method_26204() != block;
            case field_11035 -> world.method_8320(pos.method_10069(0, 0, -1)).method_26204() != block;
            case field_11034 -> world.method_8320(pos.method_10069(1, 0, 0)).method_26204() != block;
            case field_11039 -> world.method_8320(pos.method_10069(-1, 0, 0)).method_26204() != block;
        };
    }


    /**
     * Checks if the specified block exists in any of the six adjacent positions <p>
     * (up, down, north, south, east, west) relative to the given position in the world.
     *
     * @param world the world in which the block check is performed
     * @param pos the position around which to check for the specified block
     * @param block the block to check for in the adjacent positions
     * @return true if the specified block is found in one of the adjacent positions; false otherwise
     */
    public static boolean nextBlockIs(class_1937 world, class_2338 pos, class_2248 block){
        class_2338[] directions = {
                pos.method_10084(),
                pos.method_10074(),
                pos.method_10095(),
                pos.method_10072(),
                pos.method_10078(),
                pos.method_10067()
        };

        for (class_2338 adjacentPos : directions) {
            if (!world.method_8608() && world.method_8320(adjacentPos).method_26204() == block) {
                return true;
            }
        }
        return false;
    }


    /**
     * Checks if the block in the specified direction from the given position is the specified block.
     *
     * @param world the world in which the block is located
     * @param pos the position of the current block
     * @param block the block that is compared against
     * @param direction the direction in which to check for a block
     * @return true if the block in the specified direction is not the same as the given block, false otherwise
     */
    public static boolean nextBlockIs(class_1937 world, class_2338 pos, class_2248 block, class_2350 direction) {
        return switch (direction) {
            case field_11036 -> world.method_8320(pos.method_10069(0, 1, 0)).method_26204() == block;
            case field_11033 -> world.method_8320(pos.method_10069(0, -1, 0)).method_26204() == block;
            case field_11043 -> world.method_8320(pos.method_10069(0, 0, 1)).method_26204() == block;
            case field_11035 -> world.method_8320(pos.method_10069(0, 0, -1)).method_26204() == block;
            case field_11034 -> world.method_8320(pos.method_10069(1, 0, 0)).method_26204() == block;
            case field_11039 -> world.method_8320(pos.method_10069(-1, 0, 0)).method_26204() == block;
        };
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * */
    public static void dropItemOnBlockBreak(@NotNull class_2248 block,@NotNull class_1792 item, class_6862<class_1792> toolTag){

        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, 100, 1, false, 1,false));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     */
    public static void dropItemOnBlockBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, 1, false, 1,false));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will dropv
     */
    public static void dropItemOnBlockBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount){

        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, false, amount,false));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will drop
     * @param randomDrops make the block drop a random amount
     */
    public static void dropItemOnBlockBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops){

        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, amount,false));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will drop
     * @param randomDrops make the block drop a random amount
     * @param minDrop Minimum amount of items that will be dropped
     */
    public static void dropItemOnBlockBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, minDrop,false));
    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     */
    private static void dropItemOnBlockBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag,  float rate){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, 1, false, 1,false));
    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will drop
     */
    private static void dropItemOnBlockBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, false, 1,false));
    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will drop
     * @param randomDrops make the block drop a random amount
     */
    private static void dropItemOnBlockBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, 1,false));
    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will drop
     * @param randomDrops make the block drop a random amount
     * @param minDrop Minimum amount of items that will be dropped
     */
    private static void dropItemOnBlockBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, minDrop,false));
    }


    /// ----------------------------------------------------------------------------------------------------------------
    /**
     * @param world It's the world that will be executing this method
     * @param pos Is the block position
     * @param isRaining Check if raining at block
     * @param skyVisible Check if sky visible for the block
     * @param biomeHasPrecipitation Check if actual biome has precipitation
     * @return It returns true if its raining, the sky is visible and if the biome has precipitation
     */
    public static boolean isRainingOnBlock(@NotNull class_3218 world, class_2338 pos, boolean isRaining, boolean skyVisible, boolean biomeHasPrecipitation) {
        return world.method_8419() == isRaining &&
                world.method_8311(pos) == skyVisible &&
                world.method_23753(pos).comp_349().method_48163() == biomeHasPrecipitation;
    }

    /**
     * @param world It's the world that will be executing this method
     * @param pos Is the block position
     * @return It returns true if it's raining, the sky is visible and if the biome has precipitation
     */
    public static boolean isRainingOnBlock(@NotNull class_3218 world, class_2338 pos) {
        return world.method_8419()
                && world.method_8311(pos)
                && world.method_23753(pos).comp_349().method_48163();
    }

    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     */
    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire) {
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, class_1937.class_7867.field_40891);
    }

    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param sourceType Type of source that the explosion will use
     */
    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire, class_1937.class_7867 sourceType) {
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, sourceType);
    }
    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     */
    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if(replaceSourceBlockWithAir){
            world.method_8501(pos, class_2246.field_10124.method_9564());}
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, class_1937.class_7867.field_40891);
    }

    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     * @param sourceType Type of source that the explosion will use
     */
    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if(replaceSourceBlockWithAir){
            world.method_8501(pos, class_2246.field_10124.method_9564());}
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, sourceType);
    }

    /**
     * @param world Current world that the block will explode
     * @param x Explosion position, x position
     * @param y Explosion position, y position
     * @param z Explosion position, z position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     */
    public static void explode(@NotNull class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if(replaceSourceBlockWithAir){
            world.method_8501(new class_2338((int) x,(int) y,(int) z), class_2246.field_10124.method_9564());}
        world.method_8537(null, x + 0.5f, y + 0.4f, z + 0.5f, explosionPower, true, class_1937.class_7867.field_40891);
    }

    /**
     * @param world Current world that the block will explode
     * @param x Explosion position, x position
     * @param y Explosion position, y position
     * @param z Explosion position, z position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     * @param sourceType Type of source that the explosion will use
     */
    public static void explode(@NotNull class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if(replaceSourceBlockWithAir){
            world.method_8501(new class_2338((int) x,(int) y,(int) z), class_2246.field_10124.method_9564());}
        world.method_8537(null, x + 0.5f, y + 0.4f, z + 0.5f, explosionPower, true, sourceType);
    }

    /// ----------------------------------------------------------------------------------------------------------------
    private static final Map<class_2248, AdvancedDropSettings> blockDropSettings = new HashMap<>();

    /**
     * !!DO NOT USE, THIS MAY CAUSE YOUR MOD AND OTHER TO MALFUNCTION!!
     */
    public static void DestroyEvent() {
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> {
            class_2248 block = blockState.method_26204();

            if (blockDropSettings.containsKey(block)) {
                AdvancedDropSettings settings = blockDropSettings.get(block);
                if (random.nextFloat() * 100 < settings.rate) {

                    if(playerEntity.method_6047().method_31573(settings.toolTag) || settings.toolTag == ExtraItemTags.NO_TOOL_LEVEL){
                        int extra = (settings.quantity > settings.minDrop) ? random.nextInt(settings.quantity - settings.minDrop) : 0;
                        int dropAmount = settings.randomDrops ? settings.minDrop + extra : settings.minDrop;

                        if(playerEntity instanceof class_3222 && settings.dropsOnCreative && (playerEntity).method_7337()){
                            for (int i = 0; i < dropAmount; i++) {
                                ItemEvents.createWorldItem(world, blockPos, settings.item.method_7854());
                            }
                        }
                        if(playerEntity instanceof class_3222 && !settings.dropsOnCreative && !(playerEntity).method_7337()){
                            for (int i = 0; i < dropAmount; i++) {
                                ItemEvents.createWorldItem(world, blockPos, settings.item.method_7854());
                            }
                        }
                    }
                }
            }
        });
    }

    private static class AdvancedDropSettings {
        class_1792 item;
        class_6862<class_1792> toolTag;
        float rate;
        int quantity;
        boolean randomDrops;
        int minDrop;
        boolean dropsOnCreative;

        AdvancedDropSettings(class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop, boolean dropsOnCreative) {
            this.item = item;
            this.toolTag = toolTag;
            this.rate = rate;
            this.quantity = amount;
            this.randomDrops = randomDrops;
            this.minDrop = minDrop;
            this.dropsOnCreative = dropsOnCreative;
        }
    }
    /// ----------------------------------------------------------------------------------------------------------------
}
