package baspig.apis.utils.register;

import baspig.apis.utils.Baspig_utils;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import java.util.List;

/**
 * @author Baspig_
 * This class is made for fast and easier creative inventory registry. <p>
 * Atention: it MAY be NOT complatible with any inventory tab management or external mixing modifier.
 */
@SuppressWarnings("unused")
public class GroupTabRegister {
    private final String translatableText;
    private final class_1792 tabIcon;
    private final List<class_1799> listItems;
    private final class_5321<class_1761> customItemGroupKey;
    private final class_1761 customItemGroup;

    private GroupTabRegister(@NotNull String mod_id, String tabName, class_1792 tabIcon, List<class_1799> itemsToAdd, byte tabNumber) {
        String modId = mod_id + tabNumber;
        this.translatableText = tabName;
        this.tabIcon = tabIcon;
        this.listItems = itemsToAdd;

        this.customItemGroupKey = class_5321.method_29179(
                class_7923.field_44687.method_46765(),
                class_2960.method_60655(modId, "item_group")
        );

        this.customItemGroup = FabricItemGroup.builder()
                .method_47320(() -> new class_1799(this.tabIcon))
                .method_47321(class_2561.method_43471(this.translatableText))
                .method_47324();
    }

    public void register() {

        Baspig_utils.LOGGER.info("Adding Tab: {}", translatableText);

        class_2378.method_39197(class_7923.field_44687, customItemGroupKey, customItemGroup);
        ItemGroupEvents.modifyEntriesEvent(customItemGroupKey).register(itemGroup -> itemGroup.method_45423(listItems));
    }

    /**This class add your items to a creative inventory tab.
     * @param mod_id Your mod-id
     * @param tabName the name of the tab.
     * @param tabIcon The icon item that will be shown in the tab
     * @param itemsToAdd A list of items that will be added to this specific tab
     * @param tabNumber This handles up to 256 unique tabs per mod-id (-128 to 127), you must choose one id per tab.
     *                  This is important, because you can't add more than one tab with the same mod-id
     *                  But this already handles it
     */
    public static void create(String mod_id, String tabName, class_1792 tabIcon,List<class_1799> itemsToAdd, byte tabNumber) {
        new GroupTabRegister(mod_id, tabName, tabIcon, itemsToAdd, tabNumber).register();
    }
}
