package baspig.apis.utils.util;

import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;


@SuppressWarnings("unused")
public class DimensionData {

    /**
     * Checks if the given Dimension parameter corresponds to the dimension of the provided. `ServerWorld`.
     *
     * @param dimension    The target dimension to check against (e.g., OVERWORLD, NETHER, END).
     * @param serverWorld  The server world whose dimension is to be validated.
     * @return true if the specified `dimension` matches the dimension of the `serverWorld`, otherwise false.
     */
    public static boolean checkIf(Dimension dimension, class_3218 serverWorld){
        class_5321<class_1937> dimensionKey = serverWorld.method_27983();

        return dimensionKey == class_1937.field_25179 && dimension == Dimension.OVERWORLD ||
                dimensionKey == class_1937.field_25180 && dimension == Dimension.NETHER ||
                dimensionKey == class_1937.field_25181 && dimension == Dimension.END;
    }

    /**
     * Checks if the given Dimension parameter corresponds to the dimension of the provided. `World`.
     *
     * @param dimension    The target dimension to check against (e.g., OVERWORLD, NETHER, END).
     * @param world  The server world whose dimension is to be validated.
     * @return true if the specified `dimension` matches the dimension of the `serverWorld`, otherwise false.
     */
    public static boolean checkIf(Dimension dimension, class_1937 world){
        class_5321<class_1937> dimensionKey = world.method_27983();

        return dimensionKey == class_1937.field_25179 && dimension == Dimension.OVERWORLD ||
                dimensionKey == class_1937.field_25180 && dimension == Dimension.NETHER ||
                dimensionKey == class_1937.field_25181 && dimension == Dimension.END;
    }

    /**
     * Checks if the dimension in the given world has skylight.
     *
     * @param world The current world to check the dimension
     * @return True if it has skylight, false if not
     */
    public static boolean hasSkyLight(class_1937 world){
        return world.method_8597().comp_642();
    }

    /**
     * Checks if the dimension in the given world has ceiling.
     *
     * @param world The current world to check the dimension
     * @return True if it has ceiling, false if not
     */
    public static boolean hasCeiling(class_1937 world){
        return world.method_8597().comp_643();
    }

    /**
     * Checks if the dimension in the given world the beds work (Do not explode).
     *
     * @param world The current world to check the dimension
     * @return True if the beds work in it, false if it doesn't
     */
    public static boolean bedWorks(class_1937 world){
        return world.method_8597().comp_648();
    }

    /**
     * Checks if the dimension in the given world is ultra warn dimension.
     *
     * @param world The current world to check the dimension
     * @return True if is ultra warn dimension, false if not.
     */
    public static boolean ultraWarm(class_1937 world){
        return world.method_8597().comp_644();
    }

    /**
     * Checks if the dimension in the given world has raids.
     *
     * @param world The current world to check the dimension
     * @return True if it has raids, false if not
     */
    public static boolean hasRaids(class_1937 world){
        return world.method_8597().method_44221();
    }
}
