package baspig.apis.utils.register;

import baspig.apis.utils.Baspig_utils;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8056;
import net.minecraft.registry.*;
import org.jetbrains.annotations.NotNull;


/**This class is an additions for a faster trim pattern registering.
 * <p>
 * This MAY actually cause problems if you try to modify it later, but I'm not sure.
 *
 * @author Baspig_
 */
@SuppressWarnings("unused")
public class TrimPattern implements DataGeneratorEntrypoint {
    private static String ModID;
    private static boolean Decal;
    private static net.minecraft.class_1792 Item;
    private static class_5321<class_8056> PATTERN_REGISTRY_KEY;
    private static class_5321<class_8056> KEY;

    /**
     * @param mod_id Your mod id.
     * @param patternName Name of the pattern. E.g: "spirit"
     * @param templateItem The base item. IT MUST BE AND SPECIAL ITEM TYPE. <p>
     *                     You must register at first an SmithingTableItem,
     *                     see <a href="https://github.com/BadpigStudios/Baspig-Utils/wiki/Trim-pattern-register">Trim Item Register</a> for more info:
     */
    public TrimPattern(@NotNull String mod_id, @NotNull String patternName, @NotNull class_1792 templateItem){
        Baspig_utils.LOGGER.info("Adding PATTERN: {}...", patternName);
        ModID = mod_id;
        Item = templateItem;
        PATTERN_REGISTRY_KEY = of(patternName);
    }

    private static void bootstrap(class_7891<class_8056> registry) {
        register(registry, Item, PATTERN_REGISTRY_KEY);

    }

    private static void register(class_7891<class_8056> registry, class_1792 item, class_5321<class_8056> key) {
        class_8056 armorTrimPattern = new class_8056(
                key.method_29177(),
                class_7923.field_41178.method_47983(item),
                class_2561.method_43471(class_156.method_646("trim_pattern", key.method_29177())),
                false
        );
        registry.method_46838(key, armorTrimPattern);
    }

    private static class_5321<class_8056> of(String id) {
        assert ModID != null;
        return class_5321.method_29179(class_7924.field_42082, class_2960.method_60655(ModID,id));
    }

    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {}

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_42082, TrimPattern::bootstrap);
    }
}
