package baspig.apis.utils.events.block;

import baspig.apis.utils.events.item.ItemEvents;
import baspig.apis.utils.register.tags.ExtraItemTags;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**This class gives you some easy config block events
 * @author Baspig_
 */
@SuppressWarnings("unused")
public class BlockEvents {
    static Random random = new Random();

    /**
     * @param world Current world
     * @param pos Block position
     * @param block Actual block to compare
     * @return This returns true if it detects a block
     */
    public static boolean nextBlockIs(class_1937 world, class_2338 pos,class_2248 block){
        class_2338[] directions = {
                pos.method_10084(),
                pos.method_10074(),
                pos.method_10095(),
                pos.method_10072(),
                pos.method_10078(),
                pos.method_10067()
        };

        for (class_2338 adjacentPos : directions) {
            if (world.method_8320(adjacentPos).method_26204() == block) {
                return true;
            }
        }
        return false;
    }

    public boolean isBlockInDirection(class_1937 world, class_2338 pos, class_2248 block, class_2350 direction) {
        return switch (direction) {
            case field_11036 -> world.method_8320(pos.method_10069(0, 1, 0)).method_26204() == block;
            case field_11033 -> world.method_8320(pos.method_10069(0, -1, 0)).method_26204() == block;
            case field_11043 -> world.method_8320(pos.method_10069(0, 0, 1)).method_26204() == block;
            case field_11035 -> world.method_8320(pos.method_10069(0, 0, -1)).method_26204() == block;
            case field_11034 -> world.method_8320(pos.method_10069(1, 0, 0)).method_26204() == block;
            case field_11039 -> world.method_8320(pos.method_10069(-1, 0, 0)).method_26204() == block;
        };
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * */
    public static void onBlockDestroyed(@NotNull class_2248 block,@NotNull class_1792 item, class_6862<class_1792> toolTag){

        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, 100, 1, false, 1));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     */
    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, 1, false, 1));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will dropv
     */
    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate, int amount){

        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, false, amount));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will drop
     * @param randomDrops make the block drop a random amount
     */
    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops){

        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, amount));
    }

    /**
     * @param block Is a block that will drop an in item on break
     * @param item Is an item that the block will drop on break
     * @param rate Chance to drop the item
     * @param amount How many items the block will drop
     * @param randomDrops make the block drop a random amount
     * @param minDrop Minimum amount of items that will be dropped
     */
    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop){
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, minDrop));
    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param blocks A list of blocks that will drop an in item on break
     * @param items A list of items that the block will drop on break
     * @param rate Chance to drop the item
     */
    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag,  float rate){

    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param blocks A list of blocks that will drop an in item on break
     * @param items A list of items that the block will drop on break
     * @param rate Chance to drop the item
     * @param quantity How many items the block will drop
     */
    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag, float rate, int quantity){

    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param blocks A list of blocks that will drop an in item on break
     * @param items A list of items that the block will drop on break
     * @param rate Chance to drop the item
     * @param quantity How many items the block will drop
     * @param randomDrops make the block drop a random quantity of max in quantity
     */
    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag, float rate, int quantity, boolean randomDrops){

    }

    /**
     * @param dropsInCreative The item can be dropped in creative mode?
     * @param blocks A list of blocks that will drop an in item on break
     * @param items A list of items that the block will drop on break
     * @param rate Chance to drop the item
     * @param quantity How many items the block will drop
     * @param randomDrops make the block drop a random quantity of max in quantity
     * @param minDrop Minimum amount of items that will be dropped
     */
    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag, float rate, int quantity, boolean randomDrops, int minDrop){

    }

    /// ----------------------------------------------------------------------------------------------------------------
    /**
     * @param world It's the world that will be executing this method
     * @param pos Is the block position
     * @param isRaining Check if raining at block
     * @param skyVisible Check if sky visible for the block
     * @param biomeHasPrecipitation Check if actual biome has precipitation
     * @return It returns true if its raining, the sky is visible and if the biome has precipitation
     */
    public static boolean isRaining(class_3218 world, class_2338 pos, boolean isRaining, boolean skyVisible, boolean biomeHasPrecipitation) {
        return world.method_8419() == isRaining &&
                world.method_8311(pos) == skyVisible &&
                world.method_23753(pos).comp_349().method_48163() == biomeHasPrecipitation;
    }

    /**
     * @param world It's the world that will be executing this method
     * @param pos Is the block position
     * @return It returns true if it's raining, the sky is visible and if the biome has precipitation
     */
    public static boolean isRaining(class_3218 world, class_2338 pos) {
        return world.method_8419()
                && world.method_8311(pos)
                && world.method_23753(pos).comp_349().method_48163();
    }

    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     */
    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire) {
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, class_1937.class_7867.field_40891);
    }

    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param sourceType Type of source that the explosion will use
     */
    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire, class_1937.class_7867 sourceType) {
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, sourceType);
    }
    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     */
    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if(replaceSourceBlockWithAir){
            world.method_8501(pos, class_2246.field_10124.method_9564());}
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, class_1937.class_7867.field_40891);
    }

    /**
     * @param world Current world that the block will explode
     * @param pos Explosion position, block position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     * @param sourceType Type of source that the explosion will use
     */
    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if(replaceSourceBlockWithAir){
            world.method_8501(pos, class_2246.field_10124.method_9564());}
        world.method_8537(null, pos.method_10263() + 0.5f, pos.method_10264() + 0.4f, pos.method_10260() + 0.5f, explosionPower, true, sourceType);
    }

    /**
     * @param world Current world that the block will explode
     * @param x Explosion position, x position
     * @param y Explosion position, y position
     * @param z Explosion position, z position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     */
    public static void explode(class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if(replaceSourceBlockWithAir){
            world.method_8501(new class_2338((int) x,(int) y,(int) z), class_2246.field_10124.method_9564());}
        world.method_8537(null, x + 0.5f, y + 0.4f, z + 0.5f, explosionPower, true, class_1937.class_7867.field_40891);
    }

    /**
     * @param world Current world that the block will explode
     * @param x Explosion position, x position
     * @param y Explosion position, y position
     * @param z Explosion position, z position
     * @param explosionPower Power of the explosion
     * @param fire If true the explosion will add fire around
     * @param replaceSourceBlockWithAir If true the explosion will replace the source block with air
     * @param sourceType Type of source that the explosion will use
     */
    public static void explode(class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if(replaceSourceBlockWithAir){
            world.method_8501(new class_2338((int) x,(int) y,(int) z), class_2246.field_10124.method_9564());}
        world.method_8537(null, x + 0.5f, y + 0.4f, z + 0.5f, explosionPower, true, sourceType);
    }

    /// ----------------------------------------------------------------------------------------------------------------
    private static final Map<class_2248, BlockEvents.AdvancedDropSettings> blockDropSettings = new HashMap<>();

    /**
     * !!DO NOT USE, THIS MAY CAUSE YOUR MOD AND OTHER TO MALFUNCTION!!
     */
    public static void DestroyEvent() {
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> {
            class_2248 block = blockState.method_26204();

            if (blockDropSettings.containsKey(block)) {
                AdvancedDropSettings settings = blockDropSettings.get(block);
                if (random.nextFloat() * 100 < settings.rate) {

                    if(playerEntity.method_6047().method_31573(settings.toolTag) || settings.toolTag == ExtraItemTags.NO_TOOL_LEVEL){

                        int extra = (settings.quantity > settings.minDrop) ? random.nextInt(settings.quantity - settings.minDrop) : 0;
                        int dropAmount = settings.randomDrops ? settings.minDrop + extra : settings.minDrop;

                        for (int i = 0; i < dropAmount; i++) {
                            ItemEvents.createWorldItem(world, blockPos, settings.item.method_7854());
                        }
                    }
                }
            }
        });
    }

    private static class AdvancedDropSettings {
        class_1792 item;
        class_6862<class_1792> toolTag;
        float rate;
        int quantity;
        boolean randomDrops;
        int minDrop;

        AdvancedDropSettings(class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop) {
            this.item = item;
            this.toolTag = toolTag;
            this.rate = rate;
            this.quantity = amount;
            this.randomDrops = randomDrops;
            this.minDrop = minDrop;
        }
    }
    /// ----------------------------------------------------------------------------------------------------------------
}
