package baspig.apis.utils.events.entity;

import baspig.apis.utils.events.item.ItemEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.entity.*;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * @author Baspig_
 */
@SuppressWarnings("unused")
public class EntityEvents {
    static Random random = new Random();

    /**
     * @param world Actual world where this method is called
     * @param entity The entity that will be generated
     */
    public static void generate(@NotNull class_3218 world, class_2338 pos, @NotNull class_1299<?> entity) {

        class_1297 summon = entity.method_5883(world, class_3730.field_16467);
        assert summon != null;
        summon.method_5725(pos, 0, 0);
        world.method_8649(summon);

    }


    /**
     * @param source The entity that will generate the other entity
     * @param entity The entity that will be generated
     */
    public static void spawnEntityOnDeath(@NotNull class_1299<?> source,@NotNull class_1299<?> entity){
        entitySpawnSettings.put(entity, new EntityEvents.AdvancedSpawnSettings(source, entity,100, 1, false, 1));
    }

    /**
     * @param source The entity that will generate the other entity
     * @param entity The entity that will be generated
     * @param rate Is the probability of the item of being dropped
     */
    public static void spawnEntityOnDeath(@NotNull class_1299<?> source,@NotNull class_1299<?> entity, float rate){
        entitySpawnSettings.put(entity, new EntityEvents.AdvancedSpawnSettings(source, entity,rate, 1, false, 1));
    }

    /**
     * @param source The entity that will generate the other entity
     * @param entity The entity that will be generated
     * @param rate Is the probability of the item of being dropped
     * @param amount Is the amount of items that will be dropped
     */
    public static void spawnEntityOnDeath(@NotNull class_1299<?> source,@NotNull class_1299<?> entity, float rate, int amount){
        entitySpawnSettings.put(entity, new EntityEvents.AdvancedSpawnSettings(source, entity,rate, amount, false, 1));
    }

    /**
     * @param source The entity that will generate the other entity
     * @param entity The entity that will be generated
     * @param rate Is the probability of the item of being dropped
     * @param amount Is the amount of items that will be dropped
     * @param randomDrops make the block drop a random amount
     */
    public static void spawnEntityOnDeath(@NotNull class_1299<?> source,@NotNull class_1299<?> entity, float rate, int amount, boolean randomDrops){
        entitySpawnSettings.put(entity, new EntityEvents.AdvancedSpawnSettings(source, entity,rate, amount, randomDrops, 1));
    }

    /**
     * @param source The entity that will generate the other entity
     * @param entity The entity that will be generated
     * @param rate Is the probability of the item of being dropped
     * @param amount Is the amount of items that will be dropped
     * @param randomDrops make the block drop a random amount
     * @param minDrop Minimum amount of items that will be dropped
     */
    public static void spawnEntityOnDeath(@NotNull class_1299<?> source,@NotNull class_1299<?> entity, float rate, int amount, boolean randomDrops, int minDrop){
        entitySpawnSettings.put(entity, new EntityEvents.AdvancedSpawnSettings(source, entity,rate, amount, randomDrops, minDrop));
    }

    /**
     * @param entity The entity that will drop the item
     * @param item The item that will be dropped
     */
    public static void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> entity, class_1792 item){
        entityDropSettings.put(entity, new EntityEvents.AdvancedDropSettings(item, 100, 1, false, 1));
    }

    /**
     * @param entity The entity that will drop the item
     * @param item The item that will be dropped
     * @param rate Is the probability of the item of being dropped
     */
    public static void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> entity, class_1792 item, float rate){
        entityDropSettings.put(entity, new EntityEvents.AdvancedDropSettings(item, rate, 1, false, 1));
    }

    /**
     * @param entity The entity that will drop the item
     * @param item The item that will be dropped
     * @param rate Is the probability of the item of being dropped
     * @param amount Is the amount of items that will be dropped
     */
    public static void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> entity, class_1792 item, float rate, int amount){
        entityDropSettings.put(entity, new EntityEvents.AdvancedDropSettings(item, rate, amount, false, 1));
    }

    /**
     * @param entity The entity that will drop the item
     * @param item The item that will be dropped
     * @param rate Is the probability of the item of being dropped
     * @param amount Is the amount of items that will be dropped
     * @param randomDrops make the block drop a random amount
     */
    public static void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> entity, class_1792 item, float rate, int amount, boolean randomDrops){
        entityDropSettings.put(entity, new EntityEvents.AdvancedDropSettings(item, rate, amount, randomDrops, 1));
    }

    /**
     * @param entity The entity that will drop the item
     * @param item The item that will be dropped
     * @param rate Is the probability of the item of being dropped
     * @param amount Is the amount of items that will be dropped
     * @param randomDrops make the block drop a random amount
     * @param minDrop Minimum amount of items that will be dropped
     */
    public static void spawnItemOnEntityDeath(@NotNull class_1299<? extends class_1309> entity, class_1792 item, float rate, int amount, boolean randomDrops,  int minDrop){
        entityDropSettings.put(entity, new EntityEvents.AdvancedDropSettings(item, rate, amount, randomDrops, 1));
    }


    /// ----------------------------------------------------------------------------------------------------------------
    private static final Map<class_1299<?>, EntityEvents.AdvancedDropSettings> entityDropSettings = new HashMap<>();

    /**
     * !!DO NOT USE, THIS MAY CAUSE YOUR MOD AND OTHERS TO MALFUNCTION!!
     */
    private static void KillEvent() {
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {

            class_1299<?> entity = livingEntity.method_5864();

            if (entityDropSettings.containsKey(entity)) {
                EntityEvents.AdvancedDropSettings settings = entityDropSettings.get(entity);
                if(random.nextFloat(0,100) < settings.rate){
                    if(settings.minDrop < settings.amount){

                        int extra = random.nextInt(settings.amount - settings.minDrop);
                        int dropAmount = settings.randomDrops ? settings.minDrop + extra : settings.minDrop;

                        for (int i = 0; i < dropAmount; i++) {
                            ItemEvents.createWorldItem(livingEntity.method_37908(), livingEntity.method_24515(), settings.item.method_7854());
                        }
                    }
                }
            }
        });
    }

    private static class AdvancedDropSettings {
        class_1792 item;
        float rate;
        int amount;
        boolean randomDrops;
        int minDrop;

        AdvancedDropSettings(@NotNull class_1792 item, float rate, int amount, boolean randomDrops, int minDrop) {
            this.item = item;
            this.rate = rate;
            this.amount = amount;
            this.randomDrops = randomDrops;
            this.minDrop = minDrop;
        }
    }
    /// ----------------------------------------------------------------------------------------------------------------



    /// ----------------------------------------------------------------------------------------------------------------
    private static final Map<class_1299<?>, AdvancedSpawnSettings> entitySpawnSettings = new HashMap<>();

    /**
     * !!DO NOT USE, THIS MAY CAUSE YOUR MOD AND OTHERS TO MALFUNCTION!!
     */
    private static void KillAndSpawnEvent() {
        ServerLivingEntityEvents.AFTER_DEATH.register((livingEntity, damageSource) -> {
            if (!(livingEntity.method_37908() instanceof class_3218 serverWorld)) return;

            class_1299<?> deadEntityType = livingEntity.method_5864();

            for (AdvancedSpawnSettings settings : entitySpawnSettings.values()) {
                if (deadEntityType.equals(settings.sourceType)) {
                    if (random.nextFloat() * 100 < settings.rate) {
                        int dropAmount = settings.minDrop;

                        if (settings.randomDrops && settings.amount > settings.minDrop) {
                            dropAmount += random.nextInt(settings.amount - settings.minDrop + 1);
                        }

                        for (int i = 0; i < dropAmount; i++) {
                            generate(serverWorld, livingEntity.method_24515(), settings.entityType);
                        }
                    }
                }
            }
        });
    }

    private static class AdvancedSpawnSettings {
        final class_1299<?> sourceType;
        final class_1299<?> entityType;
        final float rate;
        final int amount;
        final boolean randomDrops;
        final int minDrop;

        AdvancedSpawnSettings(@NotNull class_1299<?> source, @NotNull class_1299<?> entity, float rate, int amount, boolean randomDrops, int minDrop) {
            this.sourceType = source;
            this.entityType = entity;
            this.rate = rate;
            this.amount = amount;
            this.randomDrops = randomDrops;
            this.minDrop = minDrop;
        }
    }


    /**
     * !!DO NOT USE, THIS MAY CAUSE YOUR MOD AND OTHERS TO MALFUNCTION!!
     */
    public static void BlockEventsRegistry(){
        KillEvent();
        KillAndSpawnEvent();
    }
}
