package baspig.apis.utils.events.item;

import baspig.apis.utils.util.BP;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

/**
 * @author Baspig_
 */
@SuppressWarnings("unused")
public class ItemEvents {

    /**
     * @param world Actual world where this method is called
     * @param pos Position of the item creation
     * @param itemStack The item that will be created
     */
    public static void createWorldItem(@NotNull class_1937 world, class_2338 pos,@NotNull class_1799 itemStack) {
        if (!itemStack.method_7960()) {
            world.method_8649(new class_1542(
                    world, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5,
                    itemStack
            ));
        }else {
            BP.LOG.info("A exception occurred at: createWorldItem \n" +
                    "ItemStack is empty."
            );
        }
    }

    /**
     * It will remove only 1 item.
     *
     * @param player The player who will remove the item
     * @param hand It will remove item in hand
     */
    public static void removeItemInHand(@NotNull class_1657 player, class_1268 hand) {
        if (!player.method_37908().field_9236) {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                stack.method_7934(1);
                player.method_6122(hand, stack);
            }
        }
    }

    /**
     * @param player The player who will remove the item
     * @param hand The actual player hand, the selected item
     * @param quantity Amount of items that will remove from the hand
     */
    public static void removeItemInHand(@NotNull class_1657 player, class_1268 hand, byte quantity) {
        if (!player.method_37908().field_9236) {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                stack.method_7934(quantity);
                player.method_6122(hand, stack);
            }
        }
    }
}
