/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.events.block;

import baspig.apis.utils.events.item.ItemEvents;
import baspig.apis.utils.register.tags.ExtraItemTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;

public class BlockEvents {
    static Random random = new Random();
    private static final Map<class_2248, AdvancedDropSettings> blockDropSettings = new HashMap<class_2248, AdvancedDropSettings>();

    public static void onBlockDestroyed(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag) {
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, 100.0f, 1, false, 1));
    }

    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate) {
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, 1, false, 1));
    }

    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate, int amount) {
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, false, amount));
    }

    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops) {
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, amount));
    }

    public static void onBlockDestroyed(class_2248 block, class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop) {
        blockDropSettings.put(block, new AdvancedDropSettings(item, toolTag, rate, amount, randomDrops, minDrop));
    }

    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag, float rate) {
    }

    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag, float rate, int quantity) {
    }

    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag, float rate, int quantity, boolean randomDrops) {
    }

    private static void onBlockDestroyed(boolean dropsInCreative, class_2248 blocks, class_1792 items, class_6862<class_1792> toolTag, float rate, int quantity, boolean randomDrops, int minDrop) {
    }

    public static boolean isRaining(class_3218 world, class_2338 pos, boolean isRaining, boolean skyVisible, boolean biomeHasPrecipitation) {
        return world.method_8419() == isRaining && world.method_8311(pos) == skyVisible && ((class_1959)world.method_23753(pos).comp_349()).method_48163() == biomeHasPrecipitation;
    }

    public static boolean isRaining(class_3218 world, class_2338 pos) {
        return world.method_8419() && world.method_8311(pos) && ((class_1959)world.method_23753(pos).comp_349()).method_48163();
    }

    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire) {
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, class_1937.class_7867.field_40891);
    }

    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire, class_1937.class_7867 sourceType) {
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, sourceType);
    }

    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, class_1937.class_7867.field_40891);
    }

    public static void explode(class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, sourceType);
    }

    public static void explode(class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(new class_2338((int)x, (int)y, (int)z), class_2246.field_10124.method_9564());
        }
        world.method_8537(null, x + 0.5, y + (double)0.4f, z + 0.5, explosionPower, true, class_1937.class_7867.field_40891);
    }

    public static void explode(class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(new class_2338((int)x, (int)y, (int)z), class_2246.field_10124.method_9564());
        }
        world.method_8537(null, x + 0.5, y + (double)0.4f, z + 0.5, explosionPower, true, sourceType);
    }

    public static void DestroyEvent() {
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> {
            class_2248 block = blockState.method_26204();
            if (blockDropSettings.containsKey(block)) {
                AdvancedDropSettings settings = blockDropSettings.get(block);
                if (random.nextFloat() * 100.0f < settings.rate && (playerEntity.method_6047().method_31573(settings.toolTag) || settings.toolTag == ExtraItemTags.NO_TOOL_LEVEL)) {
                    int extra = settings.quantity > settings.minDrop ? random.nextInt(settings.quantity - settings.minDrop) : 0;
                    int dropAmount = settings.randomDrops ? settings.minDrop + extra : settings.minDrop;
                    for (int i = 0; i < dropAmount; ++i) {
                        ItemEvents.createWorldItem(world, blockPos, settings.item.method_7854());
                    }
                }
            }
        });
    }

    private static class AdvancedDropSettings {
        class_1792 item;
        class_6862<class_1792> toolTag;
        float rate;
        int quantity;
        boolean randomDrops;
        int minDrop;

        AdvancedDropSettings(class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop) {
            this.item = item;
            this.toolTag = toolTag;
            this.rate = rate;
            this.quantity = amount;
            this.randomDrops = randomDrops;
            this.minDrop = minDrop;
        }
    }
}

