/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.advanced.audio;

import baspig.apis.utils.util.Dimension;
import baspig.apis.utils.util.DimensionData;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class SourceObjectLoader {
    private static final Map<class_2338, SourceObjectData> sourceObjects = new HashMap<class_2338, SourceObjectData>();

    protected static void initiate() {
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            for (Map.Entry<class_2338, SourceObjectData> entry : sourceObjects.entrySet()) {
                class_2338 pos = entry.getKey();
                SourceObjectData data = entry.getValue();
                if (!DimensionData.checkIf(data.getDimension(), world) || !world.method_8477(pos) || data.getSoundEvent() == null) continue;
                if (data.getCurrentTick() > data.getMaxTicks()) {
                    world.method_8396(null, data.getPosition(), data.getSoundEvent(), data.getSoundCategory(), 1.0f, 1.0f);
                    data.currentTick = 0;
                    continue;
                }
                ++data.currentTick;
            }
        });
    }

    protected static void addSourceObject(class_2338 position, Dimension dimension, class_3414 soundEvents, class_3419 category, int maxTicks, boolean initialized) {
        sourceObjects.put(position, new SourceObjectData(dimension, position, soundEvents, category, maxTicks, initialized));
    }

    protected static class SourceObjectData {
        private final Dimension dimension;
        private final class_2338 position;
        private final class_3414 soundEvent;
        private final class_3419 soundCategory;
        private final boolean repeatable;
        private final int maxTicks;
        private int currentTick;

        protected SourceObjectData(Dimension dimension, class_2338 position, class_3414 soundEvents, class_3419 category, int maxTicks, boolean repeatable) {
            this.dimension = dimension;
            this.position = position;
            this.soundEvent = soundEvents;
            this.soundCategory = category;
            this.repeatable = repeatable;
            this.maxTicks = maxTicks;
            this.currentTick = maxTicks;
        }

        protected Dimension getDimension() {
            return this.dimension;
        }

        protected class_2338 getPosition() {
            return this.position;
        }

        protected class_3414 getSoundEvent() {
            return this.soundEvent;
        }

        protected class_3419 getSoundCategory() {
            return this.soundCategory;
        }

        protected boolean isRepeatable() {
            return this.repeatable;
        }

        protected int getMaxTicks() {
            return this.maxTicks;
        }

        protected int getCurrentTick() {
            return this.currentTick;
        }
    }
}

