/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.events.block;

import baspig.apis.utils.ModID;
import baspig.apis.utils.events.block.BlockSettingClasses;
import baspig.apis.utils.events.block.ParticleSettings;
import baspig.apis.utils.events.entity.EntityEvents;
import baspig.apis.utils.events.item.ItemEvents;
import baspig.apis.utils.util.BP;
import baspig.apis.utils.util.GeneralUtils;
import baspig.apis.utils.util.ParticleVelocityType;
import baspig.apis.utils.util.ShapeType;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public class BlockEvents {
    static Random random = new Random();
    private final String modId;

    public static void spawnParticles(@NotNull class_1937 world, class_2394 particle, class_2338 pos, int count, double spread) {
        class_5819 random = world.method_8409();
        for (int i = 0; i < count; ++i) {
            class_2350 face = class_2350.values()[random.method_43048(6)];
            double x = (double)pos.method_10263() + 0.5 + (double)face.method_10148() * 0.51 + (face.method_10148() == 0 ? (random.method_43058() - 0.5) * spread : 0.0);
            double y = (double)pos.method_10264() + 0.5 + (double)face.method_10164() * 0.51 + (face.method_10164() == 0 ? (random.method_43058() - 0.5) * spread : 0.0);
            double z = (double)pos.method_10260() + 0.5 + (double)face.method_10165() * 0.51 + (face.method_10165() == 0 ? (random.method_43058() - 0.5) * spread : 0.0);
            world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticles(@NotNull class_1937 world, class_2394 particle, class_2338 pos, int count, double spread, ParticleVelocityType velocityType, float velocityX, float velocityY, float velocityZ) {
        class_5819 random = world.method_8409();
        block22: for (int i = 0; i < count; ++i) {
            class_2350 face = class_2350.values()[random.method_43048(6)];
            double x = (double)pos.method_10263() + 0.5 + (double)face.method_10148() * 0.51 + (face.method_10148() == 0 ? (random.method_43058() - 0.5) * spread : 0.0);
            double y = (double)pos.method_10264() + 0.5 + (double)face.method_10164() * 0.51 + (face.method_10164() == 0 ? (random.method_43058() - 0.5) * spread : 0.0);
            double z = (double)pos.method_10260() + 0.5 + (double)face.method_10165() * 0.51 + (face.method_10165() == 0 ? (random.method_43058() - 0.5) * spread : 0.0);
            float XVelocity = 0.0f;
            float YVelocity = 0.0f;
            float ZVelocity = 0.0f;
            switch (velocityType) {
                case CUSTOM: {
                    XVelocity = velocityX;
                    YVelocity = velocityY;
                    ZVelocity = velocityZ;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case RANDOM: {
                    XVelocity = -random.method_43057() + random.method_43057();
                    YVelocity = -random.method_43057() + random.method_43057();
                    ZVelocity = -random.method_43057() + random.method_43057();
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case UPWARD: {
                    YVelocity = 0.25f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case UPWARD_SLOW: {
                    YVelocity = 0.05f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case UPWARD_CUSTOM_VELOCITY: {
                    YVelocity = velocityY;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case DOWNWARD: {
                    YVelocity = -0.25f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case DOWNWARD_SLOW: {
                    YVelocity = -0.05f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case DOWNWARD_CUSTOM_VELOCITY: {
                    YVelocity = -velocityY;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case EASTWARD: {
                    XVelocity = 0.25f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case EASTWARD_SLOW: {
                    XVelocity = 0.05f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case EASTWARD_CUSTOM_VELOCITY: {
                    XVelocity = velocityX;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case WESTWARD: {
                    XVelocity = -0.25f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case WESTWARD_SLOW: {
                    XVelocity = -0.05f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case WESTWARD_CUSTOM_VELOCITY: {
                    XVelocity = -velocityX;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case SOUTHWARD: {
                    ZVelocity = 0.25f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case SOUTHWARD_SLOW: {
                    ZVelocity = 0.05f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case SOUTHWARD_CUSTOM_VELOCITY: {
                    ZVelocity = velocityX;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case NORTHWARD: {
                    ZVelocity = -0.25f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case NORTHWARD_SLOW: {
                    ZVelocity = -0.05f;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                    continue block22;
                }
                case NORTHWARD_CUSTOM_VELOCITY: {
                    ZVelocity = -velocityX;
                    world.method_8406(particle, x, y, z, (double)XVelocity, (double)YVelocity, (double)ZVelocity);
                }
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void spawnShapeParticles(@NotNull class_1937 world, @NotNull class_2394 particle, class_2338 pos, int count, @NotNull ShapeType shape, float radius, float height, class_2338 offset) {
        class_5819 random = world.method_8409();
        block12: for (int i = 0; i < count; ++i) {
            double theta = random.method_43058() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.method_43058() - 1.0);
            double sphere_radius = Math.cbrt(random.method_43058()) * (double)radius;
            double cylinder_height = random.method_43058() * (double)height;
            double cylinder_radius = Math.sqrt(random.method_43058()) * (double)radius;
            float size = radius + radius;
            double xOffset = (random.method_43058() - 0.5) * (double)size;
            double yOffset = (random.method_43058() - 0.5) * (double)size;
            double zOffset = (random.method_43058() - 0.5) * (double)size;
            switch (shape) {
                case CIRCLE: {
                    double X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CIRCLE_OUTLINE: {
                    double X = (double)pos.method_10263() + 0.5 + (double)radius * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + (double)radius * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SPHERE: {
                    double X = (double)pos.method_10263() + 0.5 + sphere_radius * Math.sin(phi) * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5 + sphere_radius * Math.cos(phi);
                    double Z = (double)pos.method_10260() + 0.5 + sphere_radius * Math.sin(phi) * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SPHERE_OUTLINE: {
                    double r = Math.sqrt(random.method_43058()) * (double)radius;
                    double X = (double)pos.method_10263() + 0.5 + r * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + r * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CYLINDER: {
                    double X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5 - (double)(height / 2.0f) + cylinder_height;
                    double Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CYLINDER_OUTLINE: {
                    double Z;
                    double Y;
                    double X;
                    double angle = random.method_43058() * 2.0 * Math.PI;
                    byte side = (byte)random.method_43048(3);
                    if (side == 0) {
                        X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = (double)pos.method_10264() + 0.5 - (double)(height / 2.0f);
                        Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else if (side == 1) {
                        X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = (double)pos.method_10264() + 0.5 + (double)(height / 2.0f);
                        Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else {
                        double yHeight = (double)pos.method_10264() + 0.5 - (double)(height / 2.0f) + random.method_43058() * (double)height;
                        X = (double)pos.method_10263() + 0.5 + (double)radius * Math.cos(angle);
                        Y = yHeight;
                        Z = (double)pos.method_10260() + 0.5 + (double)radius * Math.sin(angle);
                    }
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SQUARE: {
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SQUARE_OUTLINE: {
                    double edge = random.method_43058() * (double)size - (double)(size / 2.0f);
                    if (random.method_43056()) {
                        xOffset = random.method_43056() ? size / 2.0f : -size / 2.0f;
                        zOffset = edge;
                    } else {
                        xOffset = edge;
                        zOffset = random.method_43056() ? size / 2.0f : -size / 2.0f;
                    }
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CUBE: {
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5 + yOffset;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CUBE_OUTLINE: {
                    int axis = random.method_43048(3);
                    double fixed = random.method_43056() ? size / 2.0f : -size / 2.0f;
                    if (axis == 0) {
                        xOffset = fixed;
                        yOffset = (random.method_43058() - 0.5) * (double)size;
                        zOffset = (random.method_43058() - 0.5) * (double)size;
                    } else if (axis == 1) {
                        yOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * (double)size;
                        zOffset = (random.method_43058() - 0.5) * (double)size;
                    } else {
                        zOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * (double)size;
                        yOffset = (random.method_43058() - 0.5) * (double)size;
                    }
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5 + yOffset;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void spawnShapeParticles(@NotNull class_1937 world, @NotNull ParticleSettings particleSettings) {
        class_5819 random = world.method_8409();
        int count = particleSettings.getAmount();
        double radius = particleSettings.getRadius();
        double height = particleSettings.getHeight();
        ShapeType shape = particleSettings.getShapeType();
        class_2338 pos = particleSettings.getBlockPos();
        class_2394 particle = particleSettings.getParticleEffect();
        block12: for (int i = 0; i < count; ++i) {
            double theta = particleSettings.getSpecialTheta();
            double phi = particleSettings.getSpecialPhi();
            double sphere_uniform = particleSettings.getCubicRadiusScaling();
            double cylinder_height = random.method_43058() * height;
            double cylinder_radius = Math.sqrt(random.method_43058()) * radius;
            double size = particleSettings.getDiameter();
            double xOffset = particleSettings.getArea();
            double yOffset = particleSettings.getArea();
            double zOffset = particleSettings.getArea();
            switch (shape) {
                case CIRCLE: {
                    double X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CIRCLE_OUTLINE: {
                    double X = (double)pos.method_10263() + 0.5 + radius * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + radius * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SPHERE: {
                    double X = (double)pos.method_10263() + 0.5 + sphere_uniform * Math.sin(phi) * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5 + sphere_uniform * Math.cos(phi);
                    double Z = (double)pos.method_10260() + 0.5 + sphere_uniform * Math.sin(phi) * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SPHERE_OUTLINE: {
                    double X = (double)pos.method_10263() + 0.5 + radius * Math.sin(phi) * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5 + radius * Math.cos(phi);
                    double Z = (double)pos.method_10260() + 0.5 + radius * Math.sin(phi) * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CYLINDER: {
                    double X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(theta);
                    double Y = (double)pos.method_10264() + 0.5 - height / 2.0 + cylinder_height;
                    double Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(theta);
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CYLINDER_OUTLINE: {
                    double Z;
                    double Y;
                    double X;
                    double angle = random.method_43058() * 2.0 * Math.PI;
                    byte side = (byte)random.method_43048(90);
                    if (side <= 25) {
                        X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = (double)pos.method_10264() + 0.5 - height / 2.0;
                        Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else if (side <= 50) {
                        X = (double)pos.method_10263() + 0.5 + cylinder_radius * Math.cos(angle);
                        Y = (double)pos.method_10264() + 0.5 + height / 2.0;
                        Z = (double)pos.method_10260() + 0.5 + cylinder_radius * Math.sin(angle);
                    } else {
                        double yHeight = (double)pos.method_10264() + 0.5 - height / 2.0 + random.method_43058() * height;
                        X = (double)pos.method_10263() + 0.5 + radius * Math.cos(angle);
                        Y = yHeight;
                        Z = (double)pos.method_10260() + 0.5 + radius * Math.sin(angle);
                    }
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SQUARE: {
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case SQUARE_OUTLINE: {
                    double edge = random.method_43058() * size - size / 2.0;
                    if (random.method_43056()) {
                        xOffset = random.method_43056() ? size / 2.0 : -size / 2.0;
                        zOffset = edge;
                    } else {
                        xOffset = edge;
                        zOffset = random.method_43056() ? size / 2.0 : -size / 2.0;
                    }
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CUBE: {
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5 + yOffset;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                    continue block12;
                }
                case CUBE_OUTLINE: {
                    double fixed;
                    int axis = random.method_43048(3);
                    double d = fixed = random.method_43056() ? size / 2.0 : -size / 2.0;
                    if (axis == 0) {
                        xOffset = fixed;
                        yOffset = (random.method_43058() - 0.5) * size;
                        zOffset = (random.method_43058() - 0.5) * size;
                    } else if (axis == 1) {
                        yOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * size;
                        zOffset = (random.method_43058() - 0.5) * size;
                    } else {
                        zOffset = fixed;
                        xOffset = (random.method_43058() - 0.5) * size;
                        yOffset = (random.method_43058() - 0.5) * size;
                    }
                    double X = (double)pos.method_10263() + 0.5 + xOffset;
                    double Y = (double)pos.method_10264() + 0.5 + yOffset;
                    double Z = (double)pos.method_10260() + 0.5 + zOffset;
                    world.method_8406(particle, X, Y, Z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static boolean nextBlockIsExcept(class_1937 world, class_2338 pos, class_2248 block) {
        class_2338[] directions;
        for (class_2338 adjacentPos : directions = new class_2338[]{pos.method_10084(), pos.method_10074(), pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067()}) {
            if (world.method_8608() || world.method_8320(adjacentPos).method_26204() == block) continue;
            return true;
        }
        return false;
    }

    public static boolean nextBlockIsExcept(class_1937 world, class_2338 pos, class_2248 block, class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036 -> {
                if (world.method_8320(pos.method_10069(0, 1, 0)).method_26204() != block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11033 -> {
                if (world.method_8320(pos.method_10069(0, -1, 0)).method_26204() != block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11043 -> {
                if (world.method_8320(pos.method_10069(0, 0, 1)).method_26204() != block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (world.method_8320(pos.method_10069(0, 0, -1)).method_26204() != block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> {
                if (world.method_8320(pos.method_10069(1, 0, 0)).method_26204() != block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> world.method_8320(pos.method_10069(-1, 0, 0)).method_26204() != block;
        };
    }

    public static boolean nextBlockIs(class_1937 world, @NotNull class_2338 pos, class_2248 block) {
        class_2338[] directions;
        for (class_2338 adjacentPos : directions = new class_2338[]{pos.method_10084(), pos.method_10074(), pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067()}) {
            if (world.method_8608() || world.method_8320(adjacentPos).method_26204() != block) continue;
            return true;
        }
        return false;
    }

    public static boolean nextBlockIs(class_1937 world, class_2338 pos, class_2248 block, class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036 -> {
                if (world.method_8320(pos.method_10069(0, 1, 0)).method_26204() == block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11033 -> {
                if (world.method_8320(pos.method_10069(0, -1, 0)).method_26204() == block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11043 -> {
                if (world.method_8320(pos.method_10069(0, 0, 1)).method_26204() == block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (world.method_8320(pos.method_10069(0, 0, -1)).method_26204() == block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> {
                if (world.method_8320(pos.method_10069(1, 0, 0)).method_26204() == block) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> world.method_8320(pos.method_10069(-1, 0, 0)).method_26204() == block;
        };
    }

    public BlockEvents(String modId, String referenceId) {
        this.modId = modId + ":" + referenceId;
    }

    public void deleteEvent(class_2248 block, RemoveEvent removeEvent) {
        Object object;
        Map<class_2248, Object> innerMap;
        for (String modIdKeys : BlockSettingClasses.GeneralSpawnEntityOnBreakHashMap.keySet()) {
            innerMap = BlockSettingClasses.GeneralSpawnEntityOnBreakHashMap.get(modIdKeys);
            if (!modIdKeys.contains(this.modId)) continue;
            for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                if (block != entry.getKey() || !removeEvent.equals((Object)RemoveEvent.AddEntityOnBreak) || !((object = entry.getValue()) instanceof BlockSettingClasses.DropItemObBreakSettings)) continue;
                BlockSettingClasses.DropItemObBreakSettings settings = (BlockSettingClasses.DropItemObBreakSettings)object;
                innerMap.remove(block);
                return;
            }
        }
        for (String modIdKeys : BlockSettingClasses.GeneralDropItemOnBreakMap.keySet()) {
            innerMap = BlockSettingClasses.GeneralDropItemOnBreakMap.get(modIdKeys);
            if (!modIdKeys.contains(this.modId)) continue;
            for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                if (block != entry.getKey() || !removeEvent.equals((Object)RemoveEvent.DropItemOnBreak) || !((object = entry.getValue()) instanceof BlockSettingClasses.DropItemObBreakSettings)) continue;
                BlockSettingClasses.DropItemObBreakSettings settings = (BlockSettingClasses.DropItemObBreakSettings)object;
                innerMap.remove(block);
                return;
            }
        }
        for (String modIdKeys : BlockSettingClasses.GeneralExplodeOnBreakHashMap.keySet()) {
            innerMap = BlockSettingClasses.GeneralExplodeOnBreakHashMap.get(modIdKeys);
            if (!modIdKeys.contains(this.modId)) continue;
            for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                if (block != entry.getKey() || !removeEvent.equals((Object)RemoveEvent.ExplodeOnBreak) || !((object = entry.getValue()) instanceof BlockSettingClasses.ExplodeOnBreakSettings)) continue;
                BlockSettingClasses.ExplodeOnBreakSettings settings = (BlockSettingClasses.ExplodeOnBreakSettings)object;
                innerMap.remove(block);
                return;
            }
        }
        for (String modIdKeys : BlockSettingClasses.GeneralPlaySoundOnBreakMap.keySet()) {
            innerMap = BlockSettingClasses.GeneralPlaySoundOnBreakMap.get(modIdKeys);
            if (!modIdKeys.contains(this.modId)) continue;
            for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                if (block != entry.getKey() || !removeEvent.equals((Object)RemoveEvent.PlaySoundOnBreak) || !((object = entry.getValue()) instanceof BlockSettingClasses.PlaySoundOnBreakSettings)) continue;
                BlockSettingClasses.PlaySoundOnBreakSettings settings = (BlockSettingClasses.PlaySoundOnBreakSettings)object;
                innerMap.remove(block);
                return;
            }
        }
    }

    public void addEntityOnBreak(@NotNull class_2248 block, @NotNull class_1299<?> entityType, class_6862<class_1792> toolTag) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.SpawnEntityOnBreakHashMap;
        updateMap.put(block, new BlockSettingClasses.AddEntityOnBreakSettings(entityType, toolTag, 100.0f, 1));
        BlockSettingClasses.GeneralSpawnEntityOnBreakHashMap.put(this.modId, updateMap);
    }

    public void addEntityOnBreak(@NotNull class_2248 block, @NotNull class_1299<?> entityType, class_6862<class_1792> toolTag, float rate) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.SpawnEntityOnBreakHashMap;
        updateMap.put(block, new BlockSettingClasses.AddEntityOnBreakSettings(entityType, toolTag, rate, 1));
        BlockSettingClasses.GeneralSpawnEntityOnBreakHashMap.put(this.modId, updateMap);
    }

    public void addEntityOnBreak(@NotNull class_2248 block, @NotNull class_1299<?> entityType, class_6862<class_1792> toolTag, float rate, int amount) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.SpawnEntityOnBreakHashMap;
        updateMap.put(block, new BlockSettingClasses.AddEntityOnBreakSettings(entityType, toolTag, rate, amount));
        BlockSettingClasses.GeneralSpawnEntityOnBreakHashMap.put(this.modId, updateMap);
    }

    public void explodeOnBreak(@NotNull class_2248 block, float power, class_6862<class_1792> toolTag) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.ExplodeOnBreakHashMap;
        updateMap.put(block, new BlockSettingClasses.ExplodeOnBreakSettings(power, toolTag, 100.0f, false));
        BlockSettingClasses.GeneralExplodeOnBreakHashMap.put(this.modId, updateMap);
    }

    public void explodeOnBreak(@NotNull class_2248 block, float power, class_6862<class_1792> toolTag, float rate) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.ExplodeOnBreakHashMap;
        updateMap.put(block, new BlockSettingClasses.ExplodeOnBreakSettings(power, toolTag, rate, false));
        BlockSettingClasses.GeneralExplodeOnBreakHashMap.put(this.modId, updateMap);
    }

    public void explodeOnBreak(@NotNull class_2248 block, float power, class_6862<class_1792> toolTag, float rate, boolean spreadFire) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.ExplodeOnBreakHashMap;
        updateMap.put(block, new BlockSettingClasses.ExplodeOnBreakSettings(power, toolTag, rate, spreadFire));
        BlockSettingClasses.GeneralExplodeOnBreakHashMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, 100.0f, 1, false, 1, false));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, rate, 1, false, 1, false));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, rate, amount, false, 1, false));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, rate, amount, randomDrops, 1, false));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(@NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, rate, amount, randomDrops, minDrop, false));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, 100.0f, 1, false, 1, dropsInCreative));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, rate, amount, false, 1, dropsInCreative));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, rate, amount, randomDrops, 1, dropsInCreative));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void dropItemOnBreak(boolean dropsInCreative, @NotNull class_2248 block, @NotNull class_1792 item, class_6862<class_1792> toolTag, float rate, int amount, boolean randomDrops, int minDrop) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.DropItemOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.DropItemObBreakSettings(item, toolTag, rate, amount, randomDrops, minDrop, dropsInCreative));
        BlockSettingClasses.GeneralDropItemOnBreakMap.put(this.modId, updateMap);
    }

    public void playSoundOnBreak(@NotNull class_2248 block, @NotNull class_3414 soundEvent, class_3419 soundCategory, class_6862<class_1792> toolTag) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.PlaySoundOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.PlaySoundOnBreakSettings(soundEvent, soundCategory, toolTag, 100.0f, 1.0f));
        BlockSettingClasses.GeneralPlaySoundOnBreakMap.put(this.modId, updateMap);
    }

    public void playSoundOnBreak(@NotNull class_2248 block, @NotNull class_3414 soundEvent, class_3419 soundCategory, class_6862<class_1792> toolTag, float rate) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.PlaySoundOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.PlaySoundOnBreakSettings(soundEvent, soundCategory, toolTag, rate, 1.0f));
        BlockSettingClasses.GeneralPlaySoundOnBreakMap.put(this.modId, updateMap);
    }

    public void playSoundOnBreak(@NotNull class_2248 block, @NotNull class_3414 soundEvent, class_3419 soundCategory, class_6862<class_1792> toolTag, float rate, float volume) {
        Map<class_2248, Object> updateMap = BlockSettingClasses.PlaySoundOnBreakMap;
        updateMap.put(block, new BlockSettingClasses.PlaySoundOnBreakSettings(soundEvent, soundCategory, toolTag, rate, volume));
        BlockSettingClasses.GeneralPlaySoundOnBreakMap.put(this.modId, updateMap);
    }

    public static boolean isRainingOnBlock(@NotNull class_3218 world, class_2338 pos, boolean isRaining, boolean skyVisible, boolean biomeHasPrecipitation) {
        return world.method_8419() == isRaining && world.method_8311(pos) == skyVisible && ((class_1959)world.method_23753(pos).comp_349()).method_48163() == biomeHasPrecipitation;
    }

    public static boolean isRainingOnBlock(@NotNull class_3218 world, class_2338 pos) {
        return world.method_8419() && world.method_8311(pos) && ((class_1959)world.method_23753(pos).comp_349()).method_48163();
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire) {
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, class_1937.class_7867.field_40891);
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire, class_1937.class_7867 sourceType) {
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, sourceType);
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, class_1937.class_7867.field_40891);
    }

    public static void explode(@NotNull class_3218 world, class_2338 pos, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        world.method_8537(null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.5f), explosionPower, true, sourceType);
    }

    public static void explode(@NotNull class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(new class_2338((int)x, (int)y, (int)z), class_2246.field_10124.method_9564());
        }
        world.method_8537(null, x + 0.5, y + (double)0.4f, z + 0.5, explosionPower, true, class_1937.class_7867.field_40891);
    }

    public static void explode(@NotNull class_3218 world, double x, double y, double z, float explosionPower, boolean fire, boolean replaceSourceBlockWithAir, class_1937.class_7867 sourceType) {
        if (replaceSourceBlockWithAir) {
            world.method_8501(new class_2338((int)x, (int)y, (int)z), class_2246.field_10124.method_9564());
        }
        world.method_8537(null, x + 0.5, y + (double)0.4f, z + 0.5, explosionPower, true, sourceType);
    }

    public static void BlockEventRegister(ModID id) {
        String clasWhoCallThis;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 2 && !(clasWhoCallThis = stackTrace[2].getClassName()).equals("baspig.apis.utils.Baspig_utils") && !Objects.equals(id.toString(), "baspig_utils")) {
            String r = "\u001b[0m";
            String red = "\u001b[0;31m";
            String yellow = "\u001b[0;33m";
            String lightBlue = "\u001b[0;94m";
            BP.LOG.warn("Other mod is trying to access and register/modify Easy events. It's being called by class: {}{}", (Object)yellow, (Object)clasWhoCallThis);
        }
        PlayerBlockBreakEvents.AFTER.register((world, playerEntity, blockPos, blockState, blockEntity) -> {
            Object settings;
            Object patt0$temp;
            Map<class_2248, Object> innerMap;
            class_2248 block = blockState.method_26204();
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)world;
            for (String modIdKeys : BlockSettingClasses.GeneralSpawnEntityOnBreakHashMap.keySet()) {
                innerMap = BlockSettingClasses.GeneralSpawnEntityOnBreakHashMap.get(modIdKeys);
                for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                    if (block != entry.getKey() || !((patt0$temp = entry.getValue()) instanceof BlockSettingClasses.AddEntityOnBreakSettings)) continue;
                    settings = (BlockSettingClasses.AddEntityOnBreakSettings)patt0$temp;
                    BlockEvents.addEntityOnBreakFunction((BlockSettingClasses.AddEntityOnBreakSettings)settings, playerEntity, serverWorld, blockPos);
                }
            }
            for (String modIdKeys : BlockSettingClasses.GeneralDropItemOnBreakMap.keySet()) {
                innerMap = BlockSettingClasses.GeneralDropItemOnBreakMap.get(modIdKeys);
                for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                    if (block != entry.getKey() || !((patt0$temp = entry.getValue()) instanceof BlockSettingClasses.DropItemObBreakSettings)) continue;
                    settings = (BlockSettingClasses.DropItemObBreakSettings)patt0$temp;
                    BlockEvents.dropItemOnBreakFunction((BlockSettingClasses.DropItemObBreakSettings)settings, playerEntity, serverWorld, blockPos);
                }
            }
            for (String modIdKeys : BlockSettingClasses.GeneralExplodeOnBreakHashMap.keySet()) {
                innerMap = BlockSettingClasses.GeneralExplodeOnBreakHashMap.get(modIdKeys);
                for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                    if (block != entry.getKey() || !((patt0$temp = entry.getValue()) instanceof BlockSettingClasses.ExplodeOnBreakSettings)) continue;
                    settings = (BlockSettingClasses.ExplodeOnBreakSettings)patt0$temp;
                    BlockEvents.explodeOnBreakFunction((BlockSettingClasses.ExplodeOnBreakSettings)settings, playerEntity, serverWorld, blockPos);
                }
            }
            for (String modIdKeys : BlockSettingClasses.GeneralPlaySoundOnBreakMap.keySet()) {
                innerMap = BlockSettingClasses.GeneralPlaySoundOnBreakMap.get(modIdKeys);
                for (Map.Entry<class_2248, Object> entry : innerMap.entrySet()) {
                    if (block != entry.getKey() || !((patt0$temp = entry.getValue()) instanceof BlockSettingClasses.PlaySoundOnBreakSettings)) continue;
                    settings = (BlockSettingClasses.PlaySoundOnBreakSettings)patt0$temp;
                    BlockEvents.playSoundOnBreakFunction((BlockSettingClasses.PlaySoundOnBreakSettings)settings, playerEntity, serverWorld, blockPos);
                }
            }
        });
    }

    private static void dropItemOnBreakFunction(BlockSettingClasses.DropItemObBreakSettings settings, class_1657 playerEntity, class_3218 serverWorld, class_2338 blockPos) {
        if (ItemEvents.playerHasInHand(playerEntity, settings.toolTag) && GeneralUtils.probability(settings.rate).booleanValue()) {
            class_3222 serverPlayer;
            int dropAmount;
            int extra = settings.quantity > settings.minDrop ? random.nextInt(settings.quantity - settings.minDrop) : 0;
            int n = dropAmount = settings.randomDrops ? settings.minDrop + extra : settings.minDrop;
            if (playerEntity instanceof class_3222 && settings.dropsOnCreative == (serverPlayer = (class_3222)playerEntity).method_7337()) {
                for (int i = 0; i < dropAmount; ++i) {
                    ItemEvents.createWorldItem((class_1937)serverWorld, blockPos, settings.item.method_7854());
                }
            }
        }
    }

    private static void addEntityOnBreakFunction(BlockSettingClasses.AddEntityOnBreakSettings settings, class_1657 playerEntity, class_3218 serverWorld, class_2338 blockPos) {
        if (ItemEvents.playerHasInHand(playerEntity, settings.toolTag) && GeneralUtils.probability(settings.rate).booleanValue()) {
            EntityEvents.generate(serverWorld, blockPos, settings.entityType);
        }
    }

    private static void explodeOnBreakFunction(BlockSettingClasses.ExplodeOnBreakSettings settings, class_1657 playerEntity, class_3218 serverWorld, class_2338 blockPos) {
        if (ItemEvents.playerHasInHand(playerEntity, settings.toolTag) && GeneralUtils.probability(settings.rate).booleanValue()) {
            BlockEvents.explode(serverWorld, blockPos, settings.power, settings.fireSpread);
        }
    }

    private static void playSoundOnBreakFunction(BlockSettingClasses.PlaySoundOnBreakSettings settings, class_1657 playerEntity, class_3218 serverWorld, class_2338 blockPos) {
        if (ItemEvents.playerHasInHand(playerEntity, settings.toolTag) && GeneralUtils.probability(settings.rate).booleanValue()) {
            serverWorld.method_45447(null, blockPos, settings.soundEvent, settings.soundCategory);
        }
    }

    public static enum RemoveEvent {
        AddEntityOnBreak,
        DropItemOnBreak,
        ExplodeOnBreak,
        PlaySoundOnBreak;

    }

    public static enum Mode {
        AdIfAbsent,
        Replace;

    }
}

