/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.events.block;

import baspig.apis.utils.util.ShapeType;
import baspig.apis.utils.util.block.Offset;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2394;

public class ParticleSettings {
    private final Random random = new Random();
    private final class_2394 particleEffect;
    private final class_2338 blockPos;
    private final ShapeType shapeType;
    private final int amount;
    private final int radius;
    private final int height;
    private final Offset offset;

    public ParticleSettings(class_2394 particleType, class_2338 blockPos, ShapeType shapeType, int amount, int radius) {
        this.particleEffect = particleType;
        this.blockPos = blockPos;
        this.shapeType = shapeType;
        this.amount = amount;
        this.radius = radius;
        this.offset = new Offset(0, 0, 0);
        this.height = 0;
    }

    public ParticleSettings(class_2394 particleType, class_2338 blockPos, ShapeType shapeType, int amount, int radius, int height) {
        this.particleEffect = particleType;
        this.blockPos = blockPos;
        this.shapeType = shapeType;
        this.amount = amount;
        this.radius = radius;
        this.offset = new Offset(0, 0, 0);
        this.height = height;
    }

    public ParticleSettings(class_2394 particleType, class_2338 blockPos, ShapeType shapeType, int amount, int radius, Offset offset) {
        this.particleEffect = particleType;
        this.blockPos = blockPos;
        this.shapeType = shapeType;
        this.amount = amount;
        this.radius = radius;
        this.offset = offset;
        this.height = radius;
    }

    public ParticleSettings(class_2394 particleType, class_2338 blockPos, ShapeType shapeType, int amount, int radius, int height, Offset offset) {
        this.particleEffect = particleType;
        this.blockPos = blockPos;
        this.shapeType = shapeType;
        this.amount = amount;
        this.radius = radius;
        this.offset = offset;
        this.height = height;
    }

    public class_2394 getParticleEffect() {
        return this.particleEffect;
    }

    public class_2338 getBlockPos() {
        return this.blockPos.method_10069(this.offset.getXInt(), this.offset.getYInt(), this.offset.getZInt());
    }

    public class_2338 getOriginalBlockPos() {
        return this.blockPos;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getDiameter() {
        return this.radius * 2;
    }

    public int getHeight() {
        return this.height == 0 ? this.radius * 2 : this.height;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public int getXOffset() {
        return this.offset.getXInt();
    }

    public int getYOffset() {
        return this.offset.getYInt();
    }

    public int getZOffset() {
        return this.offset.getZInt();
    }

    public double getTheta() {
        return this.random.nextDouble() * 2.0 * Math.PI;
    }

    public double getSpecialPhi() {
        return Math.acos(2.0 * this.random.nextDouble() - 1.0);
    }

    public double getCubicRadiusScaling() {
        return Math.cbrt(this.random.nextDouble()) * (double)this.radius;
    }

    public double getSpecialTheta() {
        return this.random.nextDouble() * 2.0 * Math.PI;
    }

    public double getPhi() {
        return this.random.nextDouble() * Math.PI;
    }

    public double getCircleX() {
        return this.getCubicRadiusScaling() * Math.cos(this.getSpecialTheta());
    }

    public double getCircleZ() {
        return this.getCubicRadiusScaling() * Math.sin(this.getSpecialTheta());
    }

    public double getArea() {
        return (this.random.nextDouble() - 0.5) * (double)this.getDiameter();
    }
}

