/*
 * Decompiled with CFR 0.152.
 */
package baspig.apis.utils.files;

import baspig.apis.utils.files.FileUtils;
import baspig.apis.utils.files.UpdateMode;
import baspig.apis.utils.util.BP;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EasyJSON {
    private static final SerializationFeature SERIALIZATION_OUTPUT_INDENT = SerializationFeature.INDENT_OUTPUT;
    private static final int JSON_SIMPLE_TYPE = 4032;

    public static synchronized void write(String path, String file, List<String> keys, List<Object> values) {
        path = FileUtils.fixPath(path);
        FileUtils.checkJSONArgsLength(keys, values, "write");
        try {
            File directory = new File(path);
            if (!(directory.exists() || directory.mkdirs() || path.isEmpty())) {
                BP.LOG.info("Already created - don't worry: {}", (Object)directory.getAbsolutePath());
                return;
            }
            LinkedHashMap<String, Object> orderedMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                Object value = values.get(i);
                if (value instanceof JSONObject) {
                    value = new ObjectMapper().readValue(value.toString(), Map.class);
                }
                orderedMap.put(keys.get(i), value);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            File outputFile = new File(path + file + ".json");
            if (outputFile.exists()) {
                BP.LOG.info("|write| File already exists: {}", (Object)outputFile.getAbsolutePath());
                return;
            }
            mapper.writeValue(outputFile, orderedMap);
            BP.LOG.info("|write| Successfully wrote JSON file: {}", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            BP.LOG.info("|write| Failed to write JSON: {}", (Object)e.getMessage());
        }
    }

    public static synchronized void write(String path, String file, List<String> keys, List<Object> values, UpdateMode mode) {
        path = FileUtils.fixPath(path);
        FileUtils.checkJSONArgsLength(keys, values, "write");
        try {
            File directory = new File(path);
            if (!(directory.exists() || directory.mkdirs() || path.isEmpty())) {
                BP.LOG.info("|write-special| Failed to create directory: {}", (Object)directory.getAbsolutePath());
                return;
            }
            String fullPath = path + file + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.LOG.info("|write-special| File already exists, skipping due to NOTHING mode: {}", (Object)fullPath);
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String content = new String(Files.readAllBytes(outputFile.toPath()));
                    currentData = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                catch (IOException e) {
                    BP.LOG.warn("|write-special| Could not read existing JSON: {}", (Object)e.getMessage());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.LOG.info("|write-special| No changes detected, skipping write.");
                return;
            }
            mapper.writeValue(outputFile, currentData);
            BP.LOG.info("|write-special| Successfully wrote JSON file: {}", (Object)fullPath);
        }
        catch (IOException e) {
            BP.LOG.warn("|write-special| Failed to write JSON: {}", (Object)e.getMessage());
        }
    }

    public static synchronized void write(String path, String file, List<String> keys, List<Object> values, UpdateMode mode, List<String> ignoredKeys) {
        path = FileUtils.fixPath(path);
        String title = "write-advanced";
        FileUtils.checkJSONArgsLength(keys, values, title);
        try {
            File directory = new File(path);
            if (!(directory.exists() || directory.mkdirs() || path.isEmpty())) {
                BP.LOG.info("{} Failed to create directory: {}", (Object)title, (Object)directory.getAbsolutePath());
                return;
            }
            String fullPath = path + file + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.LOG.info("{} File already exists, skipping due to NOTHING mode: {}", (Object)title, (Object)fullPath);
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String content = new String(Files.readAllBytes(outputFile.toPath()));
                    currentData = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                catch (IOException e) {
                    BP.LOG.warn("{} Could not read existing JSON: {}", (Object)title, (Object)e.getMessage());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                if (ignoredKeys.contains(keys.get(i)) && currentData.containsKey(keys.get(i))) continue;
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.LOG.info("{} No changes detected, skipping write.", (Object)title);
                return;
            }
            mapper.writeValue(outputFile, currentData);
            BP.LOG.info("{} Successfully wrote JSON file: {}", (Object)title, (Object)fullPath);
        }
        catch (IOException e) {
            BP.LOG.warn("{} Failed to write JSON: {}", (Object)title, (Object)e.getMessage());
        }
    }

    public static synchronized void replace(String path, String file, List<String> keys, List<Object> values) {
        path = FileUtils.fixPath(path);
        FileUtils.checkJSONArgsLength(keys, values, "replace-multiple");
        try {
            File directory = new File(path);
            File jsonFile = new File(directory, file + ".json");
            if (!jsonFile.exists()) {
                BP.LOG.info("|replace-multiple| JSON file {} does not exist. No action taken.", (Object)jsonFile.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            Map jsonMap = (Map)mapper.readValue(jsonFile, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
            for (int i = 0; i < keys.size(); ++i) {
                String[] keyPath = keys.get(i).split("\\.");
                EasyJSON.setValue(jsonMap, keyPath, values.get(i));
            }
            File outputFile = new File(path + file + ".json");
            mapper.writeValue(outputFile, (Object)jsonMap);
        }
        catch (IOException e) {
            BP.LOG.warn("|replace-multiple|Failed to write JSON file: {}", (Object)e.getMessage());
        }
    }

    public static synchronized void replace(String path, String file, String key, Object value) {
        path = FileUtils.fixPath(path);
        try {
            File directory = new File(path);
            File jsonFile = new File(directory, file + ".json");
            if (!jsonFile.exists()) {
                BP.LOG.warn("|replace-single|JSON file {} does not exist. No action taken.", (Object)jsonFile.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            Map jsonMap = (Map)mapper.readValue(jsonFile, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
            String[] keyPath = key.split("\\.");
            EasyJSON.setValue(jsonMap, keyPath, value);
            File outputFile = new File(path + file + ".json");
            mapper.writeValue(outputFile, (Object)jsonMap);
        }
        catch (IOException e) {
            BP.LOG.warn("|replace-single| Failed to write JSON file: {}", (Object)e.getMessage());
        }
    }

    public static synchronized void replace(String path, String file, String key, Object value, String encryptKey) {
        path = FileUtils.fixPath(path);
        try {
            File directory = new File(path);
            File jsonFile = new File(directory, file + ".json");
            if (!jsonFile.exists()) {
                BP.LOG.warn("|replace-multiple-encrypt|JSON file {} does not exist. No action taken.", (Object)jsonFile.getAbsolutePath());
                return;
            }
            String encryptedContent = Files.readString(jsonFile.toPath());
            String decryptedContent = EasyJSON.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            Map jsonMap = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
            String[] keyPath = key.split("\\.");
            EasyJSON.setValue(jsonMap, keyPath, value);
            String updatedJson = mapper.writeValueAsString((Object)jsonMap);
            String encryptedJson = EasyJSON.xorEncryptAndDecrypt(updatedJson, encryptKey);
            Files.writeString(jsonFile.toPath(), (CharSequence)encryptedJson, new OpenOption[0]);
        }
        catch (IOException e) {
            BP.LOG.warn("|replace-multiple-encrypt| Failed to write JSON file: {}", (Object)e.getMessage());
        }
    }

    private static synchronized void setValue(Map<String, Object> jsonMap, String @NotNull [] keys, Object value) {
        Map currentMap = jsonMap;
        for (int i = 0; i < keys.length - 1; ++i) {
            currentMap = (Map)currentMap.get(keys[i]);
        }
        currentMap.put(keys[keys.length - 1], value);
    }

    @Nullable
    public static synchronized Object read(String path, String file, @NotNull String key) {
        path = FileUtils.fixPath(path);
        try {
            String[] keyParts;
            JSONParser parser = new JSONParser(4032);
            Object current = parser.parse((Reader)new FileReader(path + file + ".json"));
            for (String k : keyParts = key.split("\\.")) {
                if (!(current instanceof JSONObject)) {
                    BP.LOG.warn("|read| Key '{}' is not a valid JSON object", (Object)k);
                    return null;
                }
                JSONObject jsonObj = (JSONObject)current;
                current = jsonObj.get((Object)k);
                if (current != null) continue;
                BP.LOG.warn("|read| No key found: {}", (Object)k);
                return null;
            }
            return current;
        }
        catch (IOException | ParseException e) {
            BP.LOG.warn("|read| Failed to read JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    private static synchronized Object readObject(String path, String file, String key) {
        path = FileUtils.fixPath(path);
        try {
            JSONParser parser = new JSONParser(4032);
            Object current = parser.parse((Reader)new FileReader(path + file + ".json"));
            if (!(current instanceof JSONObject)) {
                BP.LOG.warn("|readObject| Key '{}' is not a valid JSON object", (Object)key);
                return null;
            }
            JSONObject jsonNested = (JSONObject)current;
            current = jsonNested.get((Object)key);
            if (current == null) {
                BP.LOG.warn("|readObject| Key '{}' is not a valid JSON object", (Object)key);
                return null;
            }
            return current;
        }
        catch (IOException | ParseException e) {
            BP.LOG.warn("|readObject| Failed to read JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static synchronized String readString(String path, String file, String keys) {
        Object result = EasyJSON.read(path, file, keys);
        if (result == null) {
            return "|readString| No key string found";
        }
        Object object = result;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, JSONObject.class}, (Object)object2, n)) {
            case 0 -> {
                String s;
                yield s = (String)object2;
            }
            case 1 -> {
                JSONObject jsonObject = (JSONObject)object2;
                yield jsonObject.toJSONString();
            }
            default -> String.valueOf(result);
        };
    }

    public static synchronized byte readByte(String path, String file, String keys) {
        Object result = EasyJSON.read(path, file, keys);
        if (result instanceof Integer) {
            return ((Integer)result).byteValue();
        }
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        BP.LOG.warn("|readByte| something went wrong");
        return 0;
    }

    public static synchronized short readShort(String path, String file, String keys) {
        Object result = EasyJSON.read(path, file, keys);
        if (result instanceof Integer) {
            return ((Integer)result).shortValue();
        }
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        BP.LOG.warn("|readShort| something went wrong");
        return 0;
    }

    public static synchronized int readInt(String path, String file, String keys) {
        Object result = EasyJSON.read(path, file, keys);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        BP.LOG.warn("|readInt| something went wrong");
        return 0;
    }

    public static float readFloat(String path, String file, String keys) {
        Object result = EasyJSON.read(path, file, keys);
        if (result instanceof Integer) {
            return ((Integer)result).floatValue();
        }
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        BP.LOG.warn("|readFloat| something went wrong");
        return 0.0f;
    }

    public static boolean readBoolean(String path, String file, String keys) {
        Object result = EasyJSON.read(path, file, keys);
        if (result != null) {
            return (Boolean)result;
        }
        BP.LOG.info("Boolean value from readBoolean is null!");
        return false;
    }

    @NotNull
    public static synchronized Object nestObject(List<String> keys, List<Object> values) {
        FileUtils.checkJSONArgsLength(keys, values, "nestObject");
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < keys.size(); ++i) {
            jsonObject.put((Object)keys.get(i), values.get(i));
        }
        return jsonObject;
    }

    @NotNull
    public static synchronized JSONArray writeList(List<Object> values) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(values);
        return jsonArray;
    }

    private static synchronized void replaceListValue(String path, String file, String searchKey, Object newValue, String ... listKeys) {
        path = FileUtils.fixPath(path);
        try {
            Map map;
            Map jsonMap;
            File jsonFile = new File(path + file + ".json");
            if (!jsonFile.exists()) {
                BP.LOG.info("JSON file {} does not exist. No action taken.", (Object)jsonFile.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            Map listObject = jsonMap = (Map)mapper.readValue(jsonFile, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
            for (String key : listKeys) {
                if (!(listObject instanceof Map)) {
                    BP.LOG.info("|replaceListValue| Key '{}' is not a valid JSON object.", (Object)key);
                    return;
                }
                map = listObject;
                listObject = map.get(key);
            }
            if (listObject instanceof List) {
                List list = (List)((Object)listObject);
                boolean updated = false;
                for (Object obj : list) {
                    if (!(obj instanceof Map) || !(map = (Map)obj).containsKey(searchKey)) continue;
                    map.put(searchKey, newValue);
                    updated = true;
                    break;
                }
                if (!updated) {
                    BP.LOG.info("Key '{}' not found in list '{}'", (Object)searchKey, (Object)listKeys[listKeys.length - 1]);
                    return;
                }
            } else {
                BP.LOG.info("|replaceListValue| The key '{}' does not point to a list.", (Object)listKeys[listKeys.length - 1]);
                return;
            }
            mapper.writeValue(jsonFile, (Object)jsonMap);
            BP.LOG.info("Successfully updated the JSON file.");
        }
        catch (IOException e) {
            BP.LOG.info("|replaceListValue| Failed to modify JSON file: {}", (Object)e.getMessage());
        }
    }

    public static synchronized JSONArray readList(String path, String file, String ... keys) {
        path = FileUtils.fixPath(path);
        try {
            JSONParser parser = new JSONParser(4032);
            Object listObject = parser.parse((Reader)new FileReader(path + file + ".json"));
            for (String key : keys) {
                if (!(listObject instanceof JSONObject)) {
                    BP.LOG.info("|readList| Key '{}' is not a valid JSON object", (Object)key);
                    return null;
                }
                JSONObject jsonNested = (JSONObject)listObject;
                listObject = jsonNested.get((Object)key);
                if (listObject != null) continue;
                System.out.println("No key found: " + key);
                return null;
            }
            if (listObject instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)listObject;
                return jsonArray;
            }
            BP.LOG.info("|readList| The final object is not a JSONArray.");
            return null;
        }
        catch (IOException | ParseException e) {
            BP.LOG.info("|readList| Failed to read JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static synchronized void delete(String path, String file) {
        Path jsonFile = Paths.get(path, file + ".json");
        try {
            Files.delete(jsonFile);
            BP.LOG.info("Successfully deleted JSON file: {}", (Object)jsonFile.toAbsolutePath());
        }
        catch (IOException e) {
            BP.LOG.error("Failed to delete JSON file: {}", (Object)jsonFile.toAbsolutePath(), (Object)e);
        }
    }

    @NotNull
    private static synchronized String xorEncryptAndDecrypt(@NotNull String input, String key) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            output.append((char)(input.charAt(i) ^ key.charAt(i % key.length())));
        }
        return output.toString();
    }

    public static synchronized void write_encrypt(String path, String file, List<String> keys, List<Object> values, String encryptKey) {
        path = FileUtils.fixPath(path);
        FileUtils.checkJSONArgsLength(keys, values, "writeAndEncrypt");
        try {
            File directory = new File(path);
            if (!directory.exists() && !directory.mkdirs()) {
                BP.LOG.info("Failed to create special directory: {}", (Object)directory.getAbsolutePath());
                return;
            }
            LinkedHashMap<String, Object> orderedMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                Object value = values.get(i);
                if (value instanceof JSONObject) {
                    value = new ObjectMapper().readValue(value.toString(), Map.class);
                }
                orderedMap.put(keys.get(i), value);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            String jsonString = mapper.writeValueAsString(orderedMap);
            String encryptedJson = EasyJSON.xorEncryptAndDecrypt(jsonString, encryptKey);
            String fullPath = path + file + ".json";
            File outputFile = new File(fullPath);
            BP.LOG.info(((Object)orderedMap).toString());
            File outFile = new File(fullPath);
            Files.writeString(outputFile.toPath(), (CharSequence)encryptedJson, new OpenOption[0]);
            BP.LOG.info("Successfully wrote JSON encrypted file: {}", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            BP.LOG.info("Failed to write encrypted JSON: {}", (Object)e.getMessage());
        }
    }

    public static synchronized void write_encrypt(String path, String file, List<String> keys, List<Object> values, UpdateMode mode, String encryptionKey) {
        path = FileUtils.fixPath(path);
        String title = "writeAndEncrypt";
        FileUtils.checkJSONArgsLength(keys, values, title);
        try {
            File directory = new File(path);
            if (!directory.exists() && !directory.mkdirs()) {
                BP.LOG.info("|{}| Failed to create directory: {}", (Object)title, (Object)directory.getAbsolutePath());
                return;
            }
            String fullPath = path + file + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.LOG.info("|{}| File already exists, skipping due to NOTHING mode: {}", (Object)title, (Object)fullPath);
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String encryptedContent = new String(Files.readAllBytes(outputFile.toPath()));
                    String decryptedContent = EasyJSON.xorEncryptAndDecrypt(encryptedContent, encryptionKey);
                    currentData = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                catch (IOException e) {
                    BP.LOG.warn("|{}| Could not read existing JSON: {}", (Object)title, (Object)e.getMessage());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.LOG.info("|{}| No changes detected, skipping write.", (Object)title);
                return;
            }
            String jsonString = mapper.writeValueAsString(currentData);
            String encryptedJson = EasyJSON.xorEncryptAndDecrypt(jsonString, encryptionKey);
            Files.write(outputFile.toPath(), encryptedJson.getBytes(), new OpenOption[0]);
            BP.LOG.info("|{}| Successfully wrote encrypted JSON file: {}", (Object)title, (Object)fullPath);
        }
        catch (IOException e) {
            BP.LOG.warn("|{}| Failed to write JSON: {}", (Object)title, (Object)e.getMessage());
        }
    }

    public static synchronized void write_encrypt(String path, String file, List<String> keys, List<Object> values, UpdateMode mode, List<String> ignoredKeys, String encryptionKey) {
        path = FileUtils.fixPath(path);
        String title = "write-encrypt";
        FileUtils.checkJSONArgsLength(keys, values, title);
        try {
            File directory = new File(path);
            if (!directory.exists() && !directory.mkdirs()) {
                BP.LOG.info("{} Failed to create directory: {}", (Object)title, (Object)directory.getAbsolutePath());
                return;
            }
            String fullPath = path + file + ".json";
            File outputFile = new File(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            if (mode == UpdateMode.NOTHING && outputFile.exists()) {
                BP.LOG.info("{} File already exists, skipping due to NOTHING mode: {}", (Object)title, (Object)fullPath);
                return;
            }
            Map currentData = new LinkedHashMap();
            if (outputFile.exists() && mode != UpdateMode.REPLACE) {
                try {
                    String encryptedContent = new String(Files.readAllBytes(outputFile.toPath()));
                    String decryptedContent = EasyJSON.xorEncryptAndDecrypt(encryptedContent, encryptionKey);
                    currentData = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                catch (IOException e) {
                    BP.LOG.warn("{} Could not read existing JSON: {}", (Object)title, (Object)e.getMessage());
                }
            }
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            for (int i = 0; i < keys.size(); ++i) {
                if (ignoredKeys.contains(keys.get(i)) && currentData.containsKey(keys.get(i))) continue;
                newData.put(keys.get(i), values.get(i));
            }
            boolean changesDetected = false;
            switch (mode) {
                case UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (!currentData.containsKey(entry.getKey()) || currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case ADD_AND_UPDATE: {
                    for (Map.Entry entry : newData.entrySet()) {
                        if (currentData.containsKey(entry.getKey()) && currentData.get(entry.getKey()).equals(entry.getValue())) continue;
                        currentData.put((String)entry.getKey(), entry.getValue());
                        changesDetected = true;
                    }
                    break;
                }
                case REPLACE: {
                    currentData = newData;
                    changesDetected = true;
                }
            }
            if (!changesDetected) {
                BP.LOG.info("{} No changes detected, skipping write.", (Object)title);
                return;
            }
            String jsonString = mapper.writeValueAsString(currentData);
            String encryptedJson = EasyJSON.xorEncryptAndDecrypt(jsonString, encryptionKey);
            Files.write(outputFile.toPath(), encryptedJson.getBytes(), new OpenOption[0]);
            BP.LOG.info("{} Successfully wrote encrypted JSON file: {}", (Object)title, (Object)fullPath);
        }
        catch (IOException e) {
            BP.LOG.warn("{} Failed to write JSON: {}", (Object)title, (Object)e.getMessage());
        }
    }

    @Nullable
    public static synchronized Object read(String path, String file, @NotNull String key, String encryptKey) {
        path = FileUtils.fixPath(path);
        try {
            String[] keyParts;
            String filePath = path + file + ".json";
            String encryptedContent = Files.readString(Paths.get(filePath, new String[0]));
            String decryptedContent = EasyJSON.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            JSONParser parser = new JSONParser(-1);
            Object current = parser.parse(decryptedContent);
            for (String k : keyParts = key.split("\\.")) {
                if (!(current instanceof JSONObject)) {
                    BP.LOG.warn("|read-Encrypted| Key '{}' is not a valid JSON object", (Object)k);
                    return null;
                }
                JSONObject jsonObj = (JSONObject)current;
                current = jsonObj.get((Object)k);
                if (current != null) continue;
                BP.LOG.warn("|read-Encrypted| Not found key: {}", (Object)k);
                return null;
            }
            return current;
        }
        catch (IOException | ParseException e) {
            BP.LOG.warn("|read-Encrypted| Failed to read encrypted JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static synchronized Object readObject(String path, String file, String key, @NotNull String encryptKey) {
        path = FileUtils.fixPath(path);
        try {
            String encryptedContent = Files.readString(Paths.get(path + file + ".json", new String[0]));
            String decryptedContent = EasyJSON.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            JSONParser parser = new JSONParser(4032);
            JSONObject reference = (JSONObject)parser.parse(decryptedContent);
            Object value = reference.get((Object)key);
            if (value == null) {
                BP.LOG.info("|readObject-Encrypted| Encrypted key not found: {}", (Object)key);
                return null;
            }
            return value;
        }
        catch (IOException | ParseException e) {
            BP.LOG.info("|readObject-Encrypted| Failed to read encrypted JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static synchronized String readString(String path, String file, String keys, String encryptKey) {
        Object result;
        Object object = result = EasyJSON.read(path, file, keys, encryptKey);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, JSONObject.class}, (Object)object, n)) {
            case -1 -> "|readString-Encrypted|No key string found";
            case 0 -> {
                String s;
                yield s = (String)object;
            }
            case 1 -> {
                JSONObject jsonObject = (JSONObject)object;
                yield jsonObject.toJSONString();
            }
            default -> String.valueOf(result);
        };
    }

    public static synchronized byte readByte(String path, String file, String keys, String encryptKey) {
        Object result = EasyJSON.read(path, file, keys, encryptKey);
        if (result instanceof Integer) {
            return ((Integer)result).byteValue();
        }
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        return 0;
    }

    public static synchronized short readShort(String path, String file, String keys, String encryptKey) {
        Object result = EasyJSON.read(path, file, keys, encryptKey);
        if (result instanceof Integer) {
            return ((Integer)result).shortValue();
        }
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        return 0;
    }

    public static synchronized int readInt(String path, String file, String keys, String encryptKey) {
        Object result = EasyJSON.read(path, file, keys, encryptKey);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return 0;
    }

    public static synchronized float readFloat(String path, String file, String keys, String encryptKey) {
        Object result = EasyJSON.read(path, file, keys, encryptKey);
        if (result instanceof Integer) {
            return ((Integer)result).floatValue();
        }
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        return 0.0f;
    }

    public static synchronized boolean readBoolean(String path, String file, String keys, String encryptKey) {
        Object result = EasyJSON.read(path, file, keys, encryptKey);
        if (result != null) {
            return (Boolean)result;
        }
        BP.LOG.info("Boolean value from encrypted readBoolean is null!");
        return false;
    }

    public static synchronized void replace(String path, String file, List<String> keys, List<Object> values, String encryptKey) {
        path = FileUtils.fixPath(path);
        FileUtils.checkJSONArgsLength(keys, values, "replace");
        try {
            File directory = new File(path);
            File jsonFile = new File(directory, file + ".json");
            if (!jsonFile.exists()) {
                BP.LOG.info("|replace| JSON file {} does not exist. No action taken.", (Object)jsonFile.getAbsolutePath());
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SERIALIZATION_OUTPUT_INDENT);
            String encryptedContent = Files.readString(jsonFile.toPath());
            String decryptedContent = EasyJSON.xorEncryptAndDecrypt(encryptedContent, encryptKey);
            Map jsonMap = (Map)mapper.readValue(decryptedContent, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
            for (int i = 0; i < keys.size(); ++i) {
                String[] keyPath = keys.get(i).split("\\.");
                EasyJSON.setValue(jsonMap, keyPath, values.get(i));
            }
            String updatedJson = mapper.writeValueAsString((Object)jsonMap);
            String encryptedJson = EasyJSON.xorEncryptAndDecrypt(updatedJson, encryptKey);
            Files.writeString(jsonFile.toPath(), (CharSequence)encryptedJson, new OpenOption[0]);
            BP.LOG.info("|replace| Successfully updated and encrypted JSON file: {}", (Object)jsonFile.getAbsolutePath());
        }
        catch (IOException e) {
            BP.LOG.info("|replace| Failed to write encrypted JSON file: {}", (Object)e.getMessage());
        }
    }
}

