/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.Utils;

import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.stamp.StampPlacement;
import com.moulberry.axiom.tools.stamp.TransformedBlockRegions;
import com.moulberry.axiom.utils.StringUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class BlueprintUtils {
    public static void saveBlueprint(String name, String author, ClipboardObject clipboard, class_1011 nativeImage, Path blueprintPath, BlueprintPreview blueprintPreview, int currentBlueprint, boolean saveAir) {
        BlueprintUtils.saveBlueprint(new ArrayList<String>(), name, author, clipboard, nativeImage, blueprintPath, blueprintPreview, currentBlueprint, saveAir);
    }

    public static void saveBlueprint(List<String> tags, String name, String author, ClipboardObject clipboard, class_1011 nativeImage, Path blueprintPath, BlueprintPreview blueprintPreview, int currentBlueprint, boolean saveAir) {
        String separator = blueprintPath.getFileSystem().getSeparator();
        Long2ObjectMap blockEntities = clipboard.blockEntities();
        List entities = clipboard.entities();
        ChunkedBlockRegion blockRegion = clipboard.blockRegion();
        String authorName = author.isEmpty() ? (class_310.method_1551().field_1724 == null ? "Unknown" : class_310.method_1551().field_1724.method_5820()) : author;
        Object blueprintString = name.trim().replace(' ', '_').replace(separator, "_").replace(".schem", "").replace(".schematic", "").replace(".litematic", "");
        if (((String)blueprintString).isEmpty()) {
            blueprintString = "unnamed_" + currentBlueprint;
        }
        BlueprintHeader header = new BlueprintHeader(((String)blueprintString).replace(".bp", ""), authorName, tags, blueprintPreview.getYaw(), blueprintPreview.getPitch(), false, blockRegion.count(), saveAir);
        blueprintString = StringUtils.sanitizePath((String)((String)blueprintString + ".bp")).toLowerCase(Locale.ROOT);
        Path path = Path.of((String.valueOf(blueprintPath) + separator + (String)blueprintString).replace(".bp.bp", ".bp"), new String[0]);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            BlueprintIo.write((OutputStream)outputStream, (BlueprintHeader)header, (class_1011)nativeImage, (ChunkedBlockRegion)blockRegion, (Long2ObjectMap)blockEntities, (List)entities);
        }
        catch (IOException e) {
            assert (class_310.method_1551().field_1724 != null);
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"Failed saving blueprint:").method_27693(e.getMessage()).method_27692(class_124.field_1061));
        }
        nativeImage.close();
    }

    @Environment(value=EnvType.CLIENT)
    public record AdvancedBPRasterize(int distance, ChunkedBlockRegion sourceRegion, ClipboardObject blueprint, boolean extendToGround, class_1937 level) {
        private static Vector3f oldBlueprintPos = new Vector3f();
        private static int yOffset;

        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, class_243 from, class_243 to) {
            yOffset = (int)((double)(this.blueprint.blockRegion().method_31605() / 2));
            Rasterization3D.dda((class_243)from, (class_243)to, (x, y, z) -> {
                if (oldBlueprintPos.distance((float)x, (float)y, (float)z) > (float)this.distance || from.equals((Object)new class_243((double)x, (double)y, (double)z))) {
                    oldBlueprintPos = new Vector3f((float)x, (float)y, (float)z);
                    StampPlacement placement = new StampPlacement(this.blueprint.blockRegion(), this.blueprint.blockEntities(), new TransformedBlockRegions(this.blueprint.blockRegion(), this.blueprint.blockEntities()), 0, false, false, x, y + yOffset, z, x, y, z);
                    ConstantMaskElement mask = new ConstantMaskElement(true);
                    MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
                    if (this.extendToGround) {
                        placement.pasteIntoExtendToGround(chunkedBlockRegion, (Long2ObjectMap)new Long2ObjectOpenHashMap(), maskContext, (MaskElement)mask);
                    } else {
                        placement.pasteInto(chunkedBlockRegion, (Long2ObjectMap)new Long2ObjectOpenHashMap(), maskContext, (MaskElement)mask);
                    }
                }
            });
        }
    }
}

