/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client.BlueprintTools.Conversions;

import com.denni5x.dbtools.client.Utils.BlueprintUtils;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.editor.BlueprintPreview;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.schematic.SchematicLoader;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import imgui.ImGui;
import imgui.type.ImString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class SchemToBlueprintTool
implements Tool {
    private int maxImageCounter = 0;
    private Path blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
    private CompletableFuture<String> blueprintFolderFuture;
    private Path schematicPath = SchematicLoader.getDefaultSchematicDir();
    private CompletableFuture<String> schematicFolderFuture;
    private boolean conversionOngoing = false;
    private int currentSchematic = 0;
    private ArrayList<Path> schematicPaths = new ArrayList();
    private boolean saveAir = false;
    private ClipboardObject currentClipboard = null;
    private CompletableFuture<ClipboardObject> clipboardObjectFuture = null;
    private CompletableFuture<class_1011> blueprintPreviewFuture = null;
    private BlueprintPreview blueprintPreview = null;
    private long startTime = System.currentTimeMillis();
    private long finishTime = System.currentTimeMillis();

    public void reset() {
        this.startTime = 0L;
        this.finishTime = 0L;
        this.currentSchematic = 0;
        this.conversionOngoing = false;
        this.blueprintPreview = null;
        this.currentClipboard = null;
        this.clipboardObjectFuture = null;
        this.schematicPaths.clear();
    }

    public void render(class_4184 camera, float v, long l, class_4587 matrixStack, Matrix4f matrix4f) {
        String folderPath;
        if (this.blueprintFolderFuture != null && this.blueprintFolderFuture.isDone()) {
            folderPath = this.blueprintFolderFuture.join();
            if (folderPath != null && !folderPath.isEmpty()) {
                this.blueprintPath = Path.of(folderPath, new String[0]);
            }
            this.blueprintFolderFuture = null;
        }
        if (this.schematicFolderFuture != null && this.schematicFolderFuture.isDone()) {
            folderPath = this.schematicFolderFuture.join();
            if (folderPath != null && !folderPath.isEmpty()) {
                this.schematicPath = Path.of(folderPath, new String[0]);
            }
            this.schematicFolderFuture = null;
        }
    }

    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText((String)"DBTools: Schematic To Blueprint");
        ImGui.inputText((String)"Schematic Folder Path", (ImString)new ImString(this.schematicPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Schematic Folder")) {
            try {
                this.schematicFolderFuture = AsyncFileDialogs.openFolderDialog((String)this.schematicPath.toString());
            }
            catch (Exception e) {
                this.schematicPath = SchematicLoader.getDefaultSchematicDir();
            }
        }
        ImGui.inputText((String)"Blueprint Folder Path", (ImString)new ImString(this.blueprintPath.toString()), (int)16384);
        if (ImGui.button((String)"Set Blueprint Folder")) {
            try {
                this.blueprintFolderFuture = AsyncFileDialogs.openFolderDialog((String)this.blueprintPath.toString());
            }
            catch (Exception e) {
                this.blueprintPath = Path.of(Axiom.getInstance().getBlueprintDirectory().toString(), new String[0]);
            }
        }
        if (ImGui.checkbox((String)"Save Air", (boolean)this.saveAir)) {
            boolean bl = this.saveAir = !this.saveAir;
        }
        if (ImGui.button((String)AxiomI18n.get((String)"Convert blueprints"))) {
            this.convert();
        }
        if (!this.schematicPaths.isEmpty()) {
            if (!ImGui.isPopupOpen((String)"Schematic To Blueprint")) {
                ImGui.openPopup((String)"Schematic To Blueprint");
            }
            if (ImGuiHelper.beginPopupModal((String)"Schematic To Blueprint", (int)64)) {
                long currentTime;
                int maxIterations = Math.abs(this.schematicPaths.size());
                int percentage = this.currentSchematic * 100 / maxIterations;
                ImGui.text((String)("Progress: " + percentage + "%"));
                if (this.currentSchematic == maxIterations && this.finishTime == 0L) {
                    this.finishTime = System.currentTimeMillis();
                }
                if ((currentTime = System.currentTimeMillis()) < this.startTime) {
                    this.startTime = 0L;
                }
                long duration = this.startTime > 0L && this.finishTime == 0L ? (currentTime - this.startTime) / 1000L : (this.finishTime - this.startTime) / 1000L;
                String durationString = String.format("Elapsed Time: %02d:%02d", duration / 60L, duration % 60L);
                ImGui.text((String)durationString);
                if (this.currentSchematic == maxIterations && this.blueprintPreview == null) {
                    if (ImGui.button((String)"Close")) {
                        this.reset();
                    }
                } else {
                    if (this.conversionOngoing) {
                        this.currentClipboard = this.tryGetNextSchematic();
                        if (this.currentClipboard != null) {
                            String name;
                            if (this.blueprintPreview == null) {
                                this.blueprintPreview = new BlueprintPreview();
                                this.blueprintPreview.setBlockRegion(this.currentClipboard.blockRegion());
                            }
                            class_1011 nativeImage = this.tryGetImage();
                            String string = name = this.currentClipboard.name().isEmpty() ? this.schematicPaths.get(this.currentSchematic).getFileName().toString() : this.currentClipboard.name();
                            if (nativeImage != null) {
                                BlueprintUtils.saveBlueprint(name, class_310.method_1551().field_1724.method_5477().getString(), this.currentClipboard, nativeImage, this.blueprintPath, this.blueprintPreview, this.currentSchematic, this.saveAir);
                                ++this.currentSchematic;
                                this.blueprintPreview = null;
                                this.currentClipboard = null;
                            }
                        }
                    }
                    if (ImGui.button((String)"Cancel")) {
                        this.reset();
                    }
                }
                ImGui.endPopup();
            }
        }
    }

    private ClipboardObject tryGetNextSchematic() {
        if (this.clipboardObjectFuture != null) {
            if (this.clipboardObjectFuture.isDone()) {
                ClipboardObject clipboardObject2 = this.clipboardObjectFuture.join();
                this.clipboardObjectFuture = null;
                if (clipboardObject2 == null) {
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)"Error while reading schematic").method_27692(class_124.field_1061), false);
                    ++this.currentSchematic;
                    return null;
                }
                return clipboardObject2;
            }
        } else {
            Path path = this.schematicPaths.get(this.currentSchematic);
            try {
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                class_2487 tag = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
                if (tag != null && !tag.method_33133()) {
                    while (tag.method_10541().size() == 1) {
                        String key = (String)tag.method_10541().iterator().next();
                        class_2487 inner = tag.method_10562(key).orElse(null);
                        if (inner == null || inner.method_33133()) continue;
                        tag = inner;
                    }
                    this.clipboardObjectFuture = this.loadSchematicAsync(tag).thenApply(clipboardObject -> {
                        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
                        if (!this.saveAir && clipboardObject.containsAir()) {
                            clipboardObject.blockRegion().forEachEntry((x, y, z, state) -> {
                                if (!state.method_26215()) {
                                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, state);
                                }
                            });
                        }
                        if (chunkedBlockRegion.isEmpty()) {
                            clipboardObject.blockRegion().forEachEntry((arg_0, arg_1, arg_2, arg_3) -> ((ChunkedBlockRegion)chunkedBlockRegion).addBlockWithoutDirty(arg_0, arg_1, arg_2, arg_3));
                        }
                        chunkedBlockRegion.dirtyAll();
                        return new ClipboardObject.Anonymous(chunkedBlockRegion, clipboardObject.blockEntities(), clipboardObject.entities(), clipboardObject.name(), clipboardObject.preferredYaw(), this.saveAir);
                    });
                    return null;
                }
            }
            catch (Throwable e) {
                String message = e.getMessage();
                assert (class_310.method_1551().field_1724 != null);
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("Error at: " + message + "with file" + path.toString())).method_27692(class_124.field_1061), false);
                ++this.currentSchematic;
                this.clipboardObjectFuture = null;
            }
        }
        return null;
    }

    private CompletableFuture<ClipboardObject> loadSchematicAsync(class_2487 tag) {
        if (tag.method_10545("Regions")) {
            return CompletableFuture.supplyAsync(() -> SchematicLoader.loadLitematic((class_2487)tag));
        }
        if (tag.method_10545("Version")) {
            return CompletableFuture.supplyAsync(() -> SchematicLoader.loadSponge((class_2487)tag));
        }
        if (!tag.method_10545("Materials")) {
            throw new SchematicLoader.SchematicLoadException("Unknown format");
        }
        return CompletableFuture.supplyAsync(() -> SchematicLoader.loadLegacy((class_2487)tag));
    }

    private class_1011 tryGetImage() {
        if (this.maxImageCounter > 10) {
            this.maxImageCounter = 0;
            this.blueprintPreviewFuture = null;
            return new class_1011(96, 96, true);
        }
        if (this.blueprintPreviewFuture != null) {
            if (this.blueprintPreviewFuture.isDone()) {
                class_1011 nativeImage = this.blueprintPreviewFuture.join();
                this.blueprintPreviewFuture = null;
                return nativeImage;
            }
            ++this.maxImageCounter;
            return null;
        }
        if (this.currentClipboard.blockRegion().count() < 0x1000000 && !this.currentClipboard.blockRegion().isEmpty()) {
            this.blueprintPreview.render(960, false, false);
            this.blueprintPreviewFuture = this.blueprintPreview.toNativeImage(96, true);
            return null;
        }
        return new class_1011(96, 96, true);
    }

    private void convert() {
        this.reset();
        this.conversionOngoing = true;
        this.startTime = System.currentTimeMillis();
        this.getSchematics();
    }

    private void getSchematics() {
        try (Stream<Path> files = Files.list(this.schematicPath);){
            files.filter(path -> path.toString().endsWith(".schem") || path.toString().endsWith(".schematic") || path.toString().endsWith(".litematic")).forEach(path -> this.schematicPaths.add((Path)path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String name() {
        return "DBTools: Schematic To Blueprint";
    }

    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL, AxiomPermission.BUILD_SECTION);
    }

    public char iconChar() {
        return '\ue958';
    }

    public void writeSettings(class_2487 tag) {
    }

    public void loadSettings(class_2487 tag) {
    }

    public String keybindId() {
        return "";
    }
}

