/*
 * Decompiled with CFR 0.152.
 */
package com.denni5x.dbtools.client;

import com.denni5x.dbtools.client.BlueprintTools.BpToPathTool;
import com.denni5x.dbtools.client.BlueprintTools.Conversions.BlueprintToSchemTool;
import com.denni5x.dbtools.client.BlueprintTools.Conversions.SchemToBlueprintTool;
import com.denni5x.dbtools.client.BlueprintTools.CreateTool;
import com.denni5x.dbtools.client.BlueprintTools.PlaceTool;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import imgui.ImFont;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class DBToolsClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"axiom_db_tools");
    public static ImFont icons = null;

    public void onInitializeClient() {
        LOGGER.info("Registering DBTools...");
        ToolManager.addTool((Tool)new PlaceTool());
        ToolManager.addTool((Tool)new CreateTool());
        ToolManager.addTool((Tool)new BlueprintToSchemTool());
        ToolManager.addTool((Tool)new SchemToBlueprintTool());
        ToolManager.addTool((Tool)new BpToPathTool());
    }

    public static byte[] loadFont(String name) {
        try {
            InputStream inputStream = DBToolsClient.class.getClassLoader().getResourceAsStream(name);
            if (inputStream == null) {
                throw new MissingResourceException("Missing font: " + name, "Font", "");
            }
            return inputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

